/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.swipetoshow;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class HideContentHolder
extends FrameLayout {
    private int showPixel = 0;

    public HideContentHolder(Context context) {
        super(context);
        this.init();
    }

    public HideContentHolder(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public HideContentHolder(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
    }

    public void setShowPixel(int showPixel) {
        if (showPixel > this.getWidth()) {
            showPixel = this.getWidth();
        }
        this.showPixel = showPixel;
        this.invalidate();
    }

    public int getShowPixel() {
        return this.showPixel;
    }

    protected void onDraw(Canvas canvas) {
        canvas.clipRect(this.getWidth() - this.showPixel, 0, this.getWidth(), this.getHeight());
        super.onDraw(canvas);
    }
}

