/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.showmoretextview;

import android.content.Context;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.hippo.utils.showmoretextview.SaveState;

public class ShowMoreTextView
extends AppCompatTextView {
    private static final String TAG = ShowMoreTextView.class.getName();
    private int showingLine = 1;
    private int showingChar;
    private boolean isCharEnable;
    private String showMore = "Show more";
    private String showLess = "Show less";
    private String dotdot = "...";
    private int MAGIC_NUMBER = 5;
    private int showMoreTextColor = -65536;
    private int showLessTextColor = -65536;
    private String mainText;
    private boolean isAlreadySet;

    public ShowMoreTextView(Context context) {
        super(context);
    }

    public ShowMoreTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mainText = this.getText().toString();
    }

    public Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
    }

    private void addShowMore() {
        ViewTreeObserver vto = this.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                String text = ShowMoreTextView.this.getText().toString();
                if (!ShowMoreTextView.this.isAlreadySet) {
                    ShowMoreTextView.this.mainText = ShowMoreTextView.this.getText().toString();
                    ShowMoreTextView.this.isAlreadySet = true;
                }
                String showingText = "";
                if (ShowMoreTextView.this.isCharEnable) {
                    if (ShowMoreTextView.this.showingChar >= text.length()) {
                        try {
                            throw new Exception("Character count cannot be exceed total line count");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String newText = text.substring(0, ShowMoreTextView.this.showingChar);
                    newText = newText + ShowMoreTextView.this.dotdot + ShowMoreTextView.this.showMore;
                    SaveState.isCollapse = true;
                    ShowMoreTextView.this.setText(newText);
                    Log.d((String)TAG, (String)("Text: " + newText));
                } else {
                    if (ShowMoreTextView.this.showingLine >= ShowMoreTextView.this.getLineCount()) {
                        try {
                            throw new Exception("Line Number cannot be exceed total line count");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Log.e((String)TAG, (String)("Error: " + e.getMessage()));
                            ShowMoreTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            return;
                        }
                    }
                    int start = 0;
                    for (int i = 0; i < ShowMoreTextView.this.showingLine; ++i) {
                        int end = ShowMoreTextView.this.getLayout().getLineEnd(i);
                        showingText = showingText + text.substring(start, end);
                        start = end;
                    }
                    String newText = showingText.substring(0, showingText.length() - (ShowMoreTextView.this.dotdot.length() + ShowMoreTextView.this.showMore.length() + ShowMoreTextView.this.MAGIC_NUMBER));
                    Log.d((String)TAG, (String)("Text: " + newText));
                    Log.d((String)TAG, (String)("Text: " + showingText));
                    newText = newText + ShowMoreTextView.this.dotdot + ShowMoreTextView.this.showMore;
                    SaveState.isCollapse = true;
                    ShowMoreTextView.this.setText(newText);
                }
                ShowMoreTextView.this.setShowMoreColoringAndClickable();
                ShowMoreTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void setShowMoreColoringAndClickable() {
        SpannableString spannableString = new SpannableString(this.getText());
        Log.d((String)TAG, (String)("Text: " + this.getText()));
        spannableString.setSpan((Object)new ClickableSpan(){

            public void updateDrawState(TextPaint ds) {
                ds.setUnderlineText(false);
            }

            public void onClick(@Nullable View view) {
                ShowMoreTextView.this.setMaxLines(Integer.MAX_VALUE);
                ShowMoreTextView.this.setText(ShowMoreTextView.this.mainText);
                SaveState.isCollapse = false;
                ShowMoreTextView.this.showLessButton();
                Log.d((String)TAG, (String)("Item clicked: " + ShowMoreTextView.this.mainText));
            }
        }, this.getText().length() - (this.dotdot.length() + this.showMore.length()), this.getText().length(), 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(this.showMoreTextColor), this.getText().length() - (this.dotdot.length() + this.showMore.length()), this.getText().length(), 33);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
    }

    private void showLessButton() {
        String text = this.getText() + this.dotdot + this.showLess;
        SpannableString spannableString = new SpannableString((CharSequence)text);
        spannableString.setSpan((Object)new ClickableSpan(){

            public void updateDrawState(TextPaint ds) {
                ds.setUnderlineText(false);
            }

            public void onClick(@Nullable View view) {
                ShowMoreTextView.this.setMaxLines(ShowMoreTextView.this.showingLine);
                ShowMoreTextView.this.addShowMore();
                Log.d((String)TAG, (String)"Item clicked: ");
            }
        }, text.length() - (this.dotdot.length() + this.showLess.length()), text.length(), 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(this.showLessTextColor), text.length() - (this.dotdot.length() + this.showLess.length()), text.length(), 33);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
    }

    public void setShowingLine(int lineNumber) {
        if (lineNumber == 0) {
            try {
                throw new Exception("Line Number cannot be 0");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.isCharEnable = false;
        this.showingLine = lineNumber;
        this.setMaxLines(this.showingLine);
        if (SaveState.isCollapse) {
            this.addShowMore();
        } else {
            this.setMaxLines(Integer.MAX_VALUE);
            this.showLessButton();
        }
    }

    public void setShowingChar(int character) {
        if (character == 0) {
            try {
                throw new Exception("Character length cannot be 0");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.isCharEnable = true;
        this.showingChar = character;
        if (SaveState.isCollapse) {
            this.addShowMore();
        } else {
            this.setMaxLines(Integer.MAX_VALUE);
            this.showLessButton();
        }
    }

    public void addShowMoreText(String text) {
        this.showMore = text;
    }

    public void addShowLessText(String text) {
        this.showLess = text;
    }

    public void setShowMoreColor(int color2) {
        this.showMoreTextColor = color2;
    }

    public void setShowLessTextColor(int color2) {
        this.showLessTextColor = color2;
    }
}

