/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.langs.Restring;
import com.hippo.utils.filepicker.DividerGridItemDecoration;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.ImageDirectoryAdapter;
import com.hippo.utils.filepicker.adapter.ImagePickAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImagePickActivity
extends BaseActivity {
    public static final String IS_NEED_CAMERA = "IsNeedCamera";
    public static final String IS_NEED_IMAGE_PAGER = "IsNeedImagePager";
    public static final String IS_TAKEN_AUTO_SELECTED = "IsTakenAutoSelected";
    public static final int DEFAULT_MAX_NUMBER = 1;
    private int mMaxNumber;
    private int mCurrentNumber = 0;
    private RecyclerView mRecyclerView;
    private ImagePickAdapter mAdapter;
    private ImageDirectoryAdapter directoryAdapter;
    private boolean isNeedCamera;
    private boolean isNeedImagePager;
    private boolean isTakenAutoSelected;
    public ArrayList<ImageFile> mSelectedList = new ArrayList();
    private GridLayoutManager layoutManager;
    private boolean isDirectory;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                ImagePickActivity.this.loadData();
            }
        });
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.mMaxNumber = this.getIntent().getIntExtra("MaxNumber", 1);
        this.isNeedCamera = this.getIntent().getBooleanExtra(IS_NEED_CAMERA, false);
        this.isNeedImagePager = this.getIntent().getBooleanExtra(IS_NEED_IMAGE_PAGER, true);
        this.isTakenAutoSelected = this.getIntent().getBooleanExtra(IS_TAKEN_AUTO_SELECTED, true);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        String title = Restring.getString((Context)this, R.string.hippo_image_picker);
        this.setToolbar(this.myToolbar, title);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        this.layoutManager = new GridLayoutManager((Context)this, 2);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerGridItemDecoration((Context)this));
        this.mAdapter = new ImagePickAdapter((Context)this, this.isNeedCamera, this.isNeedImagePager, this.mMaxNumber);
        this.directoryAdapter = new ImageDirectoryAdapter((Context)this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        this.directoryAdapter.setOnSelectStateListener(new OnSelectStateListener<Directory>(){

            @Override
            public void OnSelectStateChanged(boolean state, Directory file) {
                ImagePickActivity.this.isDirectory = true;
                ImagePickActivity.this.layoutManager.setSpanCount(3);
                ImagePickActivity.this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)ImagePickActivity.this.layoutManager);
                ArrayList list = new ArrayList();
                list.addAll(file.getFiles());
                ImagePickActivity.this.mAdapter.refresh(list);
                ImagePickActivity.this.mRecyclerView.setAdapter((RecyclerView.Adapter)ImagePickActivity.this.mAdapter);
                ImagePickActivity.this.runLayoutAnimation(ImagePickActivity.this.mRecyclerView);
            }
        });
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<ImageFile>(){

            @Override
            public void OnSelectStateChanged(boolean state, ImageFile file) {
                ImagePickActivity.this.mSelectedList.add(file);
                ImagePickActivity.this.mCurrentNumber++;
                Intent intent = new Intent();
                intent.putParcelableArrayListExtra("ResultPickImage", ImagePickActivity.this.mSelectedList);
                ImagePickActivity.this.setResult(-1, intent);
                ImagePickActivity.this.finish();
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 257: {
                if (resultCode == -1) {
                    Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                    File file = new File(this.mAdapter.mImagePath);
                    Uri contentUri = Uri.fromFile((File)file);
                    mediaScanIntent.setData(contentUri);
                    this.sendBroadcast(mediaScanIntent);
                    this.loadData();
                    break;
                }
                this.getApplicationContext().getContentResolver().delete(this.mAdapter.mImageUri, null, null);
                break;
            }
            case 258: {
                if (resultCode != -1) break;
                ArrayList list = data.getParcelableArrayListExtra("ResultBrowserImage");
                this.mCurrentNumber = list.size();
                this.mAdapter.setCurrentNumber(this.mCurrentNumber);
                this.mSelectedList.clear();
                this.mSelectedList.addAll(list);
                for (ImageFile file : this.mAdapter.getDataSet()) {
                    if (this.mSelectedList.contains(file)) {
                        file.setSelected(true);
                        continue;
                    }
                    file.setSelected(false);
                }
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    private void loadData() {
        FileFilter.getImages((FragmentActivity)this, new FilterResultCallback<ImageFile>(){

            @Override
            public void onResult(List<Directory<ImageFile>> directories) {
                if (ImagePickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> list = new ArrayList<Directory>();
                    Directory all = new Directory();
                    all.setName(ImagePickActivity.this.getResources().getString(R.string.vw_all));
                    list.add(all);
                    list.addAll(directories);
                    ImagePickActivity.this.mFolderHelper.fillData(list);
                }
                ImagePickActivity.this.refreshData(directories);
            }
        });
    }

    public void onBackPressed() {
        if (this.isDirectory) {
            this.isDirectory = false;
            this.layoutManager.setSpanCount(2);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.directoryAdapter);
        } else {
            super.onBackPressed();
        }
    }

    private void refreshData(List<Directory<ImageFile>> directories) {
        ArrayList<Directory<ImageFile>> directoryList = new ArrayList<Directory<ImageFile>>();
        directoryList.addAll(directories);
        this.directoryAdapter.refresh(directoryList);
    }

    private void runLayoutAnimation(RecyclerView recyclerView) {
        Context context = recyclerView.getContext();
        LayoutAnimationController controller = AnimationUtils.loadLayoutAnimation((Context)context, (int)R.anim.hippo_layout_animation_from_bottom);
        recyclerView.setLayoutAnimation(controller);
        recyclerView.getAdapter().notifyDataSetChanged();
        recyclerView.scheduleLayoutAnimation();
    }
}

