/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions.helper;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.hippo.utils.easypermissions.RationaleDialogFragmentCompat;
import com.hippo.utils.easypermissions.helper.PermissionHelper;

public abstract class BaseSupportPermissionsHelper<T>
extends PermissionHelper<T> {
    private static final String TAG = "BSPermissionsHelper";

    public BaseSupportPermissionsHelper(@NonNull T host) {
        super(host);
    }

    public abstract FragmentManager getSupportFragmentManager();

    @Override
    public void showRequestPermissionRationale(@NonNull String rationale, @NonNull String positiveButton, @NonNull String negativeButton, @StyleRes int theme, int requestCode, String ... perms) {
        FragmentManager fm = this.getSupportFragmentManager();
        Fragment fragment = fm.findFragmentByTag("RationaleDialogFragmentCompat");
        if (fragment instanceof RationaleDialogFragmentCompat) {
            Log.d((String)TAG, (String)"Found existing fragment, not showing rationale.");
            return;
        }
        RationaleDialogFragmentCompat.newInstance(rationale, positiveButton, negativeButton, theme, requestCode, perms).showAllowingStateLoss(fm, "RationaleDialogFragmentCompat");
    }
}

