/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.customROM;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutoStartPermissionHelper {
    private String PACKAGE_XIAOMI_MAIN = "com.miui.securitycenter";
    private String PACKAGE_XIAOMI_COMPONENT = "com.miui.permcenter.autostart.AutoStartManagementActivity";
    private List<String> XIAOMI_PACKAGES = Collections.singletonList(this.PACKAGE_XIAOMI_COMPONENT);
    private String PACKAGE_LETV_MAIN = "com.letv.android.letvsafe";
    private String PACKAGE_LETV_COMPONENT = "com.letv.android.letvsafe.AutobootManageActivity";
    private List<String> LETV_PACKAGES = Collections.singletonList(this.PACKAGE_LETV_COMPONENT);
    private String PACKAGE_ASUS_MAIN = "com.asus.mobilemanager";
    private String PACKAGE_ASUS_COMPONENT = "com.asus.mobilemanager.powersaver.PowerSaverSettings";
    private List<String> ASUS_PACKAGES = Collections.singletonList(this.PACKAGE_ASUS_COMPONENT);
    private String PACKAGE_HONOR_MAIN = "com.huawei.systemmanager";
    private String PACKAGE_HONOR_COMPONENT = "com.huawei.systemmanager.optimize.process.ProtectActivity";
    private List<String> HONOR_PACKAGES = Collections.singletonList(this.PACKAGE_HONOR_COMPONENT);
    private String PACKAGE_HUAWEI_MAIN = "com.huawei.systemmanager";
    private String PACKAGE_HUAWEI_COMPONENT = "com.huawei.systemmanager.optimize.process.ProtectActivity";
    private List<String> HUAWEI_PACKAGES = Collections.singletonList(this.PACKAGE_HUAWEI_COMPONENT);
    private String PACKAGE_OPPO_MAIN = "com.coloros.safecenter";
    private String PACKAGE_OPPO_MAIN_FALLBACK = "com.oppo.safe";
    private String PACKAGE_OPPO_COMPONENT = "com.coloros.safecenter.permission.startup.StartupAppListActivity";
    private String PACKAGE_OPPO_COMPONENT_FALLBACK = "com.oppo.safe.permission.startup.StartupAppListActivity";
    private String PACKAGE_OPPO_COMPONENT_FALLBACK_A = "com.coloros.safecenter.startupapp.StartupAppListActivity";
    private List<String> OPPO_PACKAGES = Arrays.asList(this.PACKAGE_OPPO_COMPONENT, this.PACKAGE_OPPO_COMPONENT_FALLBACK, this.PACKAGE_OPPO_COMPONENT_FALLBACK_A);
    private String PACKAGE_VIVO_MAIN = "com.iqoo.secure";
    private String PACKAGE_VIVO_MAIN_FALLBACK = "com.vivo.permissionmanager";
    private String PACKAGE_VIVO_COMPONENT = "com.iqoo.secure.ui.phoneoptimize.AddWhiteListActivity";
    private String PACKAGE_VIVO_COMPONENT_FALLBACK = "com.vivo.permissionmanager.activity.BgStartUpManagerActivity";
    private String PACKAGE_VIVO_COMPONENT_FALLBACK_A = "com.iqoo.secure.ui.phoneoptimize.BgStartUpManager";
    private List<String> VIVO_PACKAGES = Arrays.asList(this.PACKAGE_VIVO_COMPONENT, this.PACKAGE_VIVO_COMPONENT_FALLBACK, this.PACKAGE_VIVO_COMPONENT_FALLBACK_A);
    private String PACKAGE_NOKIA_MAIN = "com.evenwell.powersaving.g3";
    private String PACKAGE_NOKIA_COMPONENT = "com.evenwell.powersaving.g3.exception.PowerSaverExceptionActivity";
    private List<String> NOKIA_PACKAGES = Collections.singletonList(this.PACKAGE_NOKIA_COMPONENT);
    private String PACKAGE_ONEPLUS_MAIN = "com.oneplus.security";
    private String PACKAGE_ONEPLUS_COMPONENT = "com.oneplus.security.chainlaunch.view.ChainLaunchAppListAct\u200c\u200bivity";
    private List<String> ONEPLUS_PACKAGES = Collections.singletonList(this.PACKAGE_ONEPLUS_COMPONENT);
    Map<String, List<String>> PACKAGES = new HashMap<String, List<String>>(){
        {
            this.put(AutoStartPermissionHelper.this.PACKAGE_XIAOMI_MAIN, AutoStartPermissionHelper.this.XIAOMI_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_LETV_MAIN, AutoStartPermissionHelper.this.LETV_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_ASUS_MAIN, AutoStartPermissionHelper.this.ASUS_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_HONOR_MAIN, AutoStartPermissionHelper.this.HONOR_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_HUAWEI_MAIN, AutoStartPermissionHelper.this.HUAWEI_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_OPPO_MAIN, AutoStartPermissionHelper.this.OPPO_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_OPPO_MAIN_FALLBACK, AutoStartPermissionHelper.this.OPPO_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_VIVO_MAIN, AutoStartPermissionHelper.this.VIVO_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_VIVO_MAIN_FALLBACK, AutoStartPermissionHelper.this.VIVO_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_NOKIA_MAIN, AutoStartPermissionHelper.this.NOKIA_PACKAGES);
            this.put(AutoStartPermissionHelper.this.PACKAGE_ONEPLUS_MAIN, AutoStartPermissionHelper.this.ONEPLUS_PACKAGES);
        }
    };
    private static AutoStartPermissionHelper INSTANCE = null;

    private AutoStartPermissionHelper() {
    }

    public static AutoStartPermissionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoStartPermissionHelper();
        }
        return INSTANCE;
    }

    public boolean isAutoStartPermissionAvailable(Context context) {
        List packages = context.getPackageManager().getInstalledApplications(0);
        for (ApplicationInfo appInfo : packages) {
            if (!this.PACKAGES.keySet().contains(appInfo.packageName)) continue;
            return true;
        }
        return false;
    }

    public void getAutoStartPermission(Context context) {
        List packages = context.getPackageManager().getInstalledApplications(0);
        for (ApplicationInfo appInfo : packages) {
            List<String> components;
            String mainPackage = appInfo.packageName;
            if (!this.PACKAGES.keySet().contains(mainPackage) || (components = this.PACKAGES.get(mainPackage)) == null || !this.startIntent(context, mainPackage, components)) continue;
            return;
        }
    }

    private boolean startIntent(Context context, String mainPackage, List<String> components) {
        Intent intent = new Intent();
        for (String component : components) {
            try {
                intent.setComponent(new ComponentName(mainPackage, component));
                context.startActivity(intent);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private void showActivity(Context context, @NonNull String packageName) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        context.startActivity(intent);
    }

    private void showActivity(Context context, @NonNull String packageName, @NonNull String activityDir) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityDir));
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static boolean isOPPO() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("oppo");
    }

    private void goOPPOSetting(Context context) {
        try {
            this.showActivity(context, "com.coloros.phonemanager");
        }
        catch (Exception e1) {
            try {
                this.showActivity(context, "com.oppo.safe");
            }
            catch (Exception e2) {
                try {
                    this.showActivity(context, "com.coloros.oppoguardelf");
                }
                catch (Exception e3) {
                    this.showActivity(context, "com.coloros.safecenter");
                }
            }
        }
    }

    public static boolean isVIVO() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("vivo");
    }

    private void goVIVOSetting(Context context) {
        this.showActivity(context, "com.iqoo.secure");
    }

    public static boolean isSamsung() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("samsung");
    }

    private void goSamsungSetting(Context context) {
        try {
            this.showActivity(context, "com.samsung.android.sm_cn");
        }
        catch (Exception e) {
            this.showActivity(context, "com.samsung.android.sm");
        }
    }

    public static void requestIgnoreBatteryOptimization(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Intent intent = new Intent();
                String packageName = context.getPackageName();
                PowerManager pm = (PowerManager)context.getSystemService("power");
                if (pm.isIgnoringBatteryOptimizations(packageName)) {
                    intent.setAction("android.settings.IGNORE_BATTERY_OPTIMIZATION_SETTINGS");
                } else {
                    intent.setAction("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
                    intent.setData(Uri.parse((String)("package:" + packageName)));
                }
                context.startActivity(intent);
            }
            catch (Exception e) {
                Log.d((String)"TAG", (String)"Could not set ignoring battery optimization");
            }
        }
    }

    private void addAutoStartupswitch(Context context) {
        try {
            Intent intent = new Intent();
            String manufacturer = Build.MANUFACTURER.toLowerCase();
            String model = Build.MODEL;
            Log.d((String)"DeviceModel", (String)model.toString());
            switch (manufacturer) {
                case "xiaomi": {
                    intent.setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity"));
                    break;
                }
                case "oppo": {
                    intent.setComponent(new ComponentName("com.coloros.safecenter", "com.coloros.safecenter.permission.startup.StartupAppListActivity"));
                    break;
                }
                case "vivo": {
                    intent.setComponent(new ComponentName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.BgStartUpManagerActivity"));
                    break;
                }
                case "Letv": {
                    intent.setComponent(new ComponentName("com.letv.android.letvsafe", "com.letv.android.letvsafe.AutobootManageActivity"));
                    break;
                }
                case "Honor": {
                    intent.setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity"));
                    break;
                }
                case "oneplus": {
                    intent.setComponent(new ComponentName("com.oneplus.security", "com.oneplus.security.chainlaunch.view.ChainLaunchAppListAct\u200c\u200bivity"));
                }
            }
            List list = context.getPackageManager().queryIntentActivities(intent, 65536);
            if (list.size() > 0) {
                context.startActivity(intent);
            }
        }
        catch (Exception e) {
            Log.e((String)"exc", (String)String.valueOf(e));
        }
    }
}

