/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.hippo.R;

public class RatingBar
extends View {
    private static final String TAG = "RatingBar";
    protected static final int DEFAULT_FILLED_DRAWABLE = R.drawable.ic_hippo_selected_star;
    protected static final int DEFAULT_EMPTY_DRAWABLE = R.drawable.ic_hippo_empty_star;
    private int mMaxCount = 5;
    private float mRating;
    private int mMinSelectionAllowed = 0;
    private int mStarSize = 0;
    private boolean isIndicator = false;
    private float mStepSize = 1.0f;
    private boolean selectTheTappedRating = true;
    @DrawableRes
    private int filledDrawable;
    @DrawableRes
    private int emptyDrawable;
    private Drawable baseDrawable;
    private ClipDrawable overlayDrawable;
    private int mMargin;
    private OnRatingBarChangeListener mRatingBarListener = null;
    private final View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (RatingBar.this.isIndicator) {
                return true;
            }
            float x = (int)event.getX();
            float selectedAmount = 0.0f;
            if (x >= 0.0f && x <= (float)RatingBar.this.getWidth()) {
                int xPerStar = RatingBar.this.mMargin * 2 + RatingBar.this.mStarSize;
                if (x < (float)xPerStar * 0.25f) {
                    selectedAmount = 0.0f;
                } else {
                    if (RatingBar.this.mStepSize <= 0.0f) {
                        RatingBar.this.mStepSize = 0.1f;
                    }
                    selectedAmount = RatingBar.this.getSelectedRating(x, xPerStar, RatingBar.this.mStepSize);
                }
            }
            if (x < 0.0f) {
                selectedAmount = 0.0f;
            } else if (x > (float)RatingBar.this.getWidth()) {
                selectedAmount = RatingBar.this.mMaxCount;
            }
            RatingBar.this.setRating(selectedAmount, true);
            return true;
        }
    };

    public RatingBar(Context context) {
        super(context);
        this.init(null);
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    protected void init(AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.RatingBar);
            this.filledDrawable = a.getResourceId(R.styleable.RatingBar_filledDrawable, DEFAULT_FILLED_DRAWABLE);
            this.emptyDrawable = a.getResourceId(R.styleable.RatingBar_emptyDrawable, DEFAULT_EMPTY_DRAWABLE);
            this.mStarSize = a.getDimensionPixelSize(R.styleable.RatingBar_starSize, this.getPixelValueForDP(20));
            this.mMaxCount = a.getInt(R.styleable.RatingBar_numStars, 5);
            this.mMinSelectionAllowed = a.getInt(R.styleable.RatingBar_minAllowedStars, 0);
            this.mMargin = a.getDimensionPixelSize(R.styleable.RatingBar_starSpacing, this.getPixelValueForDP(5));
            this.mRating = a.getFloat(R.styleable.RatingBar_rating, (float)this.mMinSelectionAllowed);
            this.isIndicator = a.getBoolean(R.styleable.RatingBar_isIndicator, false);
            this.mStepSize = a.getFloat(R.styleable.RatingBar_stepSize, 1.0f);
            this.selectTheTappedRating = a.getBoolean(R.styleable.RatingBar_selectTheTappedRating, false);
            a.recycle();
        } else {
            this.setDefaultDrawables();
        }
        this.setEmptyDrawable(this.emptyDrawable);
        this.setFilledDrawable(this.filledDrawable);
        this.setIsIndicator(this.isIndicator);
    }

    private void setDefaultDrawables() {
        this.setFilledDrawable(DEFAULT_FILLED_DRAWABLE);
        this.setEmptyDrawable(DEFAULT_EMPTY_DRAWABLE);
    }

    private void setRating(float newRating, boolean fromUser) {
        float mod = newRating % this.mStepSize;
        if (mod < this.mStepSize) {
            mod = 0.0f;
        }
        this.mRating = newRating - mod;
        if (this.mRating < (float)this.mMinSelectionAllowed) {
            this.mRating = this.mMinSelectionAllowed;
        } else if (this.mRating > (float)this.mMaxCount) {
            this.mRating = this.mMaxCount;
        }
        if (this.mRatingBarListener != null) {
            this.mRatingBarListener.onRatingChanged(this, this.mRating, fromUser);
        }
        this.postInvalidate();
    }

    public void setRating(float rating) {
        this.setRating(rating, false);
    }

    public void setShouldSelectTheTappedRating(boolean selectTheTappedRating) {
        this.selectTheTappedRating = selectTheTappedRating;
    }

    public float getRating() {
        return this.mRating;
    }

    public void setMax(int count) {
        this.mMaxCount = count;
        this.post(new Runnable(){

            @Override
            public void run() {
                RatingBar.this.requestLayout();
            }
        });
    }

    public int getMax() {
        return this.mMaxCount;
    }

    public void setMinimumSelectionAllowed(int minStarCount) {
        this.mMinSelectionAllowed = minStarCount;
        this.postInvalidate();
    }

    public int getMinimumSelectionAllowed() {
        return this.mMinSelectionAllowed;
    }

    public void setStarMarginsInDP(int marginInDp) {
        this.setStarMargins(this.getPixelValueForDP(marginInDp));
    }

    public void setStarMargins(int margins) {
        this.mMargin = margins;
        this.post(new Runnable(){

            @Override
            public void run() {
                RatingBar.this.requestLayout();
            }
        });
    }

    public int getMargin() {
        return this.mMargin;
    }

    private int getPixelValueForDP(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setStarSizeInDp(int size) {
        this.setStarSize(this.getPixelValueForDP(size));
    }

    public void setStarSize(int size) {
        this.mStarSize = size;
        if (this.baseDrawable != null) {
            this.baseDrawable.setBounds(0, 0, this.mStarSize, this.mStarSize);
        }
        if (this.overlayDrawable != null) {
            this.overlayDrawable.setBounds(0, 0, this.mStarSize, this.mStarSize);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                RatingBar.this.requestLayout();
            }
        });
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void createFilledClipDrawable(@NonNull Drawable d) {
        this.overlayDrawable = new ClipDrawable(d, 3, 1);
        this.overlayDrawable.setBounds(0, 0, this.mStarSize, this.mStarSize);
    }

    public void setFilledDrawable(Drawable filledDrawable) {
        if (this.overlayDrawable == null) {
            if (filledDrawable != null) {
                this.createFilledClipDrawable(filledDrawable);
            }
        } else if (filledDrawable == null) {
            this.overlayDrawable = null;
        } else {
            this.createFilledClipDrawable(filledDrawable);
        }
        this.postInvalidate();
    }

    public void setFilledDrawable(@DrawableRes int filledDrawable) {
        Drawable newVersion = ContextCompat.getDrawable((Context)this.getContext(), (int)filledDrawable);
        this.setFilledDrawable(newVersion);
    }

    public void setEmptyDrawable(Drawable emptyDrawable) {
        this.baseDrawable = emptyDrawable;
        this.baseDrawable.setBounds(0, 0, this.mStarSize, this.mStarSize);
        this.postInvalidate();
    }

    public void setEmptyDrawable(@DrawableRes int emptyDrawable) {
        this.emptyDrawable = emptyDrawable;
        Drawable d = ContextCompat.getDrawable((Context)this.getContext(), (int)emptyDrawable);
        this.setEmptyDrawable(d);
    }

    public void setIsIndicator(boolean isIndicator) {
        this.isIndicator = isIndicator;
        if (this.isIndicator) {
            super.setOnTouchListener(null);
        } else {
            super.setOnTouchListener(this.mTouchListener);
        }
    }

    public void setOnTouchListener(View.OnTouchListener l) {
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener listener) {
        this.mRatingBarListener = listener;
    }

    public OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return this.mRatingBarListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.mMargin * 2 + this.mStarSize;
        int width = height * this.mMaxCount;
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float movedX = 0.0f;
        canvas.translate(0.0f, (float)this.mMargin);
        float remaining = this.mRating;
        for (int i = 0; i < this.mMaxCount; ++i) {
            canvas.translate((float)this.mMargin, 0.0f);
            movedX += (float)this.mMargin;
            if (this.baseDrawable != null) {
                this.baseDrawable.draw(canvas);
            }
            if (this.overlayDrawable != null) {
                if (remaining >= 1.0f) {
                    this.overlayDrawable.setLevel(10000);
                    this.overlayDrawable.draw(canvas);
                } else if (remaining > 0.0f) {
                    this.overlayDrawable.setLevel((int)(remaining * 10000.0f));
                    this.overlayDrawable.draw(canvas);
                } else {
                    this.overlayDrawable.setLevel(0);
                }
                remaining -= 1.0f;
            }
            canvas.translate((float)this.mStarSize, 0.0f);
            movedX += (float)this.mStarSize;
            canvas.translate((float)this.mMargin, 0.0f);
            movedX += (float)this.mMargin;
        }
        canvas.translate(movedX * -1.0f, (float)(this.mMargin * -1));
    }

    protected float getSelectedRating(float xOfRating, int xPerStar, float stepSize) {
        float selectedAmount = (xOfRating - (float)xPerStar) / (float)xPerStar + 1.0f;
        float remainder = selectedAmount % stepSize;
        selectedAmount -= remainder;
        if (this.selectTheTappedRating) {
            float directionalStep = Math.signum(remainder) * stepSize;
            selectedAmount += directionalStep;
        }
        return selectedAmount;
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(RatingBar var1, float var2, boolean var3);
    }
}

