/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import java.util.HashMap;

public class KeyboardUtil
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final int MAGIC_NUMBER = 200;
    private SoftKeyboardToggleListener mCallback;
    private View mRootView;
    private Boolean prevValue = null;
    private float mScreenDensity;
    private static HashMap<SoftKeyboardToggleListener, KeyboardUtil> sListenerMap = new HashMap();

    public void onGlobalLayout() {
        boolean isVisible;
        Rect r = new Rect();
        this.mRootView.getWindowVisibleDisplayFrame(r);
        int heightDiff = this.mRootView.getRootView().getHeight() - (r.bottom - r.top);
        float dp = (float)heightDiff / this.mScreenDensity;
        boolean bl = isVisible = dp > 200.0f;
        if (this.mCallback != null && (this.prevValue == null || isVisible != this.prevValue)) {
            this.prevValue = isVisible;
            this.mCallback.onToggleSoftKeyboard(isVisible);
        }
    }

    public static void addKeyboardToggleListener(Activity act, SoftKeyboardToggleListener listener) {
        KeyboardUtil.removeKeyboardToggleListener(listener);
        sListenerMap.put(listener, new KeyboardUtil(act, listener));
    }

    public static void removeKeyboardToggleListener(SoftKeyboardToggleListener listener) {
        if (sListenerMap.containsKey(listener)) {
            KeyboardUtil k = sListenerMap.get(listener);
            k.removeListener();
            sListenerMap.remove(listener);
        }
    }

    public static void removeAllKeyboardToggleListeners() {
        for (SoftKeyboardToggleListener l : sListenerMap.keySet()) {
            sListenerMap.get(l).removeListener();
        }
        sListenerMap.clear();
    }

    public static void toggleKeyboardVisibility(Context context) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.toggleSoftInput(2, 0);
        }
    }

    public static void forceCloseKeyboard(View activeView) {
        InputMethodManager inputMethodManager = (InputMethodManager)activeView.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(activeView.getWindowToken(), 0);
        }
    }

    private void removeListener() {
        this.mCallback = null;
        this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private KeyboardUtil(Activity act, SoftKeyboardToggleListener listener) {
        this.mCallback = listener;
        this.mRootView = ((ViewGroup)act.findViewById(0x1020002)).getChildAt(0);
        this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.mScreenDensity = act.getResources().getDisplayMetrics().density;
    }

    public static interface SoftKeyboardToggleListener {
        public void onToggleSoftKeyboard(boolean var1);
    }
}

