/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.langs;

import android.content.Context;
import com.hippo.langs.FetchLanguageData;
import com.hippo.langs.Restring;
import com.hippo.langs.Translation;
import com.hippo.utils.fileUpload.Prefs;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/hippo/langs/LanguageManager;", "", "()V", "defaultLang", "", "getDefaultLang", "()Ljava/lang/String;", "language", "getLanguage", "context", "Landroid/content/Context;", "isEnglishLanguage", "", "setLanguage", "", "value", "setLanguageStrings", "translations", "Lcom/hippo/langs/Translation;", "languageCode", "updateLanguage", "hippo_release"})
public final class LanguageManager {
    @NotNull
    private static final String language = "language";
    @NotNull
    private static final String defaultLang = "en";
    public static final LanguageManager INSTANCE;

    @NotNull
    public final String getLanguage() {
        return language;
    }

    @NotNull
    public final String getDefaultLang() {
        return defaultLang;
    }

    @NotNull
    public final String getLanguage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string2 = Prefs.with(context).getString(language, defaultLang);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Prefs.with(context).getS\u2026ng(language, defaultLang)");
        return string2;
    }

    public final boolean isEnglishLanguage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String language = defaultLang;
        return Intrinsics.areEqual((Object)this.getLanguage(context), (Object)language);
    }

    public final void setLanguageStrings(@NotNull Context context, @NotNull Translation translations, @NotNull String languageCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)translations, (String)"translations");
        Intrinsics.checkParameterIsNotNull((Object)languageCode, (String)"languageCode");
        this.setLanguage(context, languageCode);
        Restring.saveStrings(translations);
    }

    public final void updateLanguage(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)language);
        FetchLanguageData.INSTANCE.fetchLanguage(language);
    }

    private final void setLanguage(Context context, String value) {
        Prefs.with(context).save(language, value);
    }

    private LanguageManager() {
    }

    static {
        LanguageManager languageManager;
        INSTANCE = languageManager = new LanguageManager();
        language = language;
        defaultLang = defaultLang;
    }
}

