/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.utils.HippoLog;

public abstract class BaseFragment
extends Fragment {
    void setTitle(String title) {
        HippoLog.d("Text", "text = " + title);
    }

    public ActionBar setToolbar(Toolbar toolbar, String title) {
        ((AppCompatActivity)this.getActivity()).setSupportActionBar(toolbar);
        ActionBar ab = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        if (ab != null) {
            ab.setBackgroundDrawable((Drawable)new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setHomeButtonEnabled(false);
            ab.setTitle((CharSequence)"");
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setText((CharSequence)title);
            ((TextView)toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return ((AppCompatActivity)this.getActivity()).getSupportActionBar();
    }

    private void doStyleSpanForSecondString(String firstString, String lastString, TextView txtSpan, HippoColorConfig hippoColorConfig) throws Exception {
        String changeString = lastString != null ? lastString : "";
        String totalString = firstString + " " + changeString;
        SpannableString spanText = new SpannableString((CharSequence)totalString);
        spanText.setSpan((Object)new StyleSpan(1), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan((Object)new ForegroundColorSpan(hippoColorConfig.getHippoActionBarBg()), String.valueOf(firstString).length(), totalString.length(), 0);
        spanText.setSpan((Object)new RelativeSizeSpan(0.8f), 0, String.valueOf(firstString).length(), 0);
        txtSpan.setText((CharSequence)spanText);
    }

    public void setupUI(View view) throws Exception {
        if (!(view instanceof EditText)) {
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    try {
                        InputMethodManager inputMethodManager = (InputMethodManager)BaseFragment.this.getActivity().getSystemService("input_method");
                        inputMethodManager.hideSoftInputFromWindow(BaseFragment.this.getActivity().getCurrentFocus().getWindowToken(), 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            });
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View innerView = ((ViewGroup)view).getChildAt(i);
                this.setupUI(innerView);
            }
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }
}

