/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.helper;

import android.R;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.service.FuguPushIntentService;
import com.hippo.utils.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/hippo/helper/PushHandler;", "Lcom/hippo/constant/FuguAppConstant;", "()V", "CHANNEL_ONE_NAME", "", "getCHANNEL_ONE_NAME", "()Ljava/lang/String;", "NOTIFICATION_CHANNEL_ID", "getNOTIFICATION_CHANNEL_ID", "getPriority", "", "getTimeMilliSec", "", "timeStamp", "notificationMissedCall", "", "context", "Landroid/content/Context;", "data", "Lorg/json/JSONObject;", "icon", "showMissedCall", "hippo_release"})
public final class PushHandler
implements FuguAppConstant {
    @NotNull
    private final String NOTIFICATION_CHANNEL_ID = "12001";
    @NotNull
    private final String CHANNEL_ONE_NAME = "Default notification";

    @NotNull
    public final String getNOTIFICATION_CHANNEL_ID() {
        return this.NOTIFICATION_CHANNEL_ID;
    }

    @NotNull
    public final String getCHANNEL_ONE_NAME() {
        return this.CHANNEL_ONE_NAME;
    }

    public final void notificationMissedCall(@NotNull Context context, @NotNull JSONObject data, int icon) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.showMissedCall(context, data, icon);
    }

    private final void showMissedCall(Context context, JSONObject data, int icon) {
        String string2 = data.optString("message");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.optString(\"message\")");
        String message = string2;
        String string3 = data.optString("title");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"data.optString(\"title\")");
        String title = string3;
        String timeStamp = data.optString("date_time");
        long channelId = data.optLong("channel_id", -1L);
        Intent notificationIntent = new Intent(context, FuguPushIntentService.class);
        notificationIntent.putExtra("channelId", channelId);
        notificationIntent.putExtra("json", data.toString());
        notificationIntent.putExtra("is_from_push", true);
        FuguPutUserDetailsResponse fuguPutUserDetailsResponse = CommonData.getUserDetails();
        Intrinsics.checkExpressionValueIsNotNull((Object)fuguPutUserDetailsResponse, (String)"CommonData.getUserDetails()");
        FuguPutUserDetailsResponse.Data data2 = fuguPutUserDetailsResponse.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"CommonData.getUserDetails().data");
        notificationIntent.putExtra("en_user_id", data2.getEn_user_id());
        FuguPutUserDetailsResponse fuguPutUserDetailsResponse2 = CommonData.getUserDetails();
        Intrinsics.checkExpressionValueIsNotNull((Object)fuguPutUserDetailsResponse2, (String)"CommonData.getUserDetails()");
        FuguPutUserDetailsResponse.Data data3 = fuguPutUserDetailsResponse2.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data3, (String)"CommonData.getUserDetails().data");
        Long l = data3.getUserId();
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"CommonData.getUserDetails().data.userId");
        notificationIntent.putExtra("userId", l.longValue());
        notificationIntent.setFlags(0x10008000);
        PendingIntent pi = PendingIntent.getService((Context)context, (int)112, (Intent)notificationIntent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, this.NOTIFICATION_CHANNEL_ID);
        mBuilder.setContentTitle((CharSequence)title);
        mBuilder.setContentIntent(pi);
        String string4 = DateUtils.getInstance().convertToLocal(timeStamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DateUtils.getInstance().convertToLocal(timeStamp)");
        mBuilder.setWhen(this.getTimeMilliSec(string4));
        mBuilder.setSmallIcon(icon);
        mBuilder.setDefaults(1);
        mBuilder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon));
        mBuilder.setContentText((CharSequence)Html.fromHtml((String)message));
        mBuilder.setPriority(this.getPriority());
        mBuilder.setAutoCancel(true);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel notificationChannel = new NotificationChannel(this.NOTIFICATION_CHANNEL_ID, (CharSequence)this.CHANNEL_ONE_NAME, importance);
            notificationChannel.enableLights(true);
            notificationChannel.setLightColor(-65536);
            notificationChannel.enableVibration(true);
            boolean bl = notificationManager != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string5 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string5));
            }
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification notification = mBuilder.build();
        if (Build.VERSION.SDK_INT >= 21) {
            Resources resources = context.getResources();
            Package package_ = R.class.getPackage();
            if (package_ == null) {
                Intrinsics.throwNpe();
            }
            int smallIconViewId = resources.getIdentifier("right_icon", "id", package_.getName());
            try {
                if (smallIconViewId != 0) {
                    if (notification.contentIntent != null) {
                        notification.contentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int id2 = (int)System.currentTimeMillis();
        notificationManager.notify(id2, notification);
    }

    private final int getPriority() {
        return Build.VERSION.SDK_INT >= 24 ? 5 : 1;
    }

    private final long getTimeMilliSec(String timeStamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (!TextUtils.isEmpty((CharSequence)timeStamp)) {
                Date date;
                Date date2 = date = format.parse(timeStamp);
                Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"date");
                return date2.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return 0L;
    }
}

