/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.activity;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.langs.Restring;
import com.hippo.utils.filepicker.DividerListItemDecoration;
import com.hippo.utils.filepicker.FileUtils;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.activity.BaseActivity;
import com.hippo.utils.filepicker.adapter.NormalFilePickAdapter;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import com.hippo.utils.filepicker.filter.FileFilter;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NormalFilePickActivity
extends BaseActivity {
    public static String id1 = "test_channel_01";
    private static final String TAG = NormalFilePickActivity.class.getSimpleName();
    public static final int DEFAULT_MAX_NUMBER = 9;
    private static final int REQUEST_CODE = 6384;
    public static final String SUFFIX = "Suffix";
    private int mMaxNumber;
    private RecyclerView mRecyclerView;
    private NormalFilePickAdapter mAdapter;
    private ArrayList<NormalFile> mSelectedList = new ArrayList();
    private ProgressBar mProgressBar;
    private String[] mSuffix;
    private Toolbar myToolbar;

    @Override
    public void permissionGranted() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                NormalFilePickActivity.this.loadData();
            }
        }, 2000L);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.vw_activity_image_pick);
        this.mMaxNumber = this.getIntent().getIntExtra("MaxNumber", 9);
        this.mSuffix = this.getIntent().getStringArrayExtra(SUFFIX);
        this.initView();
    }

    private void initView() {
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        String title = Restring.getString((Context)this, R.string.hippo_doc_picker);
        this.setToolbar(this.myToolbar, title);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.pb_file_pick);
        this.mProgressBar.setVisibility(0);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_image_pick);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerListItemDecoration((Context)this, 1, R.drawable.vw_divider_rv_file));
        this.mAdapter = new NormalFilePickAdapter((Context)this, this.mMaxNumber);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnSelectStateListener(new OnSelectStateListener<NormalFile>(){

            @Override
            public void OnSelectStateChanged(boolean state, NormalFile file) {
                if (file == null) {
                    NormalFilePickActivity.this.openFileManager();
                } else {
                    NormalFilePickActivity.this.mSelectedList.add(file);
                    Intent intent = new Intent();
                    intent.putParcelableArrayListExtra("ResultPickFILE", NormalFilePickActivity.this.mSelectedList);
                    NormalFilePickActivity.this.setResult(-1, intent);
                    NormalFilePickActivity.this.finish();
                }
            }
        });
    }

    private void loadData() {
        FileFilter.getFiles((FragmentActivity)this, new FilterResultCallback<NormalFile>(){

            @Override
            public void onResult(List<Directory<NormalFile>> directories) {
                if (NormalFilePickActivity.this.isNeedFolderList) {
                    ArrayList<Directory> list = new ArrayList<Directory>();
                    Directory all = new Directory();
                    all.setName(NormalFilePickActivity.this.getResources().getString(R.string.vw_all));
                    list.add(all);
                    list.addAll(directories);
                    NormalFilePickActivity.this.mFolderHelper.fillData(list);
                }
                NormalFilePickActivity.this.refreshData(directories);
            }
        }, this.mSuffix);
    }

    private void refreshData(List<Directory<NormalFile>> directories) {
        this.mProgressBar.setVisibility(8);
        ArrayList<NormalFile> list = new ArrayList<NormalFile>();
        for (Directory<NormalFile> directory : directories) {
            list.addAll(directory.getFiles());
        }
        for (NormalFile file : this.mSelectedList) {
            int index = list.indexOf(file);
            if (index == -1) continue;
            ((NormalFile)list.get(index)).setSelected(true);
        }
        this.mAdapter.refresh(list);
    }

    private void openFileManager() {
        Intent target = FileUtils.createGetContentIntent();
        Intent intent = Intent.createChooser((Intent)target, (CharSequence)"");
        try {
            this.startActivityForResult(intent, 6384);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block3: {
            super.onActivityResult(requestCode, resultCode, data);
            if (requestCode == 6384 && resultCode == -1 && data != null && data.getData() != null) {
                try {
                    Uri uri = data.getData();
                    String path = FileUtils.getPath((Context)this, uri);
                    NormalFile file = new NormalFile();
                    String fileName = Util.extractFileNameWithoutSuffix(path);
                    file.setPath(path);
                    file.setName(fileName);
                    file.setSize(new File(path).length());
                    this.mSelectedList.add(file);
                    Intent intent = new Intent();
                    intent.putParcelableArrayListExtra("ResultPickFILE", this.mSelectedList);
                    this.setResult(-1, intent);
                    this.finish();
                }
                catch (Exception e) {
                    if (!HippoConfig.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    private void createchannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager nm = (NotificationManager)this.getSystemService("notification");
            NotificationChannel mChannel = new NotificationChannel(id1, (CharSequence)"Testing", 2);
            mChannel.setDescription("Testing description");
            mChannel.enableLights(true);
            mChannel.setShowBadge(true);
            nm.createNotificationChannel(mChannel);
        }
    }
}

