/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.adapter.FolderListAdapter;
import com.hippo.utils.filepicker.filter.entity.Directory;
import java.util.ArrayList;
import java.util.List;

public class FolderListHelper {
    private PopupWindow mPopupWindow;
    private View mContentView;
    private RecyclerView rv_folder;
    private FolderListAdapter mAdapter;

    public void initFolderListView(Context ctx) {
        if (this.mPopupWindow == null) {
            this.mContentView = LayoutInflater.from((Context)ctx).inflate(R.layout.vw_layout_folder_list, null);
            this.rv_folder = (RecyclerView)this.mContentView.findViewById(R.id.rv_folder);
            this.mAdapter = new FolderListAdapter(ctx, new ArrayList<Directory>());
            this.rv_folder.setAdapter((RecyclerView.Adapter)this.mAdapter);
            LinearLayoutManager layoutManager = new LinearLayoutManager(ctx);
            layoutManager.setOrientation(1);
            this.rv_folder.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(ctx));
            this.mContentView.setFocusable(true);
            this.mContentView.setFocusableInTouchMode(true);
            this.mPopupWindow = new PopupWindow(this.mContentView);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setOutsideTouchable(true);
            this.mPopupWindow.setTouchable(true);
        }
    }

    public void setFolderListListener(FolderListAdapter.FolderListListener listener) {
        this.mAdapter.setListener(listener);
    }

    public void fillData(List<Directory> list) {
        this.mAdapter.refresh(list);
    }

    public void toggle(View anchor) {
        if (this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        } else {
            this.mContentView.measure(0, 0);
            this.mPopupWindow.showAsDropDown(anchor, (anchor.getMeasuredWidth() - this.mContentView.getMeasuredWidth()) / 2, 0);
            int height = anchor.getMeasuredWidth();
            if (height > this.mContentView.getMeasuredHeight()) {
                height = this.mContentView.getMeasuredHeight();
            }
            this.mPopupWindow.update(anchor, this.mContentView.getMeasuredWidth(), height);
        }
    }
}

