/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.hippo.R;
import com.hippo.langs.Restring;

public class SingleBtnDialog {
    private Dialog dialog;
    private Context context;

    private SingleBtnDialog(Context context) {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        this.dialog = new Dialog(context);
        this.context = context;
        this.dialog.requestWindowFeature(1);
        this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.dialog.setContentView(R.layout.custom_single_btn_layout);
        this.dialog.setCancelable(false);
        this.dialog.setCanceledOnTouchOutside(true);
        Button btnOk = (Button)this.dialog.findViewById(R.id.btn_ok);
        btnOk.setText((CharSequence)Restring.getString(context, R.string.fugu_ok));
        btnOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SingleBtnDialog.this.dialog.dismiss();
            }
        });
    }

    public static SingleBtnDialog with(Context context) {
        return new SingleBtnDialog(context);
    }

    public SingleBtnDialog setMessage(String msg) {
        if (this.dialog != null) {
            TextView tvMessage = (TextView)this.dialog.findViewById(R.id.tv_message);
            tvMessage.setText((CharSequence)msg);
        }
        return this;
    }

    public SingleBtnDialog setCancelable(boolean bool) {
        if (this.dialog != null) {
            this.dialog.setCancelable(false);
        }
        return this;
    }

    public SingleBtnDialog setCancelableOnTouchOutside(boolean bool) {
        if (this.dialog != null) {
            this.dialog.setCanceledOnTouchOutside(false);
        }
        return this;
    }

    public SingleBtnDialog setHeading(String heading) {
        if (this.dialog != null) {
            TextView tvMessage = (TextView)this.dialog.findViewById(R.id.tv_heading);
            tvMessage.setText((CharSequence)heading);
            tvMessage.setVisibility(0);
        }
        return this;
    }

    public SingleBtnDialog hideHeading() {
        if (this.dialog != null) {
            TextView tvMessage = (TextView)this.dialog.findViewById(R.id.tv_heading);
            tvMessage.setVisibility(8);
        }
        return this;
    }

    public SingleBtnDialog setOptionPositive(String optionPositive) {
        if (this.dialog != null) {
            Button btnOk = (Button)this.dialog.findViewById(R.id.btn_ok);
            btnOk.setText((CharSequence)optionPositive);
            btnOk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SingleBtnDialog.this.dialog.dismiss();
                }
            });
        }
        return this;
    }

    public SingleBtnDialog setCallback(final OnActionPerformed onActionPerformed) {
        if (this.dialog != null && onActionPerformed != null) {
            Button btnOk = (Button)this.dialog.findViewById(R.id.btn_ok);
            btnOk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SingleBtnDialog.this.dialog.dismiss();
                    onActionPerformed.positive();
                }
            });
        }
        return this;
    }

    public Dialog show() {
        if (this.dialog != null && !((AppCompatActivity)this.context).isFinishing()) {
            this.dialog.show();
            return this.dialog;
        }
        return null;
    }

    public static interface OnActionPerformed {
        public void positive();
    }
}

