/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatButton;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.textfield.TextInputEditText;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.CustomerInitalListener;
import com.hippo.langs.Restring;
import com.hippo.model.Button;
import com.hippo.model.Field;
import com.hippo.support.Utils.Constants;
import com.hippo.utils.Utils;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CountryPicker;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import java.util.ArrayList;

public class CustomerInitalAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant {
    private static final String TAG = CustomerInitalAdapter.class.getSimpleName();
    private ArrayList<Object> arrayList = new ArrayList();
    private static final int FIELD_TYPE = 1;
    private static final int BUTTON_TYPE = 2;
    private Context mContext;
    private HippoColorConfig hippoColorConfig = CommonData.getColorConfig();
    private FragmentManager fragmentManager;
    private CustomerInitalListener initalListener;
    private boolean hasFocus = false;

    public CustomerInitalAdapter(ArrayList<Object> arrayList, FragmentManager fragmentManager, CustomerInitalListener initalListener) {
        this.arrayList = arrayList;
        this.fragmentManager = fragmentManager;
        this.initalListener = initalListener;
        this.hasFocus = false;
    }

    public void setDataSet(ArrayList<Object> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.mContext = parent.getContext();
        if (viewType == 1) {
            return new Fields(LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_fields_list, parent, false), new MyFormEditTextListener());
        }
        return new Buttons(LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_button_list, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        int itemType = this.getItemViewType(position);
        switch (itemType) {
            case 1: {
                Fields holder = (Fields)viewHolder;
                Field field = (Field)this.arrayList.get(position);
                holder.title.setText((CharSequence)field.getTitle());
                if (field.getType().toLowerCase().equalsIgnoreCase("LABEL")) {
                    holder.rlFeild.setVisibility(8);
                    holder.description.setVisibility(0);
                    holder.description.setText((CharSequence)field.getDescription());
                    holder.tvError.setVisibility(8);
                } else {
                    holder.rlFeild.setVisibility(0);
                    holder.description.setVisibility(8);
                    if (!TextUtils.isEmpty((CharSequence)field.getTextValue())) {
                        holder.editText.setText((CharSequence)field.getTextValue());
                    } else {
                        holder.editText.setText((CharSequence)"");
                    }
                    holder.myCustomEditTextListener.updatePosition(field, position, holder.tvError);
                    holder.editText.setHint((CharSequence)field.getPlaceholder());
                    holder.countryView.setVisibility(8);
                    this.setFieldInputType(field, holder.editText, holder.countryView, field.getValidationType(), position);
                    if (!TextUtils.isEmpty((CharSequence)field.getErrorText())) {
                        holder.tvError.setVisibility(0);
                        holder.tvError.setText((CharSequence)field.getErrorText());
                        if (!this.hasFocus) {
                            holder.editText.requestFocus();
                            this.hasFocus = true;
                        }
                    } else {
                        holder.tvError.setVisibility(8);
                    }
                }
                holder.title.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                holder.description.setTextColor(this.hippoColorConfig.getHippoTextColorSecondary());
                holder.editText.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                break;
            }
            case 2: {
                Buttons vholder = (Buttons)viewHolder;
                Button button = (Button)this.arrayList.get(position);
                vholder.compatButton.setText((CharSequence)button.getTitle());
                vholder.compatButton.setTextColor(this.hippoColorConfig.getHippoActionBarText());
                int radius = (int)Constants.convertDpToPixel(1.0f);
                GradientDrawable drawable2 = (GradientDrawable)vholder.compatButton.getBackground();
                drawable2.setStroke(radius, this.hippoColorConfig.getHippoActionBarText());
                drawable2.setColor(this.hippoColorConfig.getHippoActionBarBg());
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        if (this.arrayList.get(position) instanceof Field) {
            return 1;
        }
        return 2;
    }

    public boolean checkValidValues() {
        boolean isValid = true;
        boolean isValidCheck = true;
        String error = null;
        block12: for (int i = 0; i < this.arrayList.size(); ++i) {
            if (!(this.arrayList.get(i) instanceof Field)) continue;
            Field field = (Field)this.arrayList.get(i);
            String data = field.getTextValue();
            if (!TextUtils.isEmpty((CharSequence)data)) {
                data = data.trim();
            }
            String dataType = field.getValidationType();
            if (field.getType().toLowerCase().equalsIgnoreCase("label")) continue;
            if (field.getIsRequired().booleanValue() && TextUtils.isEmpty((CharSequence)data)) {
                field.setErrorText("Field can't be empty");
                isValidCheck = false;
                continue;
            }
            field.setErrorText("");
            switch (dataType.toLowerCase()) {
                case "Number": 
                case "number": {
                    String text = Restring.getString(this.mContext, R.string.hippo_enter_number_only);
                    isValid = Utils.isNumeric(data);
                    String string2 = error = isValid ? null : text;
                    if (isValid) continue block12;
                    isValidCheck = false;
                    field.setErrorText(error);
                    continue block12;
                }
                case "email": {
                    String email = "email";
                    if (!TextUtils.isEmpty((CharSequence)field.getTitle())) {
                        email = field.getTitle().toLowerCase();
                    }
                    String validEmail = Restring.getString(this.mContext, R.string.hippo_enter_valid_email);
                    isValid = Utils.isEmailValid(data);
                    String string3 = error = isValid ? null : validEmail;
                    if (isValid) continue block12;
                    isValidCheck = false;
                    field.setErrorText(error);
                    continue block12;
                }
                case "phone_number": 
                case "phone": {
                    String phone = "phone number";
                    if (!TextUtils.isEmpty((CharSequence)field.getTitle())) {
                        phone = field.getTitle().toLowerCase();
                    }
                    String validPhn = Restring.getString(this.mContext, R.string.hippo_enter_valid_phn_no);
                    isValid = Utils.isValidPhoneNumber(data);
                    String string4 = error = isValid ? null : validPhn;
                    if (isValid) continue block12;
                    isValidCheck = false;
                    field.setErrorText(error);
                    continue block12;
                }
            }
        }
        return isValidCheck;
    }

    private void setFieldInputType(Field field, TextInputEditText etInputData, TextView countryView, String type, int pos) {
        switch (type.toLowerCase()) {
            case "Number": 
            case "number": {
                etInputData.setInputType(8194);
                etInputData.setSingleLine(true);
                break;
            }
            case "email": {
                etInputData.setInputType(33);
                break;
            }
            case "phone_number": 
            case "phone": {
                etInputData.setInputType(3);
                if (field.getType().equalsIgnoreCase("TEXTFIELD")) {
                    countryView.setVisibility(8);
                    break;
                }
                countryView.setVisibility(0);
                if (!TextUtils.isEmpty((CharSequence)field.getCountryCode())) {
                    countryView.setText((CharSequence)field.getCountryCode());
                    break;
                }
                String code = this.getDefaultCode();
                code = !TextUtils.isEmpty((CharSequence)code) ? code : "+1";
                countryView.setText((CharSequence)code);
                ((Field)this.arrayList.get(pos)).setCountryCode(code);
                break;
            }
            default: {
                etInputData.setInputType(16385);
            }
        }
    }

    private String getDefaultCode() {
        try {
            CountryPicker countryPicker = new CountryPicker.Builder().with(this.mContext).build();
            return countryPicker.getCountryFromSIM().getDialCode();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void openPicker(final TextView textView, final EditText editText, final int pos) {
        CountryPicker countryPicker = new CountryPicker.Builder().with(this.mContext).sortBy(1).canSearch(true).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                textView.setText((CharSequence)country.getDialCode());
                ((Field)CustomerInitalAdapter.this.arrayList.get(pos)).setCountryCode(country.getDialCode());
                editText.requestFocus();
            }
        }).build();
        countryPicker.showDialog(this.fragmentManager);
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private Field field;
        private int position;
        private TextView errorView;

        public void updatePosition(Field field, int position, TextView errorView) {
            this.field = field;
            this.position = position;
            this.errorView = errorView;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            if (charSequence.length() > 0 && this.field != null && this.errorView.getVisibility() == 0) {
                this.errorView.setVisibility(8);
                ((Field)CustomerInitalAdapter.this.arrayList.get(this.position)).setErrorText("");
            }
        }

        public void afterTextChanged(Editable editable) {
            if (this.field != null) {
                ((Field)CustomerInitalAdapter.this.arrayList.get(this.position)).setTextValue(editable.toString());
            }
        }
    }

    public class Buttons
    extends RecyclerView.ViewHolder {
        private AppCompatButton compatButton;

        public Buttons(View itemView) {
            super(itemView);
            this.compatButton = (AppCompatButton)itemView.findViewById(R.id.button_view);
            this.compatButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CustomerInitalAdapter.this.checkValidValues()) {
                        if (CustomerInitalAdapter.this.initalListener != null) {
                            CustomerInitalAdapter.this.initalListener.onButtonClicked(CustomerInitalAdapter.this.arrayList);
                        }
                    } else {
                        CustomerInitalAdapter.this.hasFocus = false;
                        if (CustomerInitalAdapter.this.initalListener != null) {
                            CustomerInitalAdapter.this.initalListener.onNotifyAdapter(CustomerInitalAdapter.this.arrayList);
                        }
                    }
                }
            });
        }
    }

    public class Fields
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlFeild;
        private MyFormEditTextListener myCustomEditTextListener;
        private TextInputEditText editText;
        private TextView title;
        private TextView description;
        private TextView countryView;
        private TextView tvError;

        public Fields(View itemView, MyFormEditTextListener myCustomEditTextListener) {
            super(itemView);
            this.rlFeild = (RelativeLayout)itemView.findViewById(R.id.rlFeild);
            this.editText = (TextInputEditText)itemView.findViewById(R.id.field_view);
            this.title = (TextView)itemView.findViewById(R.id.title_view);
            this.description = (TextView)itemView.findViewById(R.id.title_description);
            this.countryView = (TextView)itemView.findViewById(R.id.country_picker);
            this.tvError = (TextView)itemView.findViewById(R.id.tvError);
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.editText.addTextChangedListener((TextWatcher)myCustomEditTextListener);
            this.countryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CustomerInitalAdapter.this.openPicker(Fields.this.countryView, (EditText)Fields.this.editText, Fields.this.getAdapterPosition());
                }
            });
            this.editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == 5) {
                        View v1 = v.focusSearch(2);
                        return v1 != null && !v.requestFocus(2);
                    }
                    return false;
                }
            });
        }
    }
}

