/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.utils.filepicker.adapter.OnSelectStateListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    protected Context mContext;
    protected ArrayList<T> mList;
    protected OnSelectStateListener<T> mListener;

    public BaseAdapter(Context ctx, ArrayList<T> list) {
        this.mContext = ctx;
        this.mList = list;
    }

    public void add(List<T> list) {
        this.mList.addAll(list);
        this.notifyDataSetChanged();
    }

    public void add(T file) {
        this.mList.add(file);
        this.notifyDataSetChanged();
    }

    public void add(int index, T file) {
        this.mList.add(index, file);
        this.notifyDataSetChanged();
    }

    public void refresh(List<T> list) {
        this.mList.clear();
        this.mList.addAll(list);
        this.notifyDataSetChanged();
    }

    public void refresh(T file) {
        this.mList.clear();
        this.mList.add(file);
        this.notifyDataSetChanged();
    }

    public List<T> getDataSet() {
        return this.mList;
    }

    public void setOnSelectStateListener(OnSelectStateListener<T> listener) {
        this.mListener = listener;
    }
}

