/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.loadingBox;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.hippo.R;
import com.hippo.langs.Restring;
import com.hippo.utils.HippoLog;
import com.hippo.utils.loadingBox.ProgressWheel;

public class LoadingBox {
    private static Dialog progressDialog;
    private static TextView tvProgress;

    public static void showOn(Activity activity) {
        LoadingBox.showOn(activity, activity.getString(R.string.fugu_loading));
    }

    public static void showOn(Activity activity, String message) {
        try {
            if (progressDialog != null && progressDialog.isShowing()) {
                return;
            }
            progressDialog = new Dialog((Context)activity, R.style.Theme_AppCompat_Translucent);
            progressDialog.setContentView(R.layout.fugu_dialog_progress);
            tvProgress = (TextView)progressDialog.findViewById(R.id.tvProgress);
            tvProgress.setText((CharSequence)Restring.getString((Context)activity, R.string.fugu_loading));
            ((ProgressWheel)progressDialog.findViewById(R.id.progress_wheel)).spin();
            Window dialogWindow = progressDialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 0.6f;
            dialogWindow.addFlags(2);
            progressDialog.setCancelable(false);
            progressDialog.setCanceledOnTouchOutside(false);
            progressDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            HippoLog.e("PROGRESS DIALOG", "EXCEPTION: " + e.getMessage());
        }
    }

    public static boolean hide() {
        HippoLog.e("PROGRESS DIALOG", "DISMISSED");
        if (progressDialog != null && progressDialog.isShowing()) {
            try {
                progressDialog.dismiss();
            }
            catch (Exception ex) {
                HippoLog.e("Dismiss Loading Dialog", ex.toString());
            }
            progressDialog = null;
            return true;
        }
        return false;
    }
}

