/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.DownloadManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Environment;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Patterns;
import com.hippo.HippoConfig;
import com.hippo.utils.AndroidUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;

public class Utils {
    private static final int MULTIPLE_CLICK_THRESHOLD = 2500;
    private static long mLastClickTime = 0L;

    public static boolean isNumeric(String value) {
        if (value == null) {
            return false;
        }
        return Pattern.matches("-?\\d+(\\.\\d+)?", value);
    }

    public static boolean isEmailValid(String email) {
        if (email == null) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static final boolean isValidPhoneNumber(CharSequence target) {
        if (target == null) {
            return false;
        }
        if (target.length() < 6 || target.length() > 17) {
            return false;
        }
        return Patterns.PHONE.matcher(target).matches();
    }

    public static boolean preventMultipleClicks() {
        if (SystemClock.elapsedRealtime() - mLastClickTime < 2500L) {
            return false;
        }
        mLastClickTime = SystemClock.elapsedRealtime();
        return true;
    }

    public static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        try {
            Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            int color2 = -65536;
            Paint paint = new Paint();
            Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF rectF = new RectF(rect);
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(-65536);
            canvas.drawOval(rectF, paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            canvas.drawBitmap(bitmap, rect, rect, paint);
            bitmap.recycle();
            return output;
        }
        catch (Exception e) {
            return bitmap;
        }
    }

    public static void saveFile(String fullPath, final String name, final String mime) {
        if (fullPath == null) {
            return;
        }
        File file = null;
        if (!(TextUtils.isEmpty((CharSequence)fullPath) || (file = new File(fullPath)).exists() && !AndroidUtilities.isInternalUri(Uri.fromFile((File)file)))) {
            file = null;
        }
        if (file == null) {
            return;
        }
        final File sourceFile = file;
        final boolean[] cancelled = new boolean[]{false};
        if (sourceFile.exists()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
                        dir.mkdir();
                        File destFile = new File(dir, name);
                        if (destFile.exists()) {
                            String newName;
                            int idx = name.lastIndexOf(46);
                            for (int a = 0; a < 10 && (destFile = new File(dir, newName = idx != -1 ? name.substring(0, idx) + "(" + (a + 1) + ")" + name.substring(idx) : name + "(" + (a + 1) + ")")).exists(); ++a) {
                            }
                        }
                        if (!destFile.exists()) {
                            destFile.createNewFile();
                        }
                        boolean result = true;
                        long lastProgress = System.currentTimeMillis() - 500L;
                        try (FileChannel source = new FileInputStream(sourceFile).getChannel();
                             FileChannel destination = new FileOutputStream(destFile).getChannel();){
                            long size = source.size();
                            for (long a = 0L; a < size; a += 4096L) {
                                if (cancelled[0]) {
                                    break;
                                }
                                destination.transferFrom(source, a, Math.min(4096L, size - a));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            result = false;
                        }
                        if (cancelled[0]) {
                            destFile.delete();
                            result = false;
                        }
                        if (result) {
                            DownloadManager downloadManager = (DownloadManager)HippoConfig.getInstance().getContext().getSystemService("download");
                            downloadManager.addCompletedDownload(destFile.getName(), destFile.getName(), false, mime, destFile.getAbsolutePath(), destFile.length(), true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }
}

