/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.util.Log;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AndroidLoggingHandler
extends Handler {
    public static void reset(Handler rootHandler) {
        Handler[] handlers;
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        LogManager.getLogManager().getLogger("").addHandler(rootHandler);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (!super.isLoggable(record)) {
            return;
        }
        String name = record.getLoggerName();
        int maxLength = 30;
        String tag = name.length() > maxLength ? name.substring(name.length() - maxLength) : name;
        try {
            int level = AndroidLoggingHandler.getAndroidLevel(record.getLevel());
            Log.println((int)level, (String)tag, (String)record.getMessage());
            if (record.getThrown() != null) {
                Log.println((int)level, (String)tag, (String)Log.getStackTraceString((Throwable)record.getThrown()));
            }
        }
        catch (RuntimeException e) {
            Log.e((String)"AndroidLoggingHandler", (String)"Error logging message.", (Throwable)e);
        }
    }

    static int getAndroidLevel(Level level) {
        int value = level.intValue();
        if (value >= 1000) {
            return 6;
        }
        if (value >= 900) {
            return 5;
        }
        if (value >= 800) {
            return 4;
        }
        return 3;
    }
}

