/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.logicImplView;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.support.callback.HippoSupportInteractor;
import com.hippo.support.db.HippoDatabase;
import com.hippo.support.model.SupportDataList;
import com.hippo.support.model.SupportResponse;
import com.hippo.utils.HippoLog;
import java.util.Map;
import retrofit2.Callback;

public class HippoSupportInteractorImpl
implements HippoSupportInteractor {
    private HippoSupportInteractor.OnFinishedListener onFinishedListener;
    private HippoDatabase database;
    private SupportDataList dataList;
    private int hitCount = 0;

    @Override
    public void getSupportData(Activity activity, int serverDBVersion, String defaultCategory, HippoSupportInteractor.OnFinishedListener onFinishedListener) {
        this.onFinishedListener = onFinishedListener;
        this.database = HippoDatabase.getInstance((Context)activity);
        this.getData(activity, serverDBVersion, defaultCategory);
    }

    private void getData(Activity activity, int version, String getCategoryData) {
        this.hasUserData(activity, version, getCategoryData, this.hitCount);
    }

    private void fetchLocalSupportData(Activity activity, int version, String mFAQSearchString) {
        SupportDataList dataList = !TextUtils.isEmpty((CharSequence)mFAQSearchString) ? this.database.getSupportDataItems(mFAQSearchString.toLowerCase().trim()) : this.database.getSupportDataItems(0);
        if (dataList == null || dataList.getList() == null) {
            this.hasUserData(activity, version, mFAQSearchString, this.hitCount, true);
        } else {
            this.onFinishedListener.onSuccess(dataList);
        }
    }

    private void hasUserData(Activity activity, int version1, String categoryId, int hitCount) {
        this.hasUserData(activity, version1, categoryId, hitCount, false);
    }

    private void hasUserData(final Activity activity, final int version1, final String categoryId, final int hitCount, final boolean serverForceHit) {
        if (HippoConfig.getInstance().getUserData() == null || TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getUserData().getEnUserId()) || TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAppKey())) {
            new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback(){

                @Override
                public void onSuccess() {
                    HippoSupportInteractorImpl.this.afterHasUserData(activity, version1, categoryId, hitCount, serverForceHit);
                }

                @Override
                public void onFailure() {
                    HippoSupportInteractorImpl.this.onFinishedListener.onFailure();
                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId(), false);
        } else {
            this.afterHasUserData(activity, version1, categoryId, hitCount, serverForceHit);
        }
    }

    private void afterHasUserData(Activity activity, int version1, String categoryId, int hitCount, boolean serverForceHit) {
        if (!CommonData.getUserDetails().getData().isFAQEnabled()) {
            this.onFinishedListener.onSuccess(null);
            return;
        }
        int localVersion = CommonData.getLocalVersion();
        int version = CommonData.getUserDetails().getData().getInAppSupportVersion();
        if (serverForceHit) {
            this.fetchSupportData(activity, version, categoryId, hitCount);
        } else if (version > localVersion) {
            this.fetchSupportData(activity, version, categoryId, hitCount);
        } else {
            this.fetchLocalSupportData(activity, version, categoryId);
        }
        HippoLog.v("TAG", localVersion + " < localVersion versionCode >" + version);
    }

    private void fetchSupportData(Activity activity, final int version, final String categoryId, int hitCount) {
        String enUserId = null;
        try {
            enUserId = CommonData.getUserDetails() != null && CommonData.getUserDetails().getData() != null && CommonData.getUserDetails().getData().getEn_user_id() != null ? CommonData.getUserDetails().getData().getEn_user_id() : HippoConfig.getInstance().getUserData().getEnUserId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)enUserId) && hitCount < 2) {
            this.hasUserData(activity, version, categoryId, hitCount + 1);
            return;
        }
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", enUserId).add("app_version", 259).add("device_type", 1).add("is_active", 1).build();
        RestClient.getApiInterface().fetchSupportData(commonParams.getMap()).enqueue((Callback)new ResponseResolver<SupportResponse>(activity, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(SupportResponse response) {
                try {
                    String defaultKey = categoryId == null ? response.getDefaultFaqName() : categoryId;
                    CommonData.setDefaultCategory(response.getDefaultFaqName());
                    if (!TextUtils.isEmpty((CharSequence)defaultKey)) {
                        for (Map.Entry<String, SupportDataList> pair : response.getItemData().entrySet()) {
                            SupportDataList dataList1 = pair.getValue();
                            if (!dataList1.getCategoryName().equalsIgnoreCase(defaultKey)) continue;
                            HippoSupportInteractorImpl.this.dataList = dataList1;
                            break;
                        }
                    }
                    if (response.getItemData().isEmpty()) {
                        HippoSupportInteractorImpl.this.onFinishedListener.onSuccess(null);
                        return;
                    }
                    if (HippoSupportInteractorImpl.this.dataList == null) {
                        HippoSupportInteractorImpl.this.dataList = response.getItemData().get(response.getItemData().keySet().iterator().next());
                    }
                    HippoSupportInteractorImpl.this.onFinishedListener.onSuccess(HippoSupportInteractorImpl.this.dataList);
                    new BackgroundInsert().execute(new String[]{new Gson().toJson((Object)response), String.valueOf(version)});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    HippoSupportInteractorImpl.this.onFinishedListener.onFailure();
                }
            }

            @Override
            public void failure(APIError error) {
                HippoSupportInteractorImpl.this.onFinishedListener.onFailure();
            }
        });
    }

    private class BackgroundInsert
    extends AsyncTask<String, String, Boolean> {
        int version = -1;

        private BackgroundInsert() {
        }

        protected Boolean doInBackground(String ... strings) {
            try {
                SupportResponse response = (SupportResponse)new Gson().fromJson(strings[0], SupportResponse.class);
                Map<String, SupportDataList> itemData = response.getItemData();
                HippoSupportInteractorImpl.this.database.insertUpdateSupportData(itemData);
                try {
                    this.version = Integer.parseInt(strings[1]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        protected void onPostExecute(Boolean flag) {
            super.onPostExecute((Object)flag);
            if (flag.booleanValue()) {
                CommonData.setCurrentVersion(this.version);
            }
            if (HippoSupportInteractorImpl.this.database != null) {
                HippoSupportInteractorImpl.this.database.close();
            }
        }
    }
}

