/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.langs.Restring;
import com.hippo.model.FuguConversation;
import com.hippo.utils.ColorGenerator;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.TextDrawable;
import java.util.ArrayList;

public class HippoChannelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater inflater;
    private ArrayList<Object> fuguConversationList = new ArrayList();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;
    private String enUserId = "";
    private HippoColorConfig hippoColorConfig;
    private Callback callback;
    private RequestOptions options;
    private static final int TYPE_ITEM = 1;
    public static final int ITEM_PROGRESS_BAR = 3;

    public HippoChannelsAdapter(Activity activity, ArrayList<Object> fuguConversationList, String userName, Long userId, String businessName, Callback callback, String enUserId) {
        this.inflater = LayoutInflater.from((Context)activity.getApplicationContext());
        this.hippoColorConfig = CommonData.getColorConfig();
        this.fuguConversationList = fuguConversationList;
        this.activity = activity;
        this.userName = userName;
        this.businessName = businessName;
        this.userId = userId;
        this.callback = callback;
        this.enUserId = enUserId;
    }

    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color2 = generator.getColor(name.trim());
        Resources r = this.activity.getResources();
        float px = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)r.getDisplayMetrics());
        char text = name.trim().charAt(0);
        TextDrawable drawable2 = TextDrawable.builder().buildRoundRect((text + "").toUpperCase(), color2, Math.round(px));
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().circleCrop()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        this.options.placeholder((Drawable)drawable2);
        this.options.error((Drawable)drawable2);
        return this.options;
    }

    public void updateList(ArrayList<Object> fuguConversationList) {
        this.fuguConversationList = fuguConversationList;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 3) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hippo_custom_loading_list_item, parent, false);
            return new ProgressBarViewHolder(v);
        }
        View view = this.inflater.inflate(R.layout.fugu_item_channels, parent, false);
        return new ChannelViewHolder(view);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ChannelViewHolder) {
            try {
                final ChannelViewHolder channelViewHolder = (ChannelViewHolder)holder;
                final FuguConversation currentChannelItem = (FuguConversation)this.fuguConversationList.get(position);
                channelViewHolder.tvChannelName.setText((CharSequence)currentChannelItem.getLabel());
                channelViewHolder.tvChannelName.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                if (currentChannelItem.getMessage_type() == 18) {
                    channelViewHolder.ivMessageState.setVisibility(8);
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)this.getMessageData(currentChannelItem)));
                } else if (TextUtils.isEmpty((CharSequence)currentChannelItem.getMessage())) {
                    if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                            if (currentChannelItem.getMessage_type() == 10) {
                                channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.fugu_attachment)));
                            } else if (currentChannelItem.getMessage_type() == 11) {
                                channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.hippo_attachment_file)));
                            } else {
                                channelViewHolder.tvMessage.setText((CharSequence)"You sent a message");
                            }
                            channelViewHolder.ivMessageState.setVisibility(0);
                            if (currentChannelItem.getLast_message_status() == 3) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                            } else if (currentChannelItem.getLast_message_status() == 4 || currentChannelItem.getLast_message_status() == 5) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                            } else {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                            }
                        } else {
                            if (currentChannelItem.getMessage_type() == 10) {
                                channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.fugu_attachment)));
                            } else if (currentChannelItem.getMessage_type() == 11) {
                                channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.hippo_attachment_file)));
                            } else {
                                channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + " sent a message"));
                            }
                            channelViewHolder.ivMessageState.setVisibility(8);
                        }
                    }
                } else if (currentChannelItem.getMessage().contains("\n")) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)currentChannelItem.getMessage().replaceAll("\n", " ")));
                    if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                        HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                        HippoLog.e("error", currentChannelItem.getUserId() + "");
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                            channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                            channelViewHolder.ivMessageState.setVisibility(0);
                            if (currentChannelItem.getLast_message_status() == 3) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                            } else if (currentChannelItem.getLast_message_status() == 4 || currentChannelItem.getLast_message_status() == 5) {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                            } else {
                                channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                            }
                        } else {
                            channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + currentChannelItem.getMessage())));
                            channelViewHolder.ivMessageState.setVisibility(8);
                        }
                    } else if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                        channelViewHolder.ivMessageState.setVisibility(0);
                        if (currentChannelItem.getLast_message_status() == 3) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                        } else if (currentChannelItem.getLast_message_status() == 4) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                        } else {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                        }
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)currentChannelItem.getMessage()));
                        channelViewHolder.ivMessageState.setVisibility(8);
                    }
                } else if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                    HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                    HippoLog.e("error", currentChannelItem.getUserId() + "");
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                        channelViewHolder.ivMessageState.setVisibility(0);
                        if (currentChannelItem.getLast_message_status() == 3) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                        } else if (currentChannelItem.getLast_message_status() == 4 || currentChannelItem.getLast_message_status() == 5) {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                        } else {
                            channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                        }
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + currentChannelItem.getMessage())));
                        channelViewHolder.ivMessageState.setVisibility(8);
                    }
                } else if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                    channelViewHolder.ivMessageState.setVisibility(0);
                    if (currentChannelItem.getLast_message_status() == 3) {
                        channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                    } else if (currentChannelItem.getLast_message_status() == 4) {
                        channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                    } else {
                        channelViewHolder.ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                    }
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)currentChannelItem.getMessage()));
                    channelViewHolder.ivMessageState.setVisibility(8);
                }
                if (currentChannelItem.getUnreadCount() > 0) {
                    channelViewHolder.tvChannelName.setTypeface(Typeface.DEFAULT_BOLD);
                    channelViewHolder.tvMessage.setTypeface(Typeface.DEFAULT_BOLD);
                    channelViewHolder.circularTvMessageCount.setVisibility(0);
                    channelViewHolder.circularTvMessageCount.setText((CharSequence)String.valueOf(currentChannelItem.getUnreadCount()));
                    channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoTextColorPrimary());
                } else {
                    channelViewHolder.tvChannelName.setTypeface(Typeface.DEFAULT);
                    channelViewHolder.tvMessage.setTypeface(Typeface.DEFAULT);
                    channelViewHolder.circularTvMessageCount.setVisibility(8);
                    channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelDateText());
                }
                if (currentChannelItem.getChannelImage() == null || currentChannelItem.getChannelImage().trim().isEmpty()) {
                    channelViewHolder.ivChannelIcon.setVisibility(8);
                    channelViewHolder.tvChannelIcon.setText((CharSequence)currentChannelItem.getLabel().trim().substring(0, 1).toUpperCase());
                    channelViewHolder.tvChannelIcon.setVisibility(0);
                    Glide.with((Activity)this.activity).clear((View)channelViewHolder.ivChannelIcon);
                    channelViewHolder.ivChannelIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_ring_grey));
                    channelViewHolder.ivChannelIcon.getDrawable().setColorFilter(this.hippoColorConfig.getHippoChannelDateText(), PorterDuff.Mode.SRC_ATOP);
                    channelViewHolder.tvChannelIcon.setTextColor(this.hippoColorConfig.getHippoChannelItemBg());
                    GradientDrawable tvBackground = (GradientDrawable)channelViewHolder.tvChannelIcon.getBackground();
                    tvBackground.setColor(this.hippoColorConfig.getHippoChannelDateText());
                } else {
                    String name = currentChannelItem.getLabel().trim().substring(0, 1).toUpperCase();
                    Glide.with((Activity)this.activity).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(name)).load(currentChannelItem.getChannelImage()).into(channelViewHolder.ivChannelIcon);
                    channelViewHolder.ivChannelIcon.setVisibility(0);
                    channelViewHolder.tvChannelIcon.setVisibility(8);
                }
                try {
                    if (currentChannelItem.getChannelId() == null || currentChannelItem.getChannelId().intValue() < 0) {
                        channelViewHolder.tvDate.setVisibility(8);
                    } else {
                        channelViewHolder.tvDate.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(currentChannelItem.getDateTime()), true));
                        channelViewHolder.tvDate.setVisibility(0);
                    }
                }
                catch (Exception e) {
                    channelViewHolder.tvDate.setVisibility(8);
                }
                if (currentChannelItem.getChannelStatus() == ChannelStatus.CLOSED.getOrdinal() && currentChannelItem.getLabelId() < 0L) {
                    channelViewHolder.vClosed.setVisibility(0);
                } else {
                    channelViewHolder.vClosed.setVisibility(8);
                }
                channelViewHolder.rlRoot.setBackgroundDrawable((Drawable)HippoColorConfig.makeSelector(this.hippoColorConfig.getHippoChannelItemBg(), this.hippoColorConfig.getHippoChannelItemBgPressed()));
                channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        channelViewHolder.circularTvMessageCount.setVisibility(8);
                        currentChannelItem.setUnreadCount(0);
                        FuguConversation conversation = new FuguConversation();
                        conversation.setLabel(currentChannelItem.getLabel());
                        conversation.setChannelId(currentChannelItem.getChannelId());
                        conversation.setLabelId(currentChannelItem.getLabelId());
                        conversation.setDefaultMessage(currentChannelItem.getMessage());
                        conversation.setChannelStatus(currentChannelItem.getChannelStatus());
                        conversation.setChannelImage(currentChannelItem.getChannelImage());
                        conversation.setBusinessName(HippoChannelsAdapter.this.businessName);
                        conversation.setUserId(HippoChannelsAdapter.this.userId);
                        conversation.setEnUserId(HippoChannelsAdapter.this.enUserId);
                        conversation.setOpenChat(true);
                        conversation.setUserName(HippoChannelsAdapter.this.userName);
                        conversation.setIsTimeSet(1);
                        conversation.setChatType(currentChannelItem.getChatType());
                        conversation.setStatus(currentChannelItem.getStatus());
                        conversation.setLast_sent_by_id(currentChannelItem.getLast_sent_by_id());
                        HippoChannelsAdapter.this.callback.onClick(conversation);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ProgressBarViewHolder progressBarViewHolder = (ProgressBarViewHolder)holder;
            progressBarViewHolder.textView.setText((CharSequence)Restring.getString((Context)this.activity, R.string.fugu_loading));
        }
    }

    public int getItemCount() {
        if (this.fuguConversationList == null || this.fuguConversationList.size() == 0) {
            return 0;
        }
        return this.fuguConversationList.size();
    }

    public int getItemViewType(int position) {
        if (this.fuguConversationList.get(position) instanceof ProgressBarItem) {
            return 3;
        }
        return 1;
    }

    private String getMessageData(FuguConversation currentChannelItem) {
        String video;
        String message = "The video call ended";
        String callType = video = Restring.getString((Context)this.activity, R.string.fugu_video);
        if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            String voice;
            callType = voice = Restring.getString((Context)this.activity, R.string.fugu_voice);
        }
        if (currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState() == 2) {
            if (currentChannelItem.getLast_sent_by_id().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                String customer_missed_call = Restring.getString((Context)this.activity, R.string.hippo_customer_missed_a);
                String call_with_you = Restring.getString((Context)this.activity, R.string.hippo_call_with_you);
                message = customer_missed_call + " " + callType + " " + call_with_you;
            } else {
                String you_missed_a = Restring.getString((Context)this.activity, R.string.hippo_you_missed_a);
                String call_with = Restring.getString((Context)this.activity, R.string.hippo_call_with);
                message = you_missed_a + " " + callType + " " + call_with + " " + currentChannelItem.getLast_sent_by_full_name();
            }
        } else {
            String the = Restring.getString((Context)this.activity, R.string.hippo_the);
            String call_ended = Restring.getString((Context)this.activity, R.string.hippo_call_ended);
            message = the + " " + callType + " " + call_ended;
        }
        return message;
    }

    private class ProgressBarViewHolder
    extends RecyclerView.ViewHolder {
        private TextView textView;

        public ProgressBarViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.tv_loading_text);
        }
    }

    public static class ProgressBarItem {
    }

    public static interface Callback {
        public void onClick(FuguConversation var1);
    }

    class ChannelViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private TextView tvChannelName;
        private TextView tvMessage;
        private TextView tvDate;
        private TextView tvChannelIcon;
        private ImageView ivChannelIcon;
        private ImageView ivMessageState;
        private TextView circularTvMessageCount;
        private View vClosed;

        ChannelViewHolder(View itemView) {
            super(itemView);
            this.rlRoot = (RelativeLayout)itemView.findViewById(R.id.rlRoot);
            this.tvChannelName = (TextView)itemView.findViewById(R.id.tvChannelName);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
            this.ivChannelIcon = (ImageView)itemView.findViewById(R.id.ivChannelIcon);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.circularTvMessageCount = (TextView)itemView.findViewById(R.id.circularTvMessageCount);
            this.vClosed = itemView.findViewById(R.id.vClosed);
        }
    }
}

