package com.hippo.langs

import com.hippo.HippoConfig
import com.hippo.database.CommonData
import com.hippo.model.LangRequest
import com.hippo.model.MultilangualResponse
import com.hippo.retrofit.*
import com.hippo.utils.HippoLog

/**
 * Created by gurmail on 2020-06-18.
 * @author gurmail
 */
object FetchLanguageData {
    fun fetchLanguage(lang: String) {
        val params = LangRequest(CommonData.getUserDetails().data.appSecretKey, 0, lang)
        RestClient.getApiInterface().getLanguageData(params)
            .enqueue(object : ResponseResolver<MultilangualResponse>() {
                override fun success(response: MultilangualResponse?) {
                    Restring.saveStrings(response?.data)
                    CommonData.saveCurrentLang(lang)
                    updateUserLanguage(lang)
                }
                override fun failure(error: APIError?) {

                }
            })
    }

    fun updateUserLanguage(lang: String) {

        val params = CommonParams.Builder()
            .add("app_secret_key", CommonData.getUserDetails().data.appSecretKey)
            .add("en_user_id", CommonData.getUserDetails().data.en_user_id)
            .add("update_lang", lang)
            .build()

        RestClient.getApiInterface().updateUserLanguage(params.map)
            .enqueue(object : ResponseResolver<MultilangualResponse>() {
                override fun success(response: MultilangualResponse?) {

                }
                override fun failure(error: APIError?) {

                }
            })
    }

    /*private var messages = java.util.HashMap<String, String>()*/

    /*fun demoString(): HashMap<String, String> {
        messages.clear()
        messages["fugu_unable_to_connect_internet"] = "इंटरनेट से जुड़ने में असमर्थता"
        messages["fugu_no_internet_connection_retry"] = "कोई इंटरनेट कनेक्शन \n पुन: प्रयास करने के लिए टै"
        messages["hippo_something_wrong"] = "कुछ पुन: प्रयास करने के लिए गलत  \n नल चला गया"
        messages["fugu_new_conversation"] = "नया वार्तालाप"
        messages["fugu_loading"] = "लोड हो रहा है..."
        messages["fugu_powered_by"] = "इससे संचालित"
        messages["fugu_text"] = "हिप्पो"
        messages["fugu_no_gallery"] = "गैलरी इस फोन में नहीं मिला।"
        messages["fugu_camera"] = "	कैमरा"
        messages["fugu_gallery"] = "गेलरी"
        messages["fugu_document"] = "दस्तावेज़"
        messages["fugu_payment"] = "भुगतान"
        messages["fugu_audio"] = "ऑडियो"
        messages["fugu_pdf"] = "दस्तावेज़"
        messages["fugu_retry"] = "पुन: प्रयास करें"
        messages["fugu_attachment"] = "अनुलग्नक छवि"
        messages["fugu_send_message"] = "एक संदेश भेजें..."
        messages["fugu_cancel"] = "रद्द करना"
        messages["fugu_ok"] = "ठीक है"
        messages["fugu_file_not_found"] = "क्षमा करें यह फ़ाइल अपने डिवाइस पर उपलब्ध नहीं है"
        messages["fugu_support"] = "सहयोग"
        messages["hippo_could_not_send_message"] = "अपने संदेश नहीं भेजा जा सका"
        messages["hippo_tap_to_retry"] = "करने के लिए टैप <u> पुन: प्रयास करें </ u> & # 160;"
        messages["hippo_no_internet_cancel"] = "रद्द करना"
        messages["fugu_not_connected_to_internet"] = "इंटरनेट से कनेक्ट नहीं"
        messages["fugu_connecting"] = "कनेक्ट ..."
        messages["fugu_connected"] = "जुड़े हुए"
        messages["fugu_no_conversation_found"] = "कोई वार्तालाप नहीं मिले"
        messages["fugu_no_conversation"] = "हम किसी भी \n इस इनबॉक्स में बातचीत नहीं पा सके"
        messages["fugu_tap_to_view"] = "<i> देखने के लिए टैप </i>"
        messages["fugu_agent_actions"] = "कार्रवाई"
        messages["fugu_show_more"] = "और दिखाओ..."
        messages["fugu_leave_comment"] = "एक टिप्पणी छोड़ें"
        messages["fugu_no_data_found"] = "कोई डेटा नहीं मिला"
        messages["hippo_message_sucessfully"] = "आपका अनुरोध सफलतापूर्वक सबमिट कर दिया गया है"
        messages["hippo_text"] = "हिप्पो"
        messages["hippo_smile_rating_terrible"] = "भयानक"
        messages["hippo_smile_rating_bad"] = "खराब"
        messages["hippo_smile_rating_okay"] = "ठीक है"
        messages["hippo_smile_rating_good"] = "	अच्छा"
        messages["hippo_smile_rating_great"] = "	महान"
        messages["hippo_search"] = "	खोजें & # 8230;"
        messages["hippo_error_no_countries_found"] = "	कोई देशों मिला!"
        messages["hippo_country_picker_header"] = "	देश चुनिए"
        messages["call_again"] = "दोबारा फोन करें"
        messages["hippo_select_string"] = "चुनते हैं"
        messages["hippo_rationale_ask"] = "इस एप्लिकेशन को सही ढंग से अनुरोध की गई अनुमति के बिना काम नहीं कर सकते हैं।"
        messages["hippo_rationale_ask_again"] = "इस एप्लिकेशन को सही ढंग से अनुरोध की गई अनुमति के बिना काम नहीं कर सकते हैं। एप्लिकेशन सेटिंग की गई अनुमतियों को संशोधित करने के लिए स्क्रीन खोलें।"
        messages["title_settings_dialog"] = "अनुमति की आवश्यकता नहीं"
        messages["vw_confirm"] = "किया हुआ"
        messages["vw_rationale_storage"] = "फ़ाइलें चुनने की आवश्यकता पढ़ना संग्रहण की अनुमति"
        messages["vw_up_to_max"] = "पहले से ही अधिकतम करने के लिए"
        messages["vw_no_photo_app"] = "इस फ़ोन में कोई तस्वीर ऐप!"
        messages["vw_all"] = "सब"
        messages["hippo_browse_other_doc"] = "अन्य डॉक्स & # 8230 ब्राउज;"
        messages["hippo_large_file"] = "फ़ाइल का आकार से बड़ा नहीं हो सकता है"
        messages["hippo_attachment_file"] = "अनुलग्नक फ़ाइल"
        messages["no_handler"] = "यह फ़ाइल प्रकार समर्थित नहीं है"
        messages["uploading"] = "अपलोड हो रहा है"
        messages["uploading_in_progress"] = "	कार्य प्रगति पर अपलोड करने"
        messages["unknown_message"] = "यह संदेश नहीं करता है अपने वर्तमान एप्लिकेशन में \n का समर्थन नहीं करते"
        messages["hippo_broadcast_detail"] = "प्रसारण विवरण"
        messages["hippo_recipients"] = "प्राप्तकर्ता"
        messages["hippo_add_an_option"] = "कोई विकल्प जोड़ें"
        messages["hippo_request_payment"] = "भुगतान का अनुरोध करें"
        messages["hippo_item_price"] = "मूल्य दर्ज करें"
        messages["hippo_item_description"] = "विवरण दर्ज करें"
        messages["hippo_currency"] = "मुद्रा"
        messages["fugu_title"] = "शीर्षक"
        messages["hippo_enter_title"] = "शीर्षक दर्ज करें"
        messages["hippo_title_item_price"] = "कीमत"
        messages["hippo_title_item_description"] = "विवरण"
        messages["hippo_total_count"] = "कुल कीमत :"
        messages["hippo_empty_transaction_id"] = "TransactionId \n टी खाली हो सकता है"
        messages["hippo_empty_other_user_unique_keys"] = "अन्य उपयोगकर्ता अद्वितीय कुंजी सरणी \n टी खाली हो सकता है"
        messages["talk_to"] = "वार्तालाप बनाएं"
        messages["hippo_history"] = "बात चिट"
        messages["logout"] = "ल ॉ ग आउट"
        messages["hippo_something_wentwrong"] = "कुछ गलत हो गया \n कृपया बाद में पुनः प्रयास"
        messages["app_guarantee"] = "आहार बडी गारंटी"
        messages["hippo_read_more"] = "<U> और पढ़ें </ u>"
        messages["hippo_read_less"] = "<U> पढ़ें कम </ u>"
        messages["error_msg_yellow_bar"] = "धीमे इंटरनेट कनेक्शन।"
        messages["hippo_storage_permission"] = "कृपया अनुदान भंडारण की अनुमति"
        messages["hippo_netbanking"] = "नेट बैंकिंग"
        messages["hippo_pay_with_netbanking"] = "नेट बैंकिंग"
        messages["hippo_payfort"] = "Payfort"
        messages["hippo_paytm"] = "Paytm"
        messages["hippo_card"] = "कार्ड"
        messages["hippo_pay_with_paymob"] = "Paymob"
        messages["hippo_pay_with_razorpay"] = "कार्ड / नेट बैंकिंग"
        messages["float_label_start_chat"] = "न्यू समर्थन चैट"
        messages["hippo_pay_with_paytm"] = "Paytm के साथ भुगतान"
        messages["hippo_stripe"] = "पट्टी"
        messages["hippo_fetching_payment_methods"] = "ला रहा है भुगतान के तरीके ..."
        messages["hippo_no_payment_methods"] = "कोई भुगतान विधि उपलब्ध"
        messages["hippo_you_have_no_chats"] = "आपके पास कोई चैट करने देता है"
        messages["hippo_clear_all_notification"] = "सभी साफ करें"
        messages["hippo_find_an_expert"] = "एक विशेषज्ञ से खोजें"
        messages["hippo_no_chat_init"] = "लगता है जैसे आप अपने बडी यात्रा पर अभी तक शुरू नहीं किया है, अब इसे शुरू लात!"
        messages["hippo_rating_review"] = "<! [CDATA [रेटिंग और समीक्षा]]>"
        messages["hippo_cancel_payment"] = "रद्द करें भुगतान"
        messages["cancel_payment_text"] = "क्या आप वाकई रद्द करने के लिए \n the भुगतान करना चाहते हैं?"
        messages["hippo_no"] = "नहीं"
        messages["hippo_yes_cancel"] = "हाँ, रद्द करें"
        messages["hippo_payment_title"] = "भुगतान"
        messages["hippo_payment_loader"] = "कृपया प्रतीक्षा करें \n भुगतान लिंक पर रीडायरेक्ट किया"
        messages["fugu_menu_retry"] = "पुन: प्रयास करें"
        messages["vw_no_video_app"] = "	कोई वीडियो एप्लिकेशन मिला"
        messages["hippo_chat_support"] = "चैट सहायता"
        messages["hippo_submit"] = "प्रस्तुत"
        messages["hippo_call"] = "कॉल"
        messages["hippo_chat"] = "चैट"
        messages["hippo_notifications_title"] = "सूचनाएं"
        messages["hippo_no_notifications"] = "कोई सूचनाएं नहीं"
        messages["hippo_notifications_deleted"] = "अधिसूचना नष्ट कर दिया"
        messages["hippo_chats"] = "चैट"
        messages["hippo_notifications"] = "सूचनाएं"
        messages["hippo_current"] = "वर्तमान"
        messages["hippo_past"] = "अतीत"
        messages["hippo_yes"] = "हाँ"
        messages["hippo_logout_msg"] = "क्या आप लॉग आउट करना चाहते हैं?"
        messages["fugu_create_conversation"] = "बातचीत बनाएं"
        messages["hippo_no_internet_connected"] = "कोई इंटरनेट कनेक्टेड"
        messages["hippo_you"] = "आप"
        messages["hippo_sent_a_msg"] = "एक संदेश भेजा"
        messages["fugu_voice"] = "आवाज़"
        messages["fugu_video"] = "वीडियो"
        messages["hippo_call_with_you"] = "आप के साथ फोन"
        messages["hippo_customer_missed_a"] = "ग्राहक एक चूक"
        messages["hippo_you_missed_a"] = "आप याद किया एक"
        messages["hippo_call_with"] = "के साथ बुलाना"
        messages["hippo_call_ended"] = "कॉल समाप्त"
        messages["hippo_the"] = "यह"
        messages["hippo_something_went_wrong"] = "कुछ गलत हो गया। कृपया पुन: प्रयास करें"
        messages["hippo_file_already_in_queue"] = "पहले से ही कतार में फ़ाइलें। कृपया प्रतीक्षा करें"
        messages["hippo_grant_permission"] = "कृपया अपने लिए अनुमति"
        messages["hippo_pay_btnText"] = "वेतन"
        messages["hippo_error_msg_sending"] = "प्रकाशन संदेश में त्रुटि"
        messages["hippo_feature_no_supported"] = "यह सुविधा समर्थित नहीं"
        messages["hippo_nochats"] = "आपके पास कोई चैट करने देता है।"
        messages["hippo_writereview"] = "एक समीक्षा लिखे"
        messages["hippo_minimum_Multiselection"] = "कृपया कम से कम एक विकल्प का चयन करें"
        messages["hippo_enter_number_only"] = "संख्यात्मक मान ही दर्ज"
        messages["hippo_enter_valid_email"] = "मान्य ईमेल दर्ज करें"
        messages["hippo_field_cant_empty"] = "फील्ड नहीं खाली किया जा सकता है"
        messages["hippo_fill_pre_field"] = "कृपया पिछले फ़ील्ड भरें"
        messages["hippo_enter_valid_price"] = "आइटम के लिए मान्य मूल्य दर्ज करें"
        messages["hippo_invalid_price"] = "अमान्य मूल्य"
        messages["hippo_alert"] = "चेतावनी!"
        messages["hippo_file_not_supported"] = "फ़ाइल प्रकार समर्थित नहीं! आप अन्य एप्लिकेशन के साथ खोलने के लिए करना चाहते हैं?"
        messages["hippo_with_country_code"] = "देश कोड के साथ"
        messages["hippo_enter_phone_number"] = "अपने फोन को दर्ज करें"
        messages["hippo_enter_valid_phn_no"] = "मान्य फ़ोन नंबर दें"
        messages["hippo_save_plan"] = "सहेजें योजना"
        messages["hippo_update_plan"] = "अद्यतन योजना"
        messages["hippo_no_chat"] = "लगता है आप अभी तक कोई बातचीत शुरू नहीं किया है की तरह है, अब इसे शुरू लात!"
        messages["hippo_call_back"] = "वापस कॉल करें"
        messages["hippo_missed"] = "चुक गया"
        messages["hippo_paid"] = "- भुगतान किया है -"
        messages["hippo_ongoing"] = "चल रही है"
        messages["hippo_at"] = "पर"
        messages["hippo_pending"] = "- लंबित -"
        messages["hippo_free"] = "नि: शुल्क"
        messages["hippo_photo_video_library"] = "फोटो और वीडियो लाइब्रेरी"
        messages["hippo_video"] = "वीडियो"
        messages["hippo_files"] = "फ़ाइलें"
        messages["hippo_emptymessage"] = "कुछ पाठ दर्ज करें।"
        messages["hippo_missed_call"] = "मिस कॉल"
        messages["hippo_the_voice_call"] = "वॉयस कॉल"
        messages["hippo_the_video_call"] = "वीडियो कॉल"
        messages["hippo_the_voice_call_ended"] = "आवाज कॉल समाप्त"
        messages["hippo_the_video_call_ended"] = "वीडियो कॉल समाप्त हो"
        messages["hippo_all_agents_busy"] = "सभी एजेंटों अभी व्यस्त हैं, तो हम आपको कुछ ही देर में कनेक्ट करेंगे"
        messages["hippo_copy_to_clipboard"] = "क्लिपबोर्ड पर नकल"
        messages["hippo_proceed_to_pay"] = "चुकाने के लिए कार्रवाई शुरू करो"

        return messages
    }*/
}