/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.filter.callback;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.CursorLoader;
import androidx.loader.content.Loader;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.filter.callback.FilterResultCallback;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import com.hippo.utils.filepicker.filter.loader.AudioLoader;
import com.hippo.utils.filepicker.filter.loader.FileLoader;
import com.hippo.utils.filepicker.filter.loader.ImageLoader;
import com.hippo.utils.filepicker.filter.loader.VideoLoader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileLoaderCallbacks
implements LoaderManager.LoaderCallbacks<Cursor> {
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_VIDEO = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_FILE = 3;
    private WeakReference<Context> context;
    private FilterResultCallback resultCallback;
    private int mType = 0;
    private String[] mSuffixArgs;
    private CursorLoader mLoader;
    private String mSuffixRegex;

    public FileLoaderCallbacks(Context context, FilterResultCallback resultCallback, int type) {
        this(context, resultCallback, type, null);
    }

    public FileLoaderCallbacks(Context context, FilterResultCallback resultCallback, int type, String[] suffixArgs) {
        this.context = new WeakReference<Context>(context);
        this.resultCallback = resultCallback;
        this.mType = type;
        this.mSuffixArgs = suffixArgs;
        if (suffixArgs != null && suffixArgs.length > 0) {
            this.mSuffixRegex = this.obtainSuffixRegex(suffixArgs);
        }
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        switch (this.mType) {
            case 0: {
                this.mLoader = new ImageLoader((Context)this.context.get());
                break;
            }
            case 1: {
                this.mLoader = new VideoLoader((Context)this.context.get());
                break;
            }
            case 2: {
                this.mLoader = new AudioLoader((Context)this.context.get());
                break;
            }
            case 3: {
                this.mLoader = new FileLoader((Context)this.context.get());
            }
        }
        return this.mLoader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        if (data == null) {
            return;
        }
        switch (this.mType) {
            case 0: {
                this.onImageResult(data);
                break;
            }
            case 1: {
                this.onVideoResult(data);
                break;
            }
            case 2: {
                this.onAudioResult(data);
                break;
            }
            case 3: {
                this.onFileResult(data);
            }
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    private void onImageResult(Cursor data) {
        ArrayList directories = new ArrayList();
        if (data.getPosition() != -1) {
            data.moveToPosition(-1);
        }
        while (data.moveToNext()) {
            ImageFile img = new ImageFile();
            img.setId(data.getLong(data.getColumnIndexOrThrow("_id")));
            img.setName(data.getString(data.getColumnIndexOrThrow("title")));
            img.setPath(data.getString(data.getColumnIndexOrThrow("_data")));
            img.setSize(data.getLong(data.getColumnIndexOrThrow("_size")));
            img.setBucketId(data.getString(data.getColumnIndexOrThrow("bucket_id")));
            img.setBucketName(data.getString(data.getColumnIndexOrThrow("bucket_display_name")));
            img.setDate(data.getLong(data.getColumnIndexOrThrow("date_added")));
            img.setOrientation(data.getInt(data.getColumnIndexOrThrow("orientation")));
            Directory<ImageFile> directory = new Directory<ImageFile>();
            directory.setId(img.getBucketId());
            directory.setName(img.getBucketName());
            directory.setPath(Util.extractPathWithoutSeparator(img.getPath()));
            if (!directories.contains(directory)) {
                directory.addFile(img);
                directories.add(directory);
                continue;
            }
            ((Directory)directories.get(directories.indexOf(directory))).addFile(img);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(directories);
        }
    }

    private void onVideoResult(Cursor data) {
        ArrayList directories = new ArrayList();
        if (data.getPosition() != -1) {
            data.moveToPosition(-1);
        }
        while (data.moveToNext()) {
            VideoFile video = new VideoFile();
            video.setId(data.getLong(data.getColumnIndexOrThrow("_id")));
            video.setName(data.getString(data.getColumnIndexOrThrow("title")));
            video.setPath(data.getString(data.getColumnIndexOrThrow("_data")));
            video.setSize(data.getLong(data.getColumnIndexOrThrow("_size")));
            video.setBucketId(data.getString(data.getColumnIndexOrThrow("bucket_id")));
            video.setBucketName(data.getString(data.getColumnIndexOrThrow("bucket_display_name")));
            video.setDate(data.getLong(data.getColumnIndexOrThrow("date_added")));
            video.setDuration(data.getLong(data.getColumnIndexOrThrow("duration")));
            Directory<VideoFile> directory = new Directory<VideoFile>();
            directory.setId(video.getBucketId());
            directory.setName(video.getBucketName());
            directory.setPath(Util.extractPathWithoutSeparator(video.getPath()));
            if (!directories.contains(directory)) {
                directory.addFile(video);
                directories.add(directory);
                continue;
            }
            ((Directory)directories.get(directories.indexOf(directory))).addFile(video);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(directories);
        }
    }

    private void onAudioResult(Cursor data) {
        ArrayList directories = new ArrayList();
        if (data.getPosition() != -1) {
            data.moveToPosition(-1);
        }
        while (data.moveToNext()) {
            AudioFile audio = new AudioFile();
            audio.setId(data.getLong(data.getColumnIndexOrThrow("_id")));
            audio.setName(data.getString(data.getColumnIndexOrThrow("title")));
            audio.setPath(data.getString(data.getColumnIndexOrThrow("_data")));
            audio.setSize(data.getLong(data.getColumnIndexOrThrow("_size")));
            audio.setDate(data.getLong(data.getColumnIndexOrThrow("date_added")));
            audio.setDuration(data.getLong(data.getColumnIndexOrThrow("duration")));
            Directory<AudioFile> directory = new Directory<AudioFile>();
            directory.setName(Util.extractFileNameWithSuffix(Util.extractPathWithoutSeparator(audio.getPath())));
            directory.setPath(Util.extractPathWithoutSeparator(audio.getPath()));
            if (!directories.contains(directory)) {
                directory.addFile(audio);
                directories.add(directory);
                continue;
            }
            ((Directory)directories.get(directories.indexOf(directory))).addFile(audio);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(directories);
        }
    }

    private void onFileResult(Cursor data) {
        ArrayList directories = new ArrayList();
        if (data.getPosition() != -1) {
            data.moveToPosition(-1);
        }
        while (data.moveToNext()) {
            String path = data.getString(data.getColumnIndexOrThrow("_data"));
            if (path == null || !this.contains(path)) continue;
            NormalFile file = new NormalFile();
            file.setId(data.getLong(data.getColumnIndexOrThrow("_id")));
            file.setName(data.getString(data.getColumnIndexOrThrow("title")));
            file.setPath(data.getString(data.getColumnIndexOrThrow("_data")));
            file.setSize(data.getLong(data.getColumnIndexOrThrow("_size")));
            file.setDate(data.getLong(data.getColumnIndexOrThrow("date_added")));
            file.setMimeType(data.getString(data.getColumnIndexOrThrow("mime_type")));
            Directory<NormalFile> directory = new Directory<NormalFile>();
            directory.setName(Util.extractFileNameWithSuffix(Util.extractPathWithoutSeparator(file.getPath())));
            directory.setPath(Util.extractPathWithoutSeparator(file.getPath()));
            if (!directories.contains(directory)) {
                directory.addFile(file);
                directories.add(directory);
                continue;
            }
            ((Directory)directories.get(directories.indexOf(directory))).addFile(file);
        }
        if (this.resultCallback != null) {
            this.resultCallback.onResult(directories);
        }
    }

    private boolean contains(String path) {
        String name = Util.extractFileNameWithSuffix(path);
        Pattern pattern = Pattern.compile(this.mSuffixRegex, 2);
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    private String obtainSuffixRegex(String[] suffixes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < suffixes.length; ++i) {
            if (i == 0) {
                builder.append(suffixes[i].replace(".", ""));
                continue;
            }
            builder.append("|\\.");
            builder.append(suffixes[i].replace(".", ""));
        }
        return ".+(\\." + builder.toString() + ")$";
    }
}

