/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Parcelable;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.utils.HippoLog;
import com.hippo.utils.filepicker.Util;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public class FuguImageUtils
implements FuguAppConstant {
    private static final String TAG = FuguImageUtils.class.getSimpleName();
    private Activity activity;

    public FuguImageUtils(Activity activity) {
        this.activity = activity;
    }

    public void startCamera() {
        HippoLog.e(TAG, "startCamera");
        if (!this.isCameraAvailable()) {
            Toast.makeText((Context)this.activity, (CharSequence)"Camera feature unavailable!", (int)0).show();
            return;
        }
        if (!this.isExternalStorageAvailable()) {
            Toast.makeText((Context)this.activity, (CharSequence)"External storage unavailable!", (int)0).show();
            return;
        }
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.activity.getPackageManager()) != null) {
            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
            String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            String fileName = "Hippochat_" + muid + ".jpg";
            File fileToBeWritten = new File(Util.getDirectoryPath((String)FOLDER_TYPE.get("image")), fileName);
            HippoLog.d(TAG, "Path: " + fileToBeWritten.getPath());
            HippoLog.d(TAG, "AbsolutePath: " + fileToBeWritten.getAbsolutePath());
            CommonData.setTime(fileToBeWritten.getAbsolutePath());
            CommonData.setImageMuid(muid);
            try {
                File file = fileToBeWritten.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                fileToBeWritten.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            takePictureIntent.putExtra("output", (Parcelable)FileProvider.getUriForFile((Context)this.activity, (String)CommonData.getProvider(), (File)fileToBeWritten));
            this.activity.startActivityForResult(takePictureIntent, 257);
        }
    }

    private boolean isCameraAvailable() {
        HippoLog.e(TAG, "isCameraAvailable");
        return this.activity.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    private boolean isExternalStorageAvailable() {
        HippoLog.e(TAG, "isExternalStorageAvailable");
        return "mounted".equals(Environment.getExternalStorageState());
    }
}

