/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.activity.FuguChatActivity;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.Message;
import com.hippo.receiver.NetworkUtil;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import faye.ConnectionManager;
import io.paperdb.Paper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class FuguNetworkStateReceiver
extends BroadcastReceiver
implements FuguAppConstant {
    private static final String TAG = FuguNetworkStateReceiver.class.getSimpleName();
    @NonNull
    private HashMap<Long, LinkedHashMap<String, JSONObject>> unsentMessageMap = new HashMap();
    private Long channelId;
    private HashMap<Long, LinkedHashMap<String, JSONObject>> allUnsentMessageMap = new HashMap();
    private LinkedHashMap<String, JSONObject> sendingMessages = new LinkedHashMap();
    private String tempDate = "";
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    public static HashMap<Long, LinkedHashMap<String, Message>> UNSENT_MESSAGES = new HashMap();
    private LinkedHashMap<String, Message> sendingMessagesList = new LinkedHashMap();
    private LinkedHashMap<String, Message> sentMessages = new LinkedHashMap();

    public void onReceive(Context context, Intent intent) {
        Paper.init((Context)context);
        int status = NetworkUtil.getConnectivityStatusString(context);
        try {
            ConnectionManager.INSTANCE.changeStatus(status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (HippoConfig.getInstance().getCallData() != null) {
                HippoLog.i("TAG", "Sending network update = " + status);
                HippoConfig.getInstance().getCallData().networkStatus(status);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            HippoLog.d("app", "Network connectivity change");
            if (intent.getExtras() != null) {
                NetworkInfo ni = (NetworkInfo)intent.getExtras().get("networkInfo");
                boolean isEnabled = ni != null && ni.getState() == NetworkInfo.State.CONNECTED;
                Intent mIntent = new Intent("network_state_changed");
                mIntent.putExtra("isConnected", isEnabled);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnectedServer() {
        try {
            this.setDateExpireDate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDisconnectedServer() {
    }

    public void onReceivedMessage(String msg, String channel) {
        this.onMessageReceived(msg, channel);
    }

    private void onMessageReceived(String msg, String channel) {
        Long channelid = null;
        channelid = Long.parseLong(channel.substring(1));
        try {
            JSONObject messageJson = new JSONObject(msg);
            if (messageJson.has("message") && !messageJson.getString("message").isEmpty() || messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) {
                String muid = messageJson.getString("muid");
                if (FuguChatActivity.currentChannelId != channelid) {
                    if (channelid != this.channelId && messageJson.optInt("message_type") == 10) {
                        return;
                    }
                    Message listItem = this.sendingMessagesList.get(messageJson.getString("muid"));
                    listItem.setMessageStatus(1);
                    String time = listItem.getSentAtUtc();
                    String localDate = DateUtils.getInstance().convertToLocal(time, this.inputFormat, this.outputFormat);
                    if (!this.tempDate.equalsIgnoreCase(localDate)) {
                        this.sentMessages.put(localDate, new Message(localDate, true));
                    }
                    this.sentMessages.put(messageJson.getString("muid"), listItem);
                    this.sendingMessages.remove(muid);
                    UNSENT_MESSAGES.remove(muid);
                    this.unsentMessageMap.remove(muid);
                    this.sendingMessages();
                } else {
                    if (this.sentMessages != null || this.sentMessages.size() > 0) {
                        CommonData.addExistingMessages(channelid, this.sentMessages);
                    }
                    this.allUnsentMessageMap.remove(channelid);
                    this.sendMessages();
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPongReceived() {
    }

    public void onWebSocketError() {
    }

    public void onErrorReceived(String msg, String channel) {
    }

    public void onNotConnected() {
    }

    private void setDateExpireDate() throws Exception {
        Long currentChannelId = 0L;
        currentChannelId = FuguChatActivity.currentChannelId;
        for (Long channelId : this.unsentMessageMap.keySet()) {
            if (currentChannelId.compareTo(channelId) == 0) continue;
            LinkedHashMap<String, Message> unsentMessage = UNSENT_MESSAGES.get(channelId);
            LinkedHashMap<String, JSONObject> unsentMessageObj = this.unsentMessageMap.get(channelId);
            if (unsentMessageObj != null && unsentMessageObj.size() == 0) {
                CommonData.removeUnsentMessageChannel(channelId);
                CommonData.removeUnsentMessageMapChannel(channelId);
                continue;
            }
            if (unsentMessage == null || unsentMessage.size() == 0) {
                return;
            }
            for (String key : unsentMessage.keySet()) {
                JSONObject messageJson;
                Message message = unsentMessage.get(key);
                String time = message.getSentAtUtc();
                int expireTimeCheck = message.getIsMessageExpired();
                if (message.getMessageType() != 10 && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                    message.setIsMessageExpired(1);
                    try {
                        messageJson = unsentMessageObj.get(key);
                        if (messageJson == null) continue;
                        messageJson.put("is_message_expired", 1);
                        unsentMessageObj.put(key, messageJson);
                    }
                    catch (Exception messageJson2) {}
                    continue;
                }
                if (message.getMessageType() != 10 || (messageJson = unsentMessageObj.get(key)) != null) continue;
                message.setMessageStatus(5);
            }
            this.allUnsentMessageMap.put(channelId, unsentMessageObj);
            if (FuguChatActivity.currentChannelId.compareTo(channelId) == 0) continue;
            UNSENT_MESSAGES.put(channelId, unsentMessage);
            this.unsentMessageMap.put(channelId, unsentMessageObj);
            CommonData.setUnsentMessageByChannel(channelId, unsentMessage);
            CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageObj);
        }
        this.sentMessages.clear();
        this.sendMessages();
    }

    private void sendMessages() throws Exception {
        if (this.allUnsentMessageMap != null && this.allUnsentMessageMap.size() > 0) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        Iterator iterator = FuguNetworkStateReceiver.this.allUnsentMessageMap.keySet().iterator();
                        if (!iterator.hasNext()) break block8;
                        Long key = (Long)iterator.next();
                        FuguNetworkStateReceiver.this.channelId = key;
                        if (FuguChatActivity.currentChannelId.compareTo(key) != 0) {
                            FuguNetworkStateReceiver.this.channelId = key;
                            if (FuguChatActivity.currentChannelId.compareTo(FuguNetworkStateReceiver.this.channelId) != 0) {
                                ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(key));
                            }
                            FuguNetworkStateReceiver.this.sendingMessages = (LinkedHashMap)FuguNetworkStateReceiver.this.allUnsentMessageMap.get(key);
                            FuguNetworkStateReceiver.this.sendingMessagesList = UNSENT_MESSAGES.get(key);
                            ArrayList reverseOrderedKeys = new ArrayList(FuguNetworkStateReceiver.this.sentMessages.keySet());
                            Collections.reverse(reverseOrderedKeys);
                            for (String key1 : reverseOrderedKeys) {
                                if (!((Message)FuguNetworkStateReceiver.this.sentMessages.get(key1)).isDateView()) continue;
                                FuguNetworkStateReceiver.this.tempDate = key1;
                                break;
                            }
                            try {
                                FuguNetworkStateReceiver.this.sendingMessages();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            FuguNetworkStateReceiver.this.allUnsentMessageMap.remove(FuguNetworkStateReceiver.this.channelId);
                            try {
                                FuguNetworkStateReceiver.this.sendMessages();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }, 1000L);
        }
    }

    private void sendingAgentMessages() throws Exception {
        if (this.sendingMessages.size() == 0) {
            this.allUnsentMessageMap.remove(this.channelId);
            ConnectionManager.INSTANCE.unsubScribeChannel(String.valueOf(this.channelId));
        } else {
            for (String key : this.sendingMessages.keySet()) {
                JSONObject messageJson = this.sendingMessages.get(key);
                if (messageJson.has("local_url") && !TextUtils.isEmpty((CharSequence)messageJson.optString("local_url", ""))) continue;
                HippoLog.e(TAG, "**************");
                ConnectionManager.INSTANCE.publish("/" + String.valueOf(this.channelId), messageJson);
                break;
            }
        }
    }

    private void sendingMessages() throws Exception {
        if (this.sendingMessages.size() == 0) {
            this.allUnsentMessageMap.remove(this.channelId);
            ConnectionManager.INSTANCE.unsubScribeChannel(String.valueOf(this.channelId));
            CommonData.removeUnsentMessageMapChannel(this.channelId);
            CommonData.removeUnsentMessageChannel(this.channelId);
            if (this.sentMessages != null && this.sentMessages.size() > 0) {
                CommonData.addExistingMessages(this.channelId, this.sentMessages);
            }
            this.sendMessages();
        } else {
            for (String key : this.sendingMessages.keySet()) {
                JSONObject messageJson = this.sendingMessages.get(key);
                if (messageJson.has("local_url") && !TextUtils.isEmpty((CharSequence)messageJson.optString("local_url", ""))) continue;
                if (messageJson.optInt("is_message_expired", 0) != 0) break;
                HippoLog.e(TAG, "**************");
                ConnectionManager.INSTANCE.publish("/" + String.valueOf(this.channelId), messageJson);
                break;
            }
        }
    }
}

