/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.interfaces.OnMultiSelectionListener;
import com.hippo.model.MultiSelectButtons;
import java.util.ArrayList;

public class MultiSelectionAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private ArrayList<MultiSelectButtons> selectButtons;
    private boolean isMultiSelected;
    private int maxSelection = 0;
    private int selectedCount = 0;
    private boolean isSelectable = true;
    private HippoColorConfig colorConfig;
    private OnMultiSelectionListener listener;

    public MultiSelectionAdapter(ArrayList<MultiSelectButtons> selectButtons, boolean isMultiSelected, int maxSelection, boolean isSelectable, HippoColorConfig colorConfig, OnMultiSelectionListener listener) {
        this.selectButtons = selectButtons;
        this.isMultiSelected = isMultiSelected;
        this.maxSelection = maxSelection;
        this.isSelectable = isSelectable;
        this.colorConfig = colorConfig;
        this.listener = listener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        this.context = viewGroup.getContext();
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_multi_selection, viewGroup, false), this.isMultiSelected);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        MultiSelectButtons buttons = this.selectButtons.get(i);
        viewHolder.textView.setText((CharSequence)buttons.getTitle());
        if (this.colorConfig != null) {
            viewHolder.textView.setTextColor(this.colorConfig.getHippoPrimaryTextMsgYou());
        }
        if (this.isMultiSelected) {
            viewHolder.radioButton.setVisibility(8);
            viewHolder.checkBox.setVisibility(0);
        } else {
            viewHolder.checkBox.setVisibility(8);
            viewHolder.radioButton.setVisibility(0);
        }
        if (buttons.getStatus() == 1) {
            viewHolder.checkBox.setChecked(true);
            viewHolder.radioButton.setChecked(true);
            viewHolder.mainLayout.setBackground(this.context.getDrawable(R.drawable.hippo_mullti_selector_bg));
        } else {
            viewHolder.mainLayout.setBackground(this.context.getDrawable(R.drawable.hippo_multi_normal_bg));
            viewHolder.checkBox.setChecked(false);
            viewHolder.radioButton.setChecked(false);
        }
        if (this.isSelectable) {
            viewHolder.checkBox.setEnabled(!this.isSelectable);
            viewHolder.radioButton.setEnabled(!this.isSelectable);
        }
    }

    public int getItemCount() {
        return this.selectButtons.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView textView;
        private CheckBox checkBox;
        private RadioButton radioButton;
        private LinearLayout mainLayout;

        public ViewHolder(View itemView, final boolean isMultiSelect) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.item_textview);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.cb_item_view);
            this.radioButton = (RadioButton)itemView.findViewById(R.id.rb_item_view);
            this.mainLayout = (LinearLayout)itemView.findViewById(R.id.main_layout);
            this.radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (buttonView.isPressed()) {
                        ViewHolder.this.mainLayout.performClick();
                    }
                }
            });
            this.checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (buttonView.isPressed()) {
                        if (MultiSelectionAdapter.this.maxSelection > 0 && MultiSelectionAdapter.this.selectedCount == MultiSelectionAdapter.this.maxSelection && isChecked) {
                            ViewHolder.this.checkBox.setChecked(!isChecked);
                            return;
                        }
                        ViewHolder.this.mainLayout.performClick();
                    }
                }
            });
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MultiSelectionAdapter.this.isSelectable) {
                        return;
                    }
                    if (isMultiSelect) {
                        if (((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).getStatus() == 0) {
                            if (MultiSelectionAdapter.this.maxSelection > 0 && MultiSelectionAdapter.this.selectedCount == MultiSelectionAdapter.this.maxSelection) {
                                MultiSelectionAdapter.this.notifyItemChanged(ViewHolder.this.getAdapterPosition());
                                return;
                            }
                            ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).setStatus(1);
                            MultiSelectionAdapter.this.selectedCount = MultiSelectionAdapter.this.selectedCount + 1;
                        } else {
                            ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).setStatus(0);
                            MultiSelectionAdapter.this.selectedCount = MultiSelectionAdapter.this.selectedCount - 1;
                        }
                        MultiSelectionAdapter.this.notifyItemChanged(ViewHolder.this.getAdapterPosition());
                    } else {
                        for (int i = 0; i < MultiSelectionAdapter.this.selectButtons.size(); ++i) {
                            ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(i)).setStatus(0);
                        }
                        ((MultiSelectButtons)MultiSelectionAdapter.this.selectButtons.get(ViewHolder.this.getAdapterPosition())).setStatus(1);
                        MultiSelectionAdapter.this.notifyDataSetChanged();
                    }
                    if (MultiSelectionAdapter.this.listener != null) {
                        MultiSelectionAdapter.this.listener.onItemClicked(MultiSelectionAdapter.this.selectButtons);
                    }
                }
            });
        }
    }
}

