/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.swipetoshow;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.hippo.utils.swipetoshow.HideContentHolder;

public class SwipeHolder
extends FrameLayout {
    private static final int ALIGN_ANIMATION_DURATION = 200;
    private HideContentHolder hideContentHolder;
    private View mainContent;
    boolean animating;

    public SwipeHolder(Context context) {
        super(context);
    }

    public SwipeHolder(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SwipeHolder(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.hideContentHolder = (HideContentHolder)this.getChildAt(0);
        this.mainContent = this.getChildAt(1);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.hideContentHolder.layout(right - this.hideContentHolder.getMeasuredWidth(), 0, right, this.hideContentHolder.getMeasuredHeight());
        this.mainContent.layout(0, 0, right, this.mainContent.getMeasuredHeight());
    }

    protected void slide(int x) {
        if (x < 0) {
            this.mainContent.scrollTo(0, 0);
            this.hideContentHolder.setShowPixel(0);
            return;
        }
        int hideContentHolderWidth = this.hideContentHolder.getWidth();
        if (x > hideContentHolderWidth) {
            float delta = x - hideContentHolderWidth;
            this.mainContent.scrollTo((int)((float)hideContentHolderWidth + delta * (1.0f - delta / (float)x)), 0);
        } else {
            this.mainContent.scrollTo(x, 0);
        }
        this.hideContentHolder.setShowPixel(x);
    }

    public void reset() {
        this.mainContent.scrollTo(0, 0);
        this.hideContentHolder.setShowPixel(0);
    }

    public boolean isAnimating() {
        return this.animating;
    }

    void animatedAlignShow() {
        final int hideContentHolderWidth = this.hideContentHolder.getWidth();
        final int deltaScrollX = this.mainContent.getScrollX() - hideContentHolderWidth;
        final int deltaShowPixel = this.hideContentHolder.getShowPixel() - hideContentHolderWidth;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f});
        valueAnimator.setDuration(200L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                SwipeHolder.this.mainContent.scrollTo(hideContentHolderWidth + (int)((float)deltaScrollX * (1.0f - fraction)), 0);
                SwipeHolder.this.hideContentHolder.setShowPixel(hideContentHolderWidth + (int)((float)deltaShowPixel * (1.0f - fraction)));
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                SwipeHolder.this.mainContent.scrollTo(hideContentHolderWidth, 0);
                SwipeHolder.this.animating = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        valueAnimator.start();
        this.animating = true;
    }

    void animateCollapse() {
        final int deltaShowPixel = this.hideContentHolder.getShowPixel();
        final int deltaScrollX = this.mainContent.getScrollX();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f});
        valueAnimator.setDuration(200L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                SwipeHolder.this.mainContent.scrollTo((int)((float)deltaScrollX * (1.0f - fraction)), 0);
                SwipeHolder.this.hideContentHolder.setShowPixel((int)((float)deltaShowPixel * (1.0f - fraction)));
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                SwipeHolder.this.mainContent.scrollTo(0, 0);
                SwipeHolder.this.hideContentHolder.setShowPixel(0);
                SwipeHolder.this.animating = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        valueAnimator.start();
        this.animating = true;
    }

    protected boolean isXInHideArea(int x) {
        return x > this.hideContentHolder.getLeft();
    }

    protected boolean determineShowOrHide() {
        if (this.hideContentHolder.getShowPixel() < this.hideContentHolder.getWidth() / 3) {
            this.animateCollapse();
            return false;
        }
        this.animatedAlignShow();
        return true;
    }
}

