/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.retrofit;

import com.hippo.HippoConfig;
import com.hippo.retrofit.RetrofitUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class MultipartParams {
    HashMap<String, RequestBody> map = new HashMap();

    private MultipartParams(Builder builder, int sourceType) {
        builder.map.put("source_type", RetrofitUtils.getRequestBodyFromString(String.valueOf(sourceType)));
        builder.map.put("app_version", RetrofitUtils.getRequestBodyFromString(String.valueOf(258)));
        builder.map.put("device_type", RetrofitUtils.getRequestBodyFromString(String.valueOf(1)));
        builder.map.put("lang", RetrofitUtils.getRequestBodyFromString(HippoConfig.getInstance().getCurrentLanguage()));
        this.map = builder.map;
    }

    public HashMap<String, RequestBody> getMap() {
        return this.map;
    }

    public static class Builder {
        HashMap<String, RequestBody> map = new HashMap();

        public Builder add(String key, Object value) {
            if (value == null || String.valueOf(value).isEmpty()) {
                return this;
            }
            this.map.put(key, RetrofitUtils.getRequestBodyFromString(String.valueOf(value)));
            return this;
        }

        public Builder addFile(String key, File mFile) {
            if (mFile == null) {
                return this;
            }
            this.map.put(key + "\"; filename=\"" + mFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(mFile)), (File)mFile));
            return this;
        }

        public Builder addArrayOfFiles(String key, ArrayList<File> mFileArrayList) {
            if (mFileArrayList == null || mFileArrayList.size() == 0) {
                return this;
            }
            for (int i = 0; i < mFileArrayList.size(); ++i) {
                if (mFileArrayList.get(i) == null) continue;
                this.map.put(key + "\"; filename=\"" + mFileArrayList.get(i).getName(), RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(mFileArrayList.get(i))), (File)mFileArrayList.get(i)));
            }
            return this;
        }

        public MultipartParams build() {
            return new MultipartParams(this, 1);
        }

        public MultipartParams build(int sourceType) {
            return new MultipartParams(this, 1);
        }
    }
}

