/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.FuguConversation;
import com.hippo.utils.ColorGenerator;
import com.hippo.utils.DateUtils;
import com.hippo.utils.TextDrawable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FuguChannelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater inflater;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;
    private String enUserId = "";
    private HippoColorConfig hippoColorConfig;
    private Callback callback;
    private RequestOptions options;
    private Typeface customBold;
    private Typeface customNormal;

    public FuguChannelsAdapter(Activity activity, ArrayList<FuguConversation> fuguConversationList, String userName, Long userId, String businessName, Callback callback, String enUserId, boolean hasButton) {
        this.inflater = LayoutInflater.from((Context)activity.getApplicationContext());
        this.hippoColorConfig = CommonData.getColorConfig();
        this.fuguConversationList = fuguConversationList;
        this.activity = activity;
        this.userName = userName;
        this.businessName = businessName;
        this.userId = userId;
        this.callback = callback;
        this.enUserId = enUserId;
        this.customBold = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/ProximaNova-Sbold.ttf");
        this.customNormal = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/ProximaNova-Reg.ttf");
    }

    private RequestOptions getRequestOptions(String name) {
        Resources r = this.activity.getResources();
        float px = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)r.getDisplayMetrics());
        int size = (int)TypedValue.applyDimension((int)2, (float)20.0f, (DisplayMetrics)r.getDisplayMetrics());
        name = name.trim();
        char text = ' ';
        if (TextUtils.isEmpty((CharSequence)name)) {
            String bname = CommonData.getUserDetails().getData().getBusinessName();
            text = bname.trim().charAt(0);
        } else {
            text = name.trim().charAt(0);
        }
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color2 = generator.getColor(Character.valueOf(text));
        Log.w((String)"color", (String)(text + " color = " + color2));
        TextDrawable drawable2 = TextDrawable.builder().beginConfig().fontSize(size).endConfig().buildRoundRect((text + "").toUpperCase(), color2, Math.round(px));
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).fitCenter()).priority(Priority.HIGH)).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(10)})).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        this.options.placeholder((Drawable)drawable2);
        this.options.error((Drawable)drawable2);
        return this.options;
    }

    public void updateList(ArrayList<FuguConversation> fuguConversationList) {
        this.fuguConversationList = fuguConversationList;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflater.inflate(R.layout.fugu_item_channels, parent, false);
        return new ChannelViewHolder(view);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        try {
            String you;
            final ChannelViewHolder channelViewHolder = (ChannelViewHolder)holder;
            final FuguConversation currentChannelItem = this.fuguConversationList.get(position);
            channelViewHolder.tvChannelName.setTextColor(this.hippoColorConfig.getHippoListTextColorPrimary());
            channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoListTextColorSecondary());
            String message = currentChannelItem.getMessage();
            String label = currentChannelItem.getLabel();
            try {
                String key;
                String value;
                Pattern pattern;
                Matcher matcher;
                if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getMultiLangMessage()) && (matcher = (pattern = Pattern.compile("\\{\\{\\{(.*?)\\}\\}\\}")).matcher(currentChannelItem.getMultiLangMessage())).find() && !TextUtils.isEmpty((CharSequence)(value = Restring.getString(key = matcher.group(1))))) {
                    String oldStr = "{{{" + key + "}}}";
                    message = currentChannelItem.getMultiLangMessage().replace(oldStr, value);
                }
            }
            catch (Exception pattern) {
                // empty catch block
            }
            if (currentChannelItem.getChannelType() == 2 && currentChannelItem.getChannelId() < 0L && currentChannelItem.getOtherLangData() != null && currentChannelItem.getOtherLangData().getLangCode().equalsIgnoreCase(HippoConfig.getInstance().getCurrentLanguage())) {
                message = currentChannelItem.getOtherLangData().getChannelMessage();
                label = currentChannelItem.getOtherLangData().getChannelName();
            }
            channelViewHolder.tvChannelName.setText((CharSequence)label);
            if (currentChannelItem.getMessage_type() == 18) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)this.getMessageData(currentChannelItem)));
            } else if (TextUtils.isEmpty((CharSequence)currentChannelItem.getMessage())) {
                if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                    String attached;
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                        String attached2;
                        you = Restring.getString((Context)this.activity, R.string.hippo_you);
                        if (currentChannelItem.getMessage_type() == 10) {
                            attached2 = Restring.getString((Context)this.activity, R.string.fugu_attachment);
                            channelViewHolder.tvMessage.setText((CharSequence)(you + ": " + attached2));
                        } else if (currentChannelItem.getMessage_type() == 11) {
                            attached2 = Restring.getString((Context)this.activity, R.string.hippo_attachment_file);
                            channelViewHolder.tvMessage.setText((CharSequence)(you + ": " + attached2));
                        } else {
                            String sentMsg = Restring.getString((Context)this.activity, R.string.hippo_sent_a_msg);
                            channelViewHolder.tvMessage.setText((CharSequence)(you + " " + sentMsg));
                        }
                    } else if (currentChannelItem.getMessage_type() == 10) {
                        attached = Restring.getString((Context)this.activity, R.string.fugu_attachment);
                        channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + attached));
                    } else if (currentChannelItem.getMessage_type() == 11) {
                        attached = Restring.getString((Context)this.activity, R.string.hippo_attachment_file);
                        channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + attached));
                    } else {
                        String sentMsg = Restring.getString((Context)this.activity, R.string.hippo_sent_a_msg);
                        channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + " " + sentMsg));
                    }
                }
            } else {
                you = Restring.getString((Context)this.activity, R.string.hippo_you);
                if (message.contains("\n")) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)message.replaceAll("\n", " ")));
                    if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                            channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(you + ": " + message)));
                        } else {
                            channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + message)));
                        }
                    } else if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(you + ": " + message)));
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)message));
                    }
                } else if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(you + ": " + message)));
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + message)));
                    }
                } else if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(you + ": " + message)));
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)message));
                }
            }
            try {
                channelViewHolder.tvChannelName.setTypeface(this.customBold);
                channelViewHolder.tvDate.setTypeface(this.customNormal);
                channelViewHolder.tvMessage.setTypeface(this.customNormal);
                channelViewHolder.circularTvMessageCount.setTypeface(this.customNormal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelDateText());
            if (currentChannelItem.getUnreadCount() > 0) {
                channelViewHolder.circularTvMessageCount.setVisibility(0);
                channelViewHolder.circularTvMessageCount.setText((CharSequence)String.valueOf(currentChannelItem.getUnreadCount()));
            } else {
                channelViewHolder.circularTvMessageCount.setVisibility(8);
                channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoChannelReadMessage());
                channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelReadTime());
                channelViewHolder.tvMessage.setTypeface(this.customBold);
            }
            String name = label.trim().substring(0, 1).toUpperCase();
            Glide.with((Activity)this.activity).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(name)).load(currentChannelItem.getChannelImage()).into(channelViewHolder.ivChannelIcon);
            channelViewHolder.ivChannelIcon.setVisibility(0);
            try {
                if (currentChannelItem.getChannelId() == null || currentChannelItem.getChannelId().intValue() < 0) {
                    channelViewHolder.tvDate.setVisibility(8);
                } else {
                    channelViewHolder.tvDate.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(currentChannelItem.getDateTime()), true));
                    channelViewHolder.tvDate.setVisibility(0);
                }
            }
            catch (Exception e) {
                channelViewHolder.tvDate.setVisibility(8);
            }
            channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    channelViewHolder.circularTvMessageCount.setVisibility(8);
                    currentChannelItem.setUnreadCount(0);
                    String message = currentChannelItem.getMessage();
                    String label = currentChannelItem.getLabel();
                    if (currentChannelItem.getChannelType() == 2 && currentChannelItem.getChannelId() < 0L && currentChannelItem.getOtherLangData() != null && currentChannelItem.getOtherLangData().getLangCode().equalsIgnoreCase(HippoConfig.getInstance().getCurrentLanguage())) {
                        message = currentChannelItem.getOtherLangData().getChannelMessage();
                        label = currentChannelItem.getOtherLangData().getChannelName();
                    }
                    FuguConversation conversation = new FuguConversation();
                    conversation.setLabel(label);
                    conversation.setChannelId(currentChannelItem.getChannelId());
                    conversation.setLabelId(currentChannelItem.getLabelId());
                    conversation.setDefaultMessage(message);
                    conversation.setChannelStatus(currentChannelItem.getChannelStatus());
                    conversation.setChannelImage(currentChannelItem.getChannelImage());
                    conversation.setBusinessName(FuguChannelsAdapter.this.businessName);
                    conversation.setUserId(FuguChannelsAdapter.this.userId);
                    conversation.setEnUserId(FuguChannelsAdapter.this.enUserId);
                    conversation.setOpenChat(true);
                    conversation.setUserName(FuguChannelsAdapter.this.userName);
                    conversation.setIsTimeSet(1);
                    conversation.setChatType(currentChannelItem.getChatType());
                    conversation.setStatus(currentChannelItem.getStatus());
                    conversation.setLast_sent_by_id(currentChannelItem.getLast_sent_by_id());
                    FuguChannelsAdapter.this.callback.onClick(conversation);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.fuguConversationList.size();
    }

    public void setTextSize(TextView textView, float size) {
        textView.setTextSize(2, size);
    }

    private String getMessageData(FuguConversation currentChannelItem) {
        String video;
        String message = "The video call ended";
        String callType = video = Restring.getString((Context)this.activity, R.string.fugu_video);
        if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            String voice;
            callType = voice = Restring.getString((Context)this.activity, R.string.fugu_voice);
        }
        if (currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState() == 2) {
            if (currentChannelItem.getLast_sent_by_id().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                String customer_missed_call = Restring.getString((Context)this.activity, R.string.hippo_customer_missed_a);
                String call_with_you = Restring.getString((Context)this.activity, R.string.hippo_call_with_you);
                message = customer_missed_call + " " + callType + " " + call_with_you;
            } else {
                String you_missed_a = Restring.getString((Context)this.activity, R.string.hippo_you_missed_a);
                String call_with = Restring.getString((Context)this.activity, R.string.hippo_call_with);
                message = you_missed_a + " " + callType + " " + call_with + " " + currentChannelItem.getLast_sent_by_full_name();
            }
        } else {
            String the = Restring.getString((Context)this.activity, R.string.hippo_the);
            String call_ended = Restring.getString((Context)this.activity, R.string.hippo_call_ended);
            message = the + " " + callType + " " + call_ended;
        }
        return message;
    }

    public static interface Callback {
        public void onClick(FuguConversation var1);
    }

    class footerView
    extends RecyclerView.ViewHolder {
        public footerView(View itemView) {
            super(itemView);
        }
    }

    class ChannelViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private RelativeLayout mainLayout;
        private TextView tvChannelName;
        private TextView tvMessage;
        private TextView tvDate;
        private ImageView ivChannelIcon;
        private TextView circularTvMessageCount;
        private TextView closed;

        ChannelViewHolder(View itemView) {
            super(itemView);
            this.rlRoot = (RelativeLayout)itemView.findViewById(R.id.rlRoot);
            this.tvChannelName = (TextView)itemView.findViewById(R.id.tvChannelName);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
            this.ivChannelIcon = (ImageView)itemView.findViewById(R.id.ivChannelIcon);
            this.circularTvMessageCount = (TextView)itemView.findViewById(R.id.circularTvMessageCount);
            this.closed = (TextView)itemView.findViewById(R.id.closed);
            this.mainLayout = (RelativeLayout)itemView.findViewById(R.id.main_layout);
            FuguChannelsAdapter.this.setTextSize(this.tvChannelName, 18.0f);
            FuguChannelsAdapter.this.setTextSize(this.tvMessage, 15.0f);
            FuguChannelsAdapter.this.setTextSize(this.tvDate, 12.0f);
            FuguChannelsAdapter.this.setTextSize(this.circularTvMessageCount, 12.0f);
        }
    }
}

