/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.activity.ImageDisplayActivityNew;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.AgentInfoResponse;
import com.hippo.model.CustomField;
import com.hippo.model.HippoUserProfileModel;
import com.hippo.model.Image;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.hippoHeaderBehavior.HippoHeaderView;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.io.Serializable;
import retrofit2.Callback;

public class ProfileActivity
extends FuguBaseActivity
implements AppBarLayout.OnOffsetChangedListener {
    private CollapsingToolbarLayout collapsingToolbar;
    protected HippoHeaderView toolbarHeaderView;
    protected HippoHeaderView floatHeaderView;
    protected AppBarLayout appBarLayout;
    protected Toolbar toolbar;
    private ImageView image;
    private LinearLayout contentLayout;
    private LinearLayout descFields;
    private View view;
    private HippoColorConfig hippoColorConfig;
    private HippoUserProfileModel profileModel;
    private boolean isHideToolbarView = false;
    private TextView description;
    private TextView descTitle;
    private TextView title_name;
    private ProgressWheel progressWheel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_profile);
        this.profileModel = (HippoUserProfileModel)this.getIntent().getSerializableExtra("profileModel");
        this.collapsingToolbar = (CollapsingToolbarLayout)this.findViewById(R.id.collapsingToolbar);
        this.toolbarHeaderView = (HippoHeaderView)this.findViewById(R.id.toolbar_header_view);
        this.floatHeaderView = (HippoHeaderView)this.findViewById(R.id.float_header_view);
        this.appBarLayout = (AppBarLayout)this.findViewById(R.id.appbar);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.contentLayout = (LinearLayout)this.findViewById(R.id.contentLayout);
        this.descFields = (LinearLayout)this.findViewById(R.id.descFields);
        this.descFields.setVisibility(8);
        this.image = (ImageView)this.findViewById(R.id.image);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.progress_wheel);
        this.hippoColorConfig = CommonData.getColorConfig();
        this.descTitle = (TextView)this.findViewById(R.id.desc_title);
        this.description = (TextView)this.findViewById(R.id.description);
        this.descTitle.setTextColor(this.hippoColorConfig.getHippoProfileTitle());
        this.description.setTextColor(this.hippoColorConfig.getHippoProfileValue());
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setTitle((CharSequence)"");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.toolbarHeaderView.setVisibility(8);
        this.initUi();
        this.getAgentInfo();
    }

    private void initUi() {
        this.appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        this.image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)ProfileActivity.this.profileModel.getImageUrl())) {
                        Intent profileImageIntent = new Intent((Context)ProfileActivity.this, ImageDisplayActivityNew.class);
                        Image profileImage = new Image(ProfileActivity.this.profileModel.getImageUrl(), ProfileActivity.this.profileModel.getImageUrl(), "imageOne", "", "");
                        profileImageIntent.putExtra("image", (Serializable)profileImage);
                        profileImageIntent.putExtra("hide_download", true);
                        ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)ProfileActivity.this, (View)ProfileActivity.this.image, (String)"imageOne");
                        ProfileActivity.this.startActivity(profileImageIntent, options.toBundle());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.loadImage();
        this.toolbarHeaderView.bindTo(this.profileModel.getTitle(), "");
        this.floatHeaderView.bindTo(this.profileModel.getTitle(), "");
    }

    private void loadImage() {
        RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this, 4, 1)).placeholder(ContextCompat.getDrawable((Context)this, (int)R.drawable.hippo_placeholder))).fitCenter()).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this, (int)R.drawable.hippo_placeholder));
        Glide.with((FragmentActivity)this).load(this.profileModel.getImageUrl()).apply((BaseRequestOptions)myOptions).into(this.image);
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int offset) {
        int maxScroll = appBarLayout.getTotalScrollRange();
        float percentage = (float)Math.abs(offset) / (float)maxScroll;
        if (percentage == 1.0f && this.isHideToolbarView) {
            this.toolbarHeaderView.setVisibility(0);
            this.isHideToolbarView = !this.isHideToolbarView;
        } else if (percentage < 1.0f && !this.isHideToolbarView) {
            this.toolbarHeaderView.setVisibility(8);
            this.isHideToolbarView = !this.isHideToolbarView;
        }
    }

    private void getAgentInfo() {
        this.progressWheel.setVisibility(0);
        this.progressWheel.spin();
        CommonParams.Builder params = new CommonParams.Builder();
        params.add("app_secret_key", HippoConfig.getInstance().getAppKey());
        params.add("en_user_id", this.profileModel.getEnUserId());
        if (TextUtils.isEmpty((CharSequence)this.profileModel.getUserId())) {
            params.add("channel_id", this.profileModel.getChannelID());
        } else {
            this.getSavedData(this.profileModel.getUserId());
            params.add("agent_id", this.profileModel.getUserId());
        }
        CommonParams commonParams = params.build();
        RestClient.getApiInterface().getAgentInfo(commonParams.getMap()).enqueue((Callback)new ResponseResolver<AgentInfoResponse>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(AgentInfoResponse commonResponse) {
                try {
                    ProfileActivity.this.showData(commonResponse);
                    if (!TextUtils.isEmpty((CharSequence)commonResponse.getData().getUserId())) {
                        CommonData.saveAgentData(commonResponse.getData().getUserId(), commonResponse);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ProfileActivity.this.progressWheel.setVisibility(8);
                    String alert = Restring.getString((Context)ProfileActivity.this, R.string.hippo_alert);
                    String text = Restring.getString((Context)ProfileActivity.this, R.string.hippo_something_wentwrong);
                    new AlertDialog.Builder((Context)ProfileActivity.this).setTitle((CharSequence)alert).setMessage((CharSequence)text).create().show();
                }
            }

            @Override
            public void failure(APIError error) {
                ProfileActivity.this.progressWheel.setVisibility(8);
                String alert = Restring.getString((Context)ProfileActivity.this, R.string.hippo_alert);
                String text = Restring.getString((Context)ProfileActivity.this, R.string.hippo_something_wentwrong);
                new AlertDialog.Builder((Context)ProfileActivity.this).setTitle((CharSequence)alert).setMessage((CharSequence)text).create().show();
            }
        });
    }

    private void showData(AgentInfoResponse commonResponse) {
        try {
            this.progressWheel.setVisibility(8);
            if (!TextUtils.isEmpty((CharSequence)commonResponse.getData().getDescription())) {
                this.descFields.setVisibility(0);
                this.description.setText((CharSequence)commonResponse.getData().getDescription());
            } else {
                this.descFields.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)commonResponse.getData().getUserImage())) {
                this.profileModel.setImageUrl(commonResponse.getData().getUserImage());
                this.loadImage();
            }
            if (!TextUtils.isEmpty((CharSequence)commonResponse.getData().getRating())) {
                this.toolbarHeaderView.bindTo(this.profileModel.getTitle(), commonResponse.getData().getRating());
                this.floatHeaderView.bindTo(this.profileModel.getTitle(), commonResponse.getData().getRating());
            }
            if (commonResponse.getData().getCustomFields() != null) {
                this.contentLayout.removeAllViews();
                for (CustomField field : commonResponse.getData().getCustomFields()) {
                    if (!field.getShowToCustomer().booleanValue() || TextUtils.isEmpty((CharSequence)field.getValue())) continue;
                    this.contentLayout.addView(this.getViews(field.getDisplayName(), field.getValue()));
                }
            } else {
                this.contentLayout.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getSavedData(String agentId) {
        AgentInfoResponse infoResponse = CommonData.getSavedAgentData(agentId);
        if (infoResponse != null && !TextUtils.isEmpty((CharSequence)infoResponse.getData().getFullName())) {
            this.showData(infoResponse);
        }
    }

    private View getViews(String titleStr, String detailStr) {
        LayoutInflater layoutInflater = (LayoutInflater)this.getBaseContext().getSystemService("layout_inflater");
        this.view = layoutInflater.inflate(R.layout.hippo_content_main, null, false);
        TextView title = (TextView)this.view.findViewById(R.id.title);
        TextView detail = (TextView)this.view.findViewById(R.id.detail);
        title.setTextColor(this.hippoColorConfig.getHippoProfileTitle());
        detail.setTextColor(this.hippoColorConfig.getHippoProfileValue());
        title.setText((CharSequence)titleStr);
        detail.setText((CharSequence)detailStr);
        return this.view;
    }
}

