/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.adapter.RecyclerItemClickListener;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import java.util.ArrayList;

public class AudioPickAdapter
extends BaseAdapter<AudioFile, AudioPickViewHolder>
implements RecyclerItemClickListener {
    private RecyclerView recyclerView;

    public AudioPickAdapter(Context ctx, RecyclerView recyclerView) {
        this(ctx, new ArrayList<AudioFile>(), recyclerView);
    }

    public AudioPickAdapter(Context ctx, ArrayList<AudioFile> list, RecyclerView recyclerView) {
        super(ctx, list);
        this.recyclerView = recyclerView;
    }

    public AudioPickViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_audio_pick, parent, false);
        return new AudioPickViewHolder(itemView, this);
    }

    public void onBindViewHolder(AudioPickViewHolder holder, int position) {
        AudioFile file = (AudioFile)this.mList.get(position);
        holder.mTvTitle.setText((CharSequence)file.getName());
        holder.mTvTitle.measure(0, 0);
        if (holder.mTvTitle.getMeasuredWidth() > Util.getScreenWidth(this.mContext) - Util.dip2px(this.mContext, 120.0f)) {
            holder.mTvTitle.setLines(2);
        } else {
            holder.mTvTitle.setLines(1);
        }
        holder.mCbx.setVisibility(0);
        holder.mTvDuration.setText((CharSequence)Util.getDurationString(file.getDuration()));
        if (file.isSelected()) {
            holder.mCbx.setSelected(true);
        } else {
            holder.mCbx.setSelected(false);
        }
    }

    private void selectItem(AudioPickViewHolder holder) {
        for (int i = 0; i < this.mList.size(); ++i) {
            if (i == holder.getAdapterPosition()) {
                if (((AudioFile)this.mList.get(i)).isSelected()) {
                    holder.mCbx.setSelected(false);
                    continue;
                }
                holder.mCbx.setSelected(true);
                continue;
            }
            holder.mCbx.setSelected(false);
        }
        this.notifyDataSetChanged();
        if (this.mListener != null) {
            this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), this.mList.get(holder.getAdapterPosition()));
        }
    }

    public int getItemCount() {
        return this.mList.size();
    }

    @Override
    public void onItemClick(View viewClicked, View parentView) {
        int i1;
        int positionInList = this.recyclerView.getChildLayoutPosition(parentView);
        if (positionInList != -1 && (i1 = viewClicked.getId()) == R.id.main_layout) {
            for (int i = 0; i < this.mList.size(); ++i) {
                if (i == positionInList) {
                    ((AudioFile)this.mList.get(i)).setSelected(true);
                    if (((AudioFile)this.mList.get(i)).isPlaying()) {
                        ((AudioFile)this.mList.get(i)).setPlaying(false);
                        continue;
                    }
                    ((AudioFile)this.mList.get(i)).setPlaying(true);
                    continue;
                }
                ((AudioFile)this.mList.get(i)).setSelected(false);
                ((AudioFile)this.mList.get(i)).setPlaying(false);
            }
            this.notifyDataSetChanged();
            if (this.mListener != null) {
                this.mListener.OnSelectStateChanged(((AudioFile)this.mList.get(positionInList)).isPlaying(), this.mList.get(positionInList));
            }
        }
    }

    @Override
    public void onItemSelected(View viewClicked, View parentView, boolean b) {
    }

    class AudioPickViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout mainLayout;
        private TextView mTvTitle;
        private TextView mTvDuration;
        private ImageView mCbx;

        public AudioPickViewHolder(final View itemView, final RecyclerItemClickListener itemClickListener) {
            super(itemView);
            this.mainLayout = (RelativeLayout)itemView.findViewById(R.id.main_layout);
            this.mTvTitle = (TextView)itemView.findViewById(R.id.tv_audio_title);
            this.mTvDuration = (TextView)itemView.findViewById(R.id.tv_duration);
            this.mCbx = (ImageView)itemView.findViewById(R.id.cbx);
            this.mCbx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)AudioPickViewHolder.this.mainLayout, itemView);
                }
            });
            this.mainLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)AudioPickViewHolder.this.mainLayout, itemView);
                }
            });
        }
    }
}

