/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.hippo.R;

public class RatingBarMenuFeedback
extends LinearLayout {
    private static final int LOW_RATING_RED = Color.parseColor((String)"#FB9758");
    private static final int MEDIUM_RATING_YELLOW = Color.parseColor((String)"#FFD365");
    private static final int GOOD_RATING_GREEN = Color.parseColor((String)"#8DCF61");
    private static final int RATING_DISABLED_COLOR = Color.parseColor((String)"#efefef");
    private static final int NO_RATING_COLOR = Color.parseColor((String)"#595968");
    private boolean mAnimate = true;
    private boolean mDisplayText = true;
    private int mMaxStars = 5;
    private float mCurrentScore = 0.0f;
    private int mStarOnResource;
    private int mStarOffResource;
    private int mStarHalfResource = R.drawable.ic_menu_feedback_star_off;
    private int belowTextColor;
    private boolean singleColor;
    private int starColor;
    private int noStarColor;
    private TextView[] mStarsViews;
    private float mStarPadding;
    private float viewMargin;
    private float mTextSize;
    private float compoundDrawablePadding;
    private float viewMinWidth;
    private IRatingBarCallbacks onScoreChanged;
    private int mLastStarId;
    private boolean mOnlyForDisplay;
    private double mLastX;
    private boolean mHalfStars = true;

    public IRatingBarCallbacks getOnScoreChanged() {
        return this.onScoreChanged;
    }

    public void setOnScoreChanged(IRatingBarCallbacks onScoreChanged) {
        this.onScoreChanged = onScoreChanged;
    }

    public RatingBarMenuFeedback(Context context) {
        super(context);
        this.init();
    }

    public TextView[] getmStarsViews() {
        return this.mStarsViews;
    }

    public float getScore() {
        return this.mCurrentScore;
    }

    public void setScore(float score, boolean giveCallback) {
        score = (float)Math.round(score * 2.0f) / 2.0f;
        if (!this.mHalfStars) {
            score = Math.round(score);
        }
        this.mCurrentScore = score;
        this.refreshStars();
        if (giveCallback && this.onScoreChanged != null) {
            this.onScoreChanged.scoreChanged(this.mCurrentScore);
        }
    }

    public void setStarResource(int fullIcon, int normalIcon) {
        this.mStarOnResource = fullIcon;
        this.mStarOffResource = normalIcon;
        this.mStarHalfResource = normalIcon;
    }

    public void setScrollToSelect(boolean enabled) {
        this.mOnlyForDisplay = !enabled;
    }

    public RatingBarMenuFeedback(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeAttributes(attrs, context);
        this.init();
    }

    private void initializeAttributes(AttributeSet attrs, Context context) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomRatingBar);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.CustomRatingBar_maxStars) {
                this.mMaxStars = a.getInt(attr2, 5);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_belowTextColor) {
                this.belowTextColor = a.getColor(attr2, ContextCompat.getColor((Context)context, (int)R.color.fugu_text_color_primary));
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_stars) {
                this.mCurrentScore = a.getFloat(attr2, 2.5f);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_starHalf) {
                this.mStarHalfResource = a.getResourceId(attr2, 17301620);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_starOn) {
                this.mStarOnResource = a.getResourceId(attr2, 17301620);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_starOff) {
                this.mStarOffResource = a.getResourceId(attr2, 17301621);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_starPadding) {
                this.mStarPadding = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_belowTextSize) {
                this.mTextSize = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_viewMargin) {
                this.viewMargin = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_viewMinWidth) {
                this.viewMinWidth = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_compoundDrawablePadding) {
                this.compoundDrawablePadding = a.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_onlyForDisplay) {
                this.mOnlyForDisplay = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_halfStars) {
                this.mHalfStars = a.getBoolean(attr2, true);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_animate) {
                this.mAnimate = a.getBoolean(attr2, true);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_displayText) {
                this.mDisplayText = a.getBoolean(attr2, true);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_singleColor) {
                this.singleColor = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.CustomRatingBar_starColor) {
                this.starColor = a.getColor(attr2, ContextCompat.getColor((Context)context, (int)R.color.fugu_theme_color_primary));
                continue;
            }
            if (attr2 != R.styleable.CustomRatingBar_noStarColor) continue;
            this.noStarColor = a.getColor(attr2, ContextCompat.getColor((Context)context, (int)R.color.fugu_secondary_text_msg_you));
        }
        a.recycle();
    }

    @TargetApi(value=11)
    public RatingBarMenuFeedback(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initializeAttributes(attrs, context);
        this.init();
    }

    void init() {
        this.mStarsViews = new TextView[this.mMaxStars];
        for (int i = 0; i < this.mMaxStars; ++i) {
            TextView v = this.createStar();
            this.addView((View)v);
            this.mStarsViews[i] = v;
        }
        this.refreshStars();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    private float getScoreForPosition(float x) {
        if (this.mHalfStars) {
            return (float)Math.round(x / ((float)this.getWidth() / ((float)this.mMaxStars * 3.0f)) / 3.0f * 2.0f) / 2.0f;
        }
        Float dividend = Float.valueOf(x / ((float)this.getWidth() / (float)this.mMaxStars));
        int finalValue = dividend.intValue() + 1;
        return finalValue > this.mMaxStars ? (float)this.mMaxStars : (finalValue < 0 ? 0.0f : (float)finalValue);
    }

    private int getImageForScore(float score) {
        if (score > 0.0f) {
            return Math.round(score) - 1;
        }
        return -1;
    }

    private void refreshStars() {
        boolean flagHalf = this.mCurrentScore != 0.0f && (double)this.mCurrentScore % 0.5 == 0.0 && this.mHalfStars;
        for (int i = 1; i <= this.mMaxStars; ++i) {
            if ((float)i <= this.mCurrentScore) {
                this.mStarsViews[i - 1].setCompoundDrawablesWithIntrinsicBounds(0, this.mStarOnResource, 0, 0);
                this.starColor = this.mCurrentScore >= 3.0f ? GOOD_RATING_GREEN : (this.mCurrentScore > 1.0f ? MEDIUM_RATING_YELLOW : LOW_RATING_RED);
                this.mStarsViews[i - 1].getCompoundDrawables()[1].mutate().setColorFilter(this.starColor, PorterDuff.Mode.SRC_ATOP);
            } else {
                if (flagHalf && (double)i - 0.5 <= (double)this.mCurrentScore) {
                    this.mStarsViews[i - 1].setCompoundDrawablesWithIntrinsicBounds(0, this.mStarHalfResource, 0, 0);
                } else {
                    this.mStarsViews[i - 1].setCompoundDrawablesWithIntrinsicBounds(0, this.mStarOffResource, 0, 0);
                }
                if (this.singleColor) {
                    this.mStarsViews[i - 1].getCompoundDrawables()[1].mutate().setColorFilter(RATING_DISABLED_COLOR, PorterDuff.Mode.SRC_ATOP);
                } else {
                    this.mStarsViews[i - 1].getCompoundDrawables()[1].mutate().setColorFilter(RATING_DISABLED_COLOR, PorterDuff.Mode.SRC_ATOP);
                }
            }
            if (!this.mDisplayText) continue;
            if ((float)i == this.mCurrentScore) {
                switch (i) {
                    case 1: {
                        this.mStarsViews[i - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_terrible));
                        break;
                    }
                    case 2: {
                        this.mStarsViews[i - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_bad));
                        break;
                    }
                    case 3: {
                        this.mStarsViews[i - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_okay));
                        break;
                    }
                    case 4: {
                        this.mStarsViews[i - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_good));
                        break;
                    }
                    case 5: {
                        this.mStarsViews[i - 1].setText((CharSequence)this.getContext().getString(R.string.hippo_smile_rating_great));
                    }
                }
                continue;
            }
            this.mStarsViews[i - 1].setText(null);
        }
    }

    private TextView createStar() {
        TextView v = new TextView(this.getContext());
        v.setMinWidth((int)(this.viewMinWidth > 0.0f ? this.viewMinWidth : 100.0f));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.weight = 1.0f;
        params.leftMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        params.rightMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        if (Build.VERSION.SDK_INT >= 17) {
            params.setMarginStart((int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f));
            params.setMarginEnd((int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f));
        }
        params.bottomMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        params.topMargin = (int)(this.viewMargin > 0.0f ? this.viewMargin : 5.0f);
        v.setGravity(17);
        v.setCompoundDrawablePadding((int)(this.compoundDrawablePadding > 0.0f ? this.compoundDrawablePadding : 5.0f));
        v.setTextSize(2, this.mTextSize > 0.0f ? this.mTextSize : 14.0f);
        v.setTextColor(this.belowTextColor > 0 ? this.belowTextColor : ContextCompat.getColor((Context)this.getContext(), (int)R.color.fugu_text_color_primary));
        v.setLayoutParams((ViewGroup.LayoutParams)params);
        v.setCompoundDrawablesWithIntrinsicBounds(0, this.mStarOffResource, 0, 0);
        v.setPaddingRelative((int)this.mStarPadding, (int)this.mStarPadding, (int)this.mStarPadding, (int)this.mStarPadding);
        return v;
    }

    private TextView getImageView(int position) {
        try {
            return this.mStarsViews[position];
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mOnlyForDisplay) {
            return true;
        }
        switch (event.getAction()) {
            case 1: {
                this.animateStarRelease(this.getImageView(this.mLastStarId), this.mCurrentScore);
                this.mLastStarId = -1;
                break;
            }
            case 2: {
                if (Math.abs((double)event.getX() - this.mLastX) > 80.0) {
                    this.requestDisallowInterceptTouchEvent(true);
                }
                float lastscore = this.mCurrentScore;
                this.mCurrentScore = this.getScoreForPosition(event.getX());
                if (lastscore == this.mCurrentScore) break;
                this.animateStarRelease(this.getImageView(this.mLastStarId), this.mCurrentScore);
                this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)), this.mCurrentScore);
                this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                this.refreshStars();
                if (this.onScoreChanged == null) break;
                this.onScoreChanged.scoreChanged(this.mCurrentScore);
                break;
            }
            case 0: {
                this.mLastX = event.getX();
                float lastscore = this.mCurrentScore;
                this.mCurrentScore = this.getScoreForPosition(event.getX());
                this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)), this.mCurrentScore);
                this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                if (lastscore != this.mCurrentScore) {
                    this.refreshStars();
                    if (this.onScoreChanged != null) {
                        this.onScoreChanged.scoreChanged(this.mCurrentScore);
                    }
                }
                return true;
            }
            case 3: {
                this.animateStarRelease(this.getImageView(this.getImageForScore(this.mCurrentScore)), this.mCurrentScore);
            }
        }
        return true;
    }

    private void animateStarPressed(TextView star, float score) {
        if (this.mAnimate && star != null) {
            ViewCompat.animate((View)star).scaleX(1.2f).scaleY(1.2f).setDuration(100L).start();
        }
    }

    private void animateStarRelease(TextView star, float score) {
        if (this.mAnimate && star != null) {
            ViewCompat.animate((View)star).scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
        }
    }

    public boolean isHalfStars() {
        return this.mHalfStars;
    }

    public void setHalfStars(boolean halfStars) {
        this.mHalfStars = halfStars;
    }

    public void setEnabled(boolean isEnabled) {
        this.mOnlyForDisplay = !isEnabled;
    }

    public void setRatingDisabled(boolean disabled) {
        if (disabled) {
            for (int i = 1; i <= this.mMaxStars; ++i) {
                this.mStarsViews[i - 1].getCompoundDrawables()[1].mutate().setColorFilter(RATING_DISABLED_COLOR, PorterDuff.Mode.SRC_ATOP);
            }
        } else {
            this.refreshStars();
        }
    }

    public static interface IRatingBarCallbacks {
        public void scoreChanged(float var1);
    }
}

