/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class ImagePickAdapter
extends BaseAdapter<ImageFile, ImagePickViewHolder> {
    private boolean isNeedImagePager;
    private boolean isNeedCamera;
    private int mMaxNumber;
    private int mCurrentNumber = 0;
    public String mImagePath;
    public Uri mImageUri;
    private static final int COLUMN_NUMBER = 3;

    public ImagePickAdapter(Context ctx, boolean needCamera, boolean isNeedImagePager, int max) {
        this(ctx, new ArrayList<ImageFile>(), needCamera, isNeedImagePager, max);
    }

    public ImagePickAdapter(Context ctx, ArrayList<ImageFile> list, boolean needCamera, boolean needImagePager, int max) {
        super(ctx, list);
        this.isNeedCamera = needCamera;
        this.mMaxNumber = max;
        this.isNeedImagePager = needImagePager;
    }

    public ImagePickViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_image_pick, parent, false);
        ViewGroup.LayoutParams params = itemView.getLayoutParams();
        if (params != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            int width = wm.getDefaultDisplay().getWidth();
            params.height = width / 3;
        }
        return new ImagePickViewHolder(itemView);
    }

    public void onBindViewHolder(final ImagePickViewHolder holder, int position) {
        if (this.isNeedCamera && position == 0) {
            holder.mIvCamera.setVisibility(0);
            holder.mIvThumbnail.setVisibility(4);
            holder.mCbx.setVisibility(4);
            holder.mShadow.setVisibility(4);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                    String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
                    File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/IMG_" + timeStamp + ".jpg");
                    ImagePickAdapter.this.mImagePath = file.getAbsolutePath();
                    ContentValues contentValues = new ContentValues(1);
                    contentValues.put("_data", ImagePickAdapter.this.mImagePath);
                    ImagePickAdapter.this.mImageUri = ImagePickAdapter.this.mContext.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                    intent.putExtra("output", (Parcelable)ImagePickAdapter.this.mImageUri);
                    if (Util.detectIntent(ImagePickAdapter.this.mContext, intent)) {
                        ((Activity)ImagePickAdapter.this.mContext).startActivityForResult(intent, 257);
                    } else {
                        ToastUtil.getInstance(ImagePickAdapter.this.mContext).showToast(ImagePickAdapter.this.mContext.getString(R.string.vw_no_photo_app));
                    }
                }
            });
        } else {
            holder.mIvCamera.setVisibility(4);
            holder.mIvThumbnail.setVisibility(0);
            if (!this.isNeedImagePager) {
                holder.mCbx.setVisibility(0);
            }
            ImageFile file = this.isNeedCamera ? (ImageFile)this.mList.get(position - 1) : (ImageFile)this.mList.get(position);
            RequestOptions options = new RequestOptions();
            Glide.with((Context)this.mContext).load(file.getPath()).apply(options.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(holder.mIvThumbnail);
            if (file.isSelected()) {
                holder.mCbx.setSelected(true);
                holder.mShadow.setVisibility(0);
            } else {
                holder.mCbx.setSelected(false);
                holder.mShadow.setVisibility(4);
            }
            holder.mCbx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int index;
                    if (!v.isSelected() && ImagePickAdapter.this.isUpToMax()) {
                        ToastUtil.getInstance(ImagePickAdapter.this.mContext).showToast(R.string.vw_up_to_max);
                        return;
                    }
                    int n = index = ImagePickAdapter.this.isNeedCamera ? holder.getAdapterPosition() - 1 : holder.getAdapterPosition();
                    if (v.isSelected()) {
                        holder.mShadow.setVisibility(4);
                        holder.mCbx.setSelected(false);
                        ImagePickAdapter.this.mCurrentNumber--;
                        ((ImageFile)ImagePickAdapter.this.mList.get(index)).setSelected(false);
                    } else {
                        holder.mShadow.setVisibility(0);
                        holder.mCbx.setSelected(true);
                        ImagePickAdapter.this.mCurrentNumber++;
                        ((ImageFile)ImagePickAdapter.this.mList.get(index)).setSelected(true);
                    }
                    if (ImagePickAdapter.this.mListener != null) {
                        ImagePickAdapter.this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), ImagePickAdapter.this.mList.get(index));
                    }
                }
            });
            if (this.isNeedImagePager) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int index = ImagePickAdapter.this.isNeedCamera ? holder.getAdapterPosition() - 1 : holder.getAdapterPosition();
                        holder.mShadow.setVisibility(0);
                        holder.mCbx.setSelected(true);
                        ImagePickAdapter.this.mCurrentNumber++;
                        ((ImageFile)ImagePickAdapter.this.mList.get(index)).setSelected(true);
                        if (ImagePickAdapter.this.mListener != null) {
                            ImagePickAdapter.this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), ImagePickAdapter.this.mList.get(index));
                        }
                    }
                });
            } else {
                holder.mIvThumbnail.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int index;
                        if (!holder.mCbx.isSelected() && ImagePickAdapter.this.isUpToMax()) {
                            ToastUtil.getInstance(ImagePickAdapter.this.mContext).showToast(R.string.vw_up_to_max);
                            return;
                        }
                        int n = index = ImagePickAdapter.this.isNeedCamera ? holder.getAdapterPosition() - 1 : holder.getAdapterPosition();
                        if (holder.mCbx.isSelected()) {
                            holder.mShadow.setVisibility(4);
                            holder.mCbx.setSelected(false);
                            ImagePickAdapter.this.mCurrentNumber--;
                            ((ImageFile)ImagePickAdapter.this.mList.get(index)).setSelected(false);
                        } else {
                            holder.mShadow.setVisibility(0);
                            holder.mCbx.setSelected(true);
                            ImagePickAdapter.this.mCurrentNumber++;
                            ((ImageFile)ImagePickAdapter.this.mList.get(index)).setSelected(true);
                        }
                        if (ImagePickAdapter.this.mListener != null) {
                            ImagePickAdapter.this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), ImagePickAdapter.this.mList.get(index));
                        }
                    }
                });
            }
        }
    }

    public int getItemCount() {
        return this.isNeedCamera ? this.mList.size() + 1 : this.mList.size();
    }

    public boolean isUpToMax() {
        return this.mCurrentNumber >= this.mMaxNumber;
    }

    public void setCurrentNumber(int number) {
        this.mCurrentNumber = number;
    }

    class ImagePickViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvCamera;
        private ImageView mIvThumbnail;
        private View mShadow;
        private ImageView mCbx;

        public ImagePickViewHolder(View itemView) {
            super(itemView);
            this.mIvCamera = (ImageView)itemView.findViewById(R.id.iv_camera);
            this.mIvThumbnail = (ImageView)itemView.findViewById(R.id.iv_thumbnail);
            this.mShadow = itemView.findViewById(R.id.shadow);
            this.mCbx = (ImageView)itemView.findViewById(R.id.cbx);
        }
    }
}

