/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.LibApp;
import com.hippo.R;
import com.hippo.activity.BaseFragment;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.FuguChannelsAdapter;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.eventbus.BusProvider;
import com.hippo.eventbus.ConversationEvent;
import com.hippo.eventbus.OnViewUpdate;
import com.hippo.helper.GeneralFunctions;
import com.hippo.langs.Restring;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.receiver.NetworkStatus;
import com.hippo.utils.FloatingActionButtonExpandable;
import com.hippo.utils.filepicker.Util;
import com.squareup.otto.Subscribe;
import java.util.ArrayList;

public class OpenChannelFragment
extends BaseFragment
implements FuguAppConstant,
SwipeRefreshLayout.OnRefreshListener {
    private View rootView;
    private RelativeLayout rlRoot;
    private SwipeRefreshLayout swipeRefresh;
    private RecyclerView rvChannels;
    private TextView tvNoInternet;
    private TextView tvNewConversation;
    private HippoColorConfig hippoColorConfig;
    private TextView tvPoweredBy;
    private LinearLayout retryLayout;
    private TextView btnRetry;
    private Button noChatBtn;
    private final int IS_HIT_REQUIRED = 200;
    private final String TAG = OpenChannelFragment.class.getSimpleName();
    private FuguChannelsAdapter fuguChannelsAdapter;
    private ArrayList<FuguConversation> openConversationList = new ArrayList();
    private ArrayList<FuguConversation> closeConversationList = new ArrayList();
    private LinearLayout llNoConversation;
    private TextView noConversationTextView;
    private FloatingActionButtonExpandable createBtn;
    private String label = "";
    private Long userId = -1L;
    private String enUserId = "";
    private String userName = "Anonymous";
    private String businessName = "Anonymous";
    private int appVersion = 0;
    private boolean isClosedChannel = false;
    private boolean hasCreateNowBtn = false;
    private boolean showEmptyChatBtn = false;
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED_TO_INTERNET = 1;
    private static final int CONNECTED_TO_INTERNET_VIA_WIFI = 2;
    HippoConfigAttributes attributes;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null && this.getArguments().containsKey("isClosedChannel")) {
            this.isClosedChannel = this.getArguments().getBoolean("isClosedChannel", false);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.fugu_activity_channel, container, false);
        return this.rootView;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initViews(view);
    }

    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    private void initViews(View view) {
        this.hippoColorConfig = CommonData.getColorConfig();
        this.rlRoot = (RelativeLayout)view.findViewById(R.id.rlRoot);
        this.swipeRefresh = (SwipeRefreshLayout)view.findViewById(R.id.swipeRefresh);
        this.swipeRefresh.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.rvChannels = (RecyclerView)view.findViewById(R.id.rvChannels);
        this.createBtn = (FloatingActionButtonExpandable)view.findViewById(R.id.createBtn);
        this.tvNoInternet = (TextView)view.findViewById(R.id.tvNoInternet);
        this.tvNewConversation = (TextView)view.findViewById(R.id.tvNewConversation);
        this.btnRetry = (TextView)view.findViewById(R.id.tvStatus);
        this.retryLayout = (LinearLayout)view.findViewById(R.id.llInternet);
        this.llNoConversation = (LinearLayout)view.findViewById(R.id.llNoConversation);
        this.noConversationTextView = (TextView)view.findViewById(R.id.noConversationTextView);
        this.tvPoweredBy = (TextView)view.findViewById(R.id.tvPoweredBy);
        this.noChatBtn = (Button)view.findViewById(R.id.noChatBtn);
        this.tvPoweredBy.setVisibility(8);
        this.tvNoInternet.setVisibility(8);
        this.swipeRefresh.setVisibility(0);
        this.swipeRefresh.setColorSchemeResources(new int[]{R.color.hippo_white});
        this.swipeRefresh.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        this.swipeRefresh.setSize(1);
        this.createBtn.setContent(Restring.getString((Context)this.getActivity(), R.string.fugu_create_conversation));
        this.tvNewConversation.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.fugu_new_conversation));
        this.noConversationTextView.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_you_have_no_chats));
        this.noChatBtn.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_find_an_expert));
        if (this.getAttributes() != null && this.getAttributes().getAdditionalInfo() != null) {
            if (!TextUtils.isEmpty((CharSequence)this.getAttributes().getAdditionalInfo().getEmptyChannelList())) {
                this.noConversationTextView.setText((CharSequence)this.getAttributes().getAdditionalInfo().getEmptyChannelList());
            }
            if (this.getAttributes().getAdditionalInfo().isHasCreateNewChat()) {
                this.createBtn.setVisibility(0);
                this.hasCreateNowBtn = true;
            }
            if (this.hasCreateNowBtn) {
                this.createBtn.setVisibility(0);
            } else {
                this.createBtn.setVisibility(8);
            }
            if (this.getAttributes().getAdditionalInfo().showEmptyChatBtn()) {
                this.showEmptyChatBtn = true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.getAttributes().getAdditionalInfo().getCreateChatBtnText())) {
                this.createBtn.setContent(this.getAttributes().getAdditionalInfo().getCreateChatBtnText());
            }
            this.createBtn.setTextColor(this.hippoColorConfig.getHippoFloatingBtnText());
            this.createBtn.setBackgroundButtonColor(this.hippoColorConfig.getHippoFloatingBtnBg());
            this.createBtn.expand(true);
        }
        this.configColors();
        if (!this.isNetworkAvailable() && !this.isNetworkAvailable()) {
            this.setConnectionMessage(3);
        }
        this.rvChannels.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (OpenChannelFragment.this.createBtn.getVisibility() == 0) {
                    if (dy > 0) {
                        OpenChannelFragment.this.createBtn.collapse(true);
                    } else {
                        OpenChannelFragment.this.createBtn.expand(true);
                    }
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0 && !OpenChannelFragment.this.isClosedChannel && OpenChannelFragment.this.hasCreateNowBtn) {
                    OpenChannelFragment.this.createBtn.setVisibility(0);
                }
                super.onScrollStateChanged(recyclerView, newState);
            }
        });
        this.createBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BusProvider.getInstance().post((Object)new ConversationEvent(2));
                try {
                    LibApp.getInstance().trackEvent("List Screen", "Button clicked", "New chat");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.noChatBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (HippoConfig.getInstance().getHippoAdditionalListener() != null) {
                    HippoConfig.getInstance().getHippoAdditionalListener().onNoChatListener();
                }
                BusProvider.getInstance().post((Object)new ConversationEvent(3));
            }
        });
        if (this.isClosedChannel) {
            this.createBtn.setVisibility(8);
        }
        this.setRecyclerViewData();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                block3: {
                    FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
                    try {
                        if (CommonData.getConversationList().size() > 0) {
                            OpenChannelFragment.this.notifyData((ArrayList)CommonData.getConversationList());
                        }
                    }
                    catch (Exception e) {
                        if (!HippoConfig.DEBUG) break block3;
                        e.printStackTrace();
                    }
                }
            }
        }, 100L);
    }

    private void configColors() {
        this.tvNewConversation.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        if (Build.VERSION.SDK_INT >= 16) {
            this.tvNewConversation.setBackground((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg()));
        } else {
            this.tvNewConversation.setBackgroundDrawable((Drawable)HippoColorConfig.makeRoundedSelector(this.hippoColorConfig.getHippoActionBarBg()));
        }
        this.tvNewConversation.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.tvNoInternet.setTextColor(this.hippoColorConfig.getHippoThemeColorSecondary());
    }

    private void setRecyclerViewData() {
        FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
        this.label = userData.getBusinessName();
        this.businessName = userData.getBusinessName();
        this.userId = userData.getUserId();
        this.enUserId = userData.getEn_user_id();
        if (!TextUtils.isEmpty((CharSequence)userData.getFullName())) {
            this.userName = userData.getFullName();
        }
        this.fuguChannelsAdapter = this.isClosedChannel ? new FuguChannelsAdapter((Activity)this.getActivity(), this.closeConversationList, this.userName, this.userId, this.businessName, new FuguChannelsAdapter.Callback(){

            @Override
            public void onClick(FuguConversation conversation) {
                Intent chatIntent = new Intent((Context)OpenChannelFragment.this.getActivity(), FuguChatActivity.class);
                chatIntent.putExtra("is_from_history", false);
                chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                OpenChannelFragment.this.startActivityForResult(chatIntent, 200);
            }
        }, this.enUserId, false) : new FuguChannelsAdapter((Activity)this.getActivity(), this.openConversationList, this.userName, this.userId, this.businessName, new FuguChannelsAdapter.Callback(){

            @Override
            public void onClick(FuguConversation conversation) {
                Intent chatIntent = new Intent((Context)OpenChannelFragment.this.getActivity(), FuguChatActivity.class);
                chatIntent.putExtra("is_from_history", false);
                chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                OpenChannelFragment.this.startActivityForResult(chatIntent, 200);
            }
        }, this.enUserId, true);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.rvChannels.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.rvChannels.setAdapter((RecyclerView.Adapter)this.fuguChannelsAdapter);
        if (this.hasCreateNowBtn) {
            this.rvChannels.setPadding(0, Util.dip2px(this.getContext(), 16.0f), 0, Util.dip2px(this.getContext(), 75.0f));
        } else {
            this.rvChannels.setPadding(0, Util.dip2px(this.getContext(), 16.0f), 0, 0);
        }
    }

    public void onRefresh() {
        BusProvider.getInstance().post((Object)new ConversationEvent(1));
    }

    @Subscribe
    public void onViewUpdate(OnViewUpdate update) {
        switch (update.type) {
            case 1: {
                this.tvNoInternet.setVisibility(0);
                this.swipeRefresh.setVisibility(8);
                this.tvNewConversation.setVisibility(8);
                break;
            }
            case 2: {
                this.notifyData(update.fuguConversationList);
                this.swipeRefresh.setRefreshing(false);
                break;
            }
            case 3: {
                this.swipeRefresh.setRefreshing(false);
                break;
            }
            case 4: {
                this.setRecyclerViewData();
                break;
            }
        }
    }

    private HippoConfigAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = CommonData.getAttributes();
        }
        return this.attributes;
    }

    private void notifyData(ArrayList<FuguConversation> conversationList) {
        this.openConversationList.clear();
        this.closeConversationList.clear();
        if (this.getAttributes() != null && this.getAttributes().getAdditionalInfo() != null && this.getAttributes().getAdditionalInfo().isHasChannelPager()) {
            for (FuguConversation conversation : conversationList) {
                if (this.isClosedChannel && conversation.getChannelStatus() == ChannelStatus.CLOSED.getOrdinal()) {
                    this.closeConversationList.add(conversation);
                    continue;
                }
                if (this.isClosedChannel || conversation.getChannelStatus() == ChannelStatus.CLOSED.getOrdinal()) continue;
                this.openConversationList.add(conversation);
            }
        } else {
            this.openConversationList.addAll(conversationList);
        }
        this.fuguChannelsAdapter.notifyDataSetChanged();
        if (this.isClosedChannel) {
            if (this.closeConversationList == null || this.closeConversationList.size() == 0) {
                this.llNoConversation.setVisibility(0);
                this.noConversationTextView.setVisibility(0);
                this.noConversationTextView.setTextSize(2, 16.0f);
                this.noConversationTextView.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_you_have_no_chats));
            } else {
                this.llNoConversation.setVisibility(8);
                this.noConversationTextView.setVisibility(8);
            }
        } else if (this.openConversationList == null || this.openConversationList.size() == 0) {
            this.llNoConversation.setVisibility(0);
            this.noConversationTextView.setVisibility(0);
            this.noConversationTextView.setTextSize(2, 16.0f);
            this.noConversationTextView.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_you_have_no_chats));
        } else {
            this.llNoConversation.setVisibility(8);
            this.noConversationTextView.setVisibility(8);
        }
        if (this.showEmptyChatBtn && conversationList.size() == 0) {
            this.noChatBtn.setVisibility(0);
            this.noChatBtn.setTextSize(2, 16.0f);
            this.noConversationTextView.setTextSize(2, 16.0f);
            this.noConversationTextView.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_no_chat_init));
        } else {
            this.noChatBtn.setVisibility(8);
            this.noConversationTextView.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_you_have_no_chats));
        }
    }

    @Subscribe
    public void onNetworkStatus(NetworkStatus networkStatus) {
        switch (networkStatus.getStatus()) {
            case 0: {
                this.setConnectionMessage(3);
                break;
            }
            case 1: 
            case 2: {
                this.setConnectionMessage(2);
                break;
            }
        }
    }

    private void setConnectionMessage(int status) {
        if (this.isNetworkAvailable()) {
            switch (status) {
                case 0: {
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            OpenChannelFragment.this.retryLayout.setVisibility(8);
                        }
                    });
                    break;
                }
                case 2: {
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            OpenChannelFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FFA500"));
                            OpenChannelFragment.this.btnRetry.setText((CharSequence)Restring.getString((Context)OpenChannelFragment.this.getActivity(), R.string.fugu_connecting));
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    OpenChannelFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#00FF00"));
                                    OpenChannelFragment.this.btnRetry.setText((CharSequence)Restring.getString((Context)OpenChannelFragment.this.getActivity(), R.string.fugu_connected));
                                    OpenChannelFragment.this.retryLayout.setVisibility(8);
                                }
                            }, 1500L);
                        }
                    });
                    break;
                }
                case 3: {
                    this.getActivity().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            OpenChannelFragment.this.retryLayout.setVisibility(0);
                            String noNet = Restring.getString((Context)OpenChannelFragment.this.getActivity(), R.string.hippo_no_internet_connected);
                            OpenChannelFragment.this.btnRetry.setText((CharSequence)noNet);
                            OpenChannelFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FF0000"));
                        }
                    });
                    break;
                }
                case 6: {
                    this.retryLayout.setVisibility(0);
                    this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FBE799"));
                    new GeneralFunctions().spannableRetryText(this.btnRetry, Restring.getString((Context)this.getActivity(), R.string.error_msg_yellow_bar), Restring.getString((Context)this.getActivity(), R.string.hippo_tap_to_retry));
                    this.retryLayout.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                }
                            }, 1000L);
                        }
                    });
                }
            }
        } else {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OpenChannelFragment.this.retryLayout.setVisibility(0);
                    String noNet = Restring.getString((Context)OpenChannelFragment.this.getActivity(), R.string.hippo_no_internet_connected);
                    OpenChannelFragment.this.btnRetry.setText((CharSequence)noNet);
                    OpenChannelFragment.this.retryLayout.setBackgroundColor(Color.parseColor((String)"#FF0000"));
                }
            });
        }
    }
}

