/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.hippo.CaptureUserData;
import com.hippo.ChatByUniqueIdAttributes;
import com.hippo.GroupingTag;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.HippoNotificationConfig;
import com.hippo.LibApp;
import com.hippo.R;
import com.hippo.activity.BaseFragment;
import com.hippo.activity.ChannelActivity;
import com.hippo.agent.adapter.PagerAdapter;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.eventbus.BusProvider;
import com.hippo.eventbus.ConversationEvent;
import com.hippo.eventbus.OnViewUpdate;
import com.hippo.fragment.OpenChannelFragment;
import com.hippo.helper.BusEvents;
import com.hippo.helper.FayeMessage;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguGetConversationsResponse;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UnreadCountModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.CustomViewPager;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.fileUpload.Prefs;
import com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import retrofit2.Callback;

public class ChannelTypeFragment
extends BaseFragment
implements FuguAppConstant,
ViewPager.OnPageChangeListener {
    private CustomViewPager viewPager;
    private TabLayout tabLayout;
    private View rootView;
    private ChannelActivity channelActivity;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private String label = "";
    private Long userId = -1L;
    private String enUserId = "";
    private String userName = "Anonymous";
    private String businessName = "Anonymous";
    private int appVersion = 0;
    private final int IS_HIT_REQUIRED = 200;
    public static boolean isRefresh = false;
    public static Long readChannelId = -1L;
    public static Long readLabelId = -1L;
    private boolean isScreenOpen = false;
    private boolean isFirstTimeOpen = true;
    private boolean isFromHistory = false;
    private Long openedChannelId = -1L;
    private PagerAdapter pagerAdapter;
    private ArrayList<Fragment> pagerFragments = new ArrayList();
    String[] titles = new String[2];
    private String title;
    private TextView tvToolbarName;
    private RelativeLayout myToolbar;
    private ImageView logout;
    private ImageView ivBackBtn;
    private LinearLayout llBtn;
    private boolean hasPager;
    private HippoColorConfig hippoColorConfig;
    private Typeface customBold;
    private Typeface customNormal;
    ArrayList<UnreadCountModel> unreadCountModels = new ArrayList();
    BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!ChannelTypeFragment.this.isScreenOpen) {
                    return;
                }
                JSONObject messageJson = new JSONObject(intent.getStringExtra("message"));
                HippoLog.d("receiver", "Got message: " + messageJson.toString());
                boolean hasChannelID = false;
                boolean hasLabelID = false;
                if (messageJson.has("notification_type") && messageJson.getInt("notification_type") == 5) {
                    ChannelTypeFragment.this.getConversations();
                } else {
                    FuguConversation currentConversation;
                    int index;
                    if (messageJson.has("channel_id") && messageJson.getLong("channel_id") > 0L && (index = ChannelTypeFragment.this.fuguConversationList.indexOf(new FuguConversation(messageJson.getLong("channel_id")))) != -1) {
                        hasChannelID = true;
                    }
                    if (messageJson.has("label_id") && messageJson.getLong("label_id") > 0L) {
                        for (int i = 0; i < ChannelTypeFragment.this.fuguConversationList.size(); ++i) {
                            currentConversation = (FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(i);
                            if (currentConversation.getLabelId().longValue() != messageJson.getLong("label_id")) continue;
                            hasLabelID = true;
                            break;
                        }
                    }
                    if (!hasChannelID && !hasLabelID) {
                        ChannelTypeFragment.this.getConversations();
                    } else if (messageJson.has("new_message") && messageJson.has("channel_id")) {
                        index = ChannelTypeFragment.this.fuguConversationList.indexOf(new FuguConversation(messageJson.getLong("channel_id")));
                        if (index > -1) {
                            currentConversation = (FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(index);
                            currentConversation.setDateTime(messageJson.getString("date_time").replace("+00:00", ".000Z"));
                            if (messageJson.has("new_message")) {
                                currentConversation.setMessage(messageJson.getString("new_message"));
                            }
                            if (HippoNotificationConfig.pushChannelId.compareTo(messageJson.getLong("channel_id")) != 0) {
                                currentConversation.setUnreadCount(currentConversation.getUnreadCount() + 1);
                            } else {
                                currentConversation.setUnreadCount(0);
                            }
                            currentConversation.setLast_sent_by_id(messageJson.getLong("last_sent_by_id"));
                            currentConversation.setLast_sent_by_full_name(messageJson.getString("last_sent_by_full_name"));
                            BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
                            ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                        } else {
                            ChannelTypeFragment.this.getConversations();
                        }
                    } else if (messageJson.has("new_message") && messageJson.has("label_id")) {
                        index = -1;
                        for (int i = 0; i < ChannelTypeFragment.this.fuguConversationList.size(); ++i) {
                            if (((FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(i)).getLabelId().compareTo(messageJson.getLong("label_id")) != 0) continue;
                            index = i;
                            break;
                        }
                        if (index > -1) {
                            FuguConversation currentConversation2 = (FuguConversation)ChannelTypeFragment.this.fuguConversationList.get(index);
                            currentConversation2.setDateTime(messageJson.getString("date_time").replace("+00:00", ".000Z"));
                            if (messageJson.has("new_message")) {
                                currentConversation2.setMessage(messageJson.getString("new_message"));
                            }
                            if (HippoNotificationConfig.pushLabelId.compareTo(messageJson.getLong("label_id")) != 0) {
                                currentConversation2.setUnreadCount(currentConversation2.getUnreadCount() + 1);
                            } else {
                                currentConversation2.setUnreadCount(0);
                            }
                            currentConversation2.setLast_sent_by_id(messageJson.getLong("last_sent_by_id"));
                            currentConversation2.setLast_sent_by_full_name(messageJson.getString("last_sent_by_full_name"));
                            BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
                            ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                        } else {
                            ChannelTypeFragment.this.getConversations();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(false);
        if (this.getArguments() != null) {
            this.title = this.getArguments().getString("title", "");
            this.isFromHistory = this.getArguments().getBoolean("from_history", false);
            this.openedChannelId = this.getArguments().getLong("channelId", -1L);
            this.appVersion = this.getArguments().getInt("appVersion", 0);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.fragment_channel_pager, container, false);
        return this.rootView;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.channelActivity = (ChannelActivity)this.getActivity();
    }

    public void onDetach() {
        super.onDetach();
        this.channelActivity = null;
    }

    public void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.mMessageReceiver, new IntentFilter("notification_received"));
        HippoConfig.getInstance().setChannelActivity(true);
        this.title = CommonData.getChatTitle();
        this.myToolbar = (RelativeLayout)view.findViewById(R.id.my_toolbar);
        this.tvToolbarName = (TextView)view.findViewById(R.id.tv_toolbar_name);
        this.logout = (ImageView)view.findViewById(R.id.logout);
        this.ivBackBtn = (ImageView)view.findViewById(R.id.ivBackBtn);
        this.llBtn = (LinearLayout)view.findViewById(R.id.llBtn);
        this.tvToolbarName.setText((CharSequence)this.title);
        this.myToolbar.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        this.tvToolbarName.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        this.ivBackBtn.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);
        this.tvToolbarName.setTextSize(20.0f);
        this.viewPager = (CustomViewPager)view.findViewById(R.id.pagerView);
        this.tabLayout = (TabLayout)view.findViewById(R.id.tabs);
        this.tabLayout.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        this.viewPager.setPagingEnabled(true);
        this.viewPager.addOnPageChangeListener(this);
        this.customBold = Typeface.createFromAsset((AssetManager)this.getActivity().getAssets(), (String)"fonts/ProximaNova-Sbold.ttf");
        this.customNormal = Typeface.createFromAsset((AssetManager)this.getActivity().getAssets(), (String)"fonts/ProximaNova-Reg.ttf");
        this.pagerFragments = new ArrayList();
        OpenChannelFragment closeFragment = new OpenChannelFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("isClosedChannel", true);
        closeFragment.setArguments(bundle);
        HippoConfigAttributes attributes = CommonData.getAttributes();
        try {
            if (attributes != null && attributes.getAdditionalInfo() != null) {
                this.hasPager = attributes.getAdditionalInfo().isHasChannelPager();
                if (attributes.getAdditionalInfo().hasLogoutBtn()) {
                    this.llBtn.setVisibility(0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pagerFragments.add(new OpenChannelFragment());
        if (this.hasPager) {
            this.pagerFragments.add(closeFragment);
            this.tabLayout.setVisibility(0);
        } else {
            this.tabLayout.setVisibility(8);
        }
        this.titles[0] = this.getString(R.string.hippo_current);
        this.titles[1] = this.getString(R.string.hippo_past);
        this.pagerAdapter = new PagerAdapter(this.getChildFragmentManager(), this.pagerFragments, this.titles);
        this.viewPager.setAdapter((androidx.viewpager.widget.PagerAdapter)this.pagerAdapter);
        this.tabLayout.setupWithViewPager((ViewPager)this.viewPager);
        this.setTabColor();
        this.decideAppFlow();
        this.logout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelTypeFragment.this.showDialog();
                try {
                    LibApp.getInstance().trackEvent("List Screen", "button clicked", "Logout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    ChannelTypeFragment.this.getActivity().onBackPressed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void setTabColor() {
        this.tabLayout.setSelectedTabIndicatorColor(CommonData.getColorConfig().getHippoSelectedTabIndicatorColor());
        this.tabLayout.setTabTextColors(CommonData.getColorConfig().getHippoTabTextColor(), CommonData.getColorConfig().getHippoTabSelectedTextColor());
        this.tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                LinearLayout tabLayout1 = (LinearLayout)((ViewGroup)ChannelTypeFragment.this.tabLayout.getChildAt(0)).getChildAt(tab.getPosition());
                TextView tabTextView = (TextView)tabLayout1.getChildAt(1);
                tabTextView.setTypeface(ChannelTypeFragment.this.customBold);
                tabTextView.setTextSize(16.0f);
            }

            public void onTabUnselected(TabLayout.Tab tab) {
                LinearLayout tabLayout1 = (LinearLayout)((ViewGroup)ChannelTypeFragment.this.tabLayout.getChildAt(0)).getChildAt(tab.getPosition());
                TextView tabTextView = (TextView)tabLayout1.getChildAt(1);
                tabTextView.setTypeface(ChannelTypeFragment.this.customNormal);
                tabTextView.setTextSize(16.0f);
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
        LinearLayout tabLayout1 = (LinearLayout)((ViewGroup)this.tabLayout.getChildAt(0)).getChildAt(1);
        TextView tabTextView = (TextView)tabLayout1.getChildAt(1);
        tabTextView.setTypeface(this.customNormal);
        tabTextView.setTextSize(16.0f);
    }

    public void onPageScrolled(int i, float v, int i1) {
    }

    public void onPageSelected(int i) {
    }

    public void onPageScrollStateChanged(int i) {
    }

    private void decideAppFlow() {
        if (CommonData.getUserDetails() != null) {
            this.setUpUI();
            this.getConversations();
        } else {
            this.sendUserDetails();
        }
    }

    private void setApiHit() {
        if (CommonData.getUserDetails() != null) {
            this.getConversations();
        } else {
            this.sendUserDetails();
        }
    }

    private void setUpUI() {
        FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
        this.label = userData.getBusinessName();
        this.businessName = userData.getBusinessName();
        this.userId = userData.getUserId();
        this.enUserId = userData.getEn_user_id();
        if (!TextUtils.isEmpty((CharSequence)userData.getFullName())) {
            this.userName = userData.getFullName();
        }
        this.fuguConversationList.clear();
        if (CommonData.getConversationList().size() > 0 && !this.isFromHistory) {
            this.fuguConversationList.addAll(CommonData.getConversationList());
        } else if (CommonData.getConversationList().size() > 0) {
            this.fuguConversationList.addAll(CommonData.getConversationList());
        }
        BusProvider.getInstance().post((Object)new OnViewUpdate(4));
    }

    private void getConversations() {
        this.getConversations(this.isFromHistory);
    }

    private void getConversations(boolean showLoader) {
        if (this.isNetworkAvailable()) {
            CommonParams.Builder builder = new CommonParams.Builder();
            builder.add("app_secret_key", HippoConfig.getInstance().getAppKey());
            builder.add("en_user_id", this.enUserId);
            builder.add("app_version", 257);
            if (this.isFromHistory) {
                builder.add("status", "[2]");
            }
            builder.add("device_type", 1);
            CommonParams commonParams = builder.build();
            RestClient.getApiInterface().getConversations(commonParams.getMap()).enqueue((Callback)new ResponseResolver<FuguGetConversationsResponse>((Activity)this.getActivity(), Boolean.valueOf(showLoader), Boolean.valueOf(false)){

                @Override
                public void success(FuguGetConversationsResponse fuguGetConversationsResponse) {
                    try {
                        ArrayList<FuguConversation> conversationList = new ArrayList<FuguConversation>();
                        conversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                        if (ChannelTypeFragment.this.isFromHistory && CommonData.getUpdatedDetails().getData().isMultiChannelLabelMapping()) {
                            for (int i = conversationList.size() - 1; i >= 0; --i) {
                                HippoLog.e("TAG", "status -> " + ((FuguConversation)conversationList.get(i)).getChannelStatus());
                                if (((FuguConversation)conversationList.get(i)).getChannelStatus() == ChannelStatus.OPEN.getOrdinal() || ChannelTypeFragment.this.openedChannelId.equals(((FuguConversation)conversationList.get(i)).getChannelId())) {
                                    conversationList.remove(i);
                                    continue;
                                }
                                try {
                                    String removeLt = ((FuguConversation)conversationList.get(i)).getMessage().replaceAll("<", "&lt;");
                                    String removeGt = removeLt.replaceAll(">", "&gt;");
                                    ((FuguConversation)conversationList.get(i)).setMessage(removeGt);
                                    continue;
                                }
                                catch (Exception e) {
                                    ((FuguConversation)conversationList.get(i)).setMessage(((FuguConversation)conversationList.get(i)).getMessage());
                                }
                            }
                        } else {
                            for (int i = 0; i < conversationList.size(); ++i) {
                                try {
                                    String removeLt = ((FuguConversation)conversationList.get(i)).getMessage().replaceAll("<", "&lt;");
                                    String removeGt = removeLt.replaceAll(">", "&gt;");
                                    ((FuguConversation)conversationList.get(i)).setMessage(removeGt);
                                    continue;
                                }
                                catch (Exception e) {
                                    ((FuguConversation)conversationList.get(i)).setMessage(((FuguConversation)conversationList.get(i)).getMessage());
                                }
                            }
                            CommonData.setConversationList(conversationList);
                        }
                        ChannelTypeFragment.this.fuguConversationList.clear();
                        ChannelTypeFragment.this.fuguConversationList.addAll(conversationList);
                        ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {
                    BusProvider.getInstance().post((Object)new OnViewUpdate(3));
                }
            });
        } else {
            BusProvider.getInstance().post((Object)new OnViewUpdate(3));
        }
    }

    private void updateCount(ArrayList<FuguConversation> fuguConversationList) {
        try {
            int count = 0;
            this.unreadCountModels.clear();
            CommonData.setUnreadCount(this.unreadCountModels);
            for (int i = 0; i < fuguConversationList.size(); ++i) {
                if (fuguConversationList.get(i).getUnreadCount() <= 0) continue;
                UnreadCountModel countModel = new UnreadCountModel(fuguConversationList.get(i).getChannelId(), fuguConversationList.get(i).getLabelId(), fuguConversationList.get(i).getUnreadCount());
                this.unreadCountModels.add(countModel);
                count += fuguConversationList.get(i).getUnreadCount();
            }
            CommonData.setUnreadCount(this.unreadCountModels);
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().count(count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createConversation() {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("New Conversation");
        ChatByUniqueIdAttributes attributes = new ChatByUniqueIdAttributes.Builder().setTransactionId("").setUserUniqueKey(HippoConfig.getInstance().getUserData().getUserUniqueKey()).setTags(tags).setInsertBotId(true).build();
        HippoConfig.getInstance().openChatByUniqueId(attributes);
    }

    public void onDestroy() {
        super.onDestroy();
        HippoConfig.getInstance().setChannelActivity(false);
        LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver(this.mMessageReceiver);
        readChannelId = null;
        readLabelId = null;
    }

    public void onResume() {
        super.onResume();
        NotificationManager nm = (NotificationManager)this.getActivity().getSystemService("notification");
        if (nm != null) {
            nm.cancelAll();
        }
        super.onResume();
        this.isScreenOpen = true;
        if (isRefresh) {
            isRefresh = false;
            try {
                for (int i = 0; i < this.fuguConversationList.size(); ++i) {
                    FuguConversation currentConversation = this.fuguConversationList.get(i);
                    if (readChannelId > -1L && currentConversation.getChannelId() > -1L && currentConversation.getChannelId().compareTo(readChannelId) == 0) {
                        currentConversation.setUnreadCount(0);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    } else {
                        if (readLabelId <= -1L || currentConversation.getLabelId() <= -1L || currentConversation.getLabelId().compareTo(readLabelId) != 0) continue;
                        currentConversation.setUnreadCount(0);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateCount(this.fuguConversationList);
        }
        if (!this.isFirstTimeOpen) {
            this.setApiHit();
        }
        this.isFirstTimeOpen = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 200 && resultCode == -1) {
            FuguConversation conversation = (FuguConversation)new Gson().fromJson(data.getStringExtra("conversation"), FuguConversation.class);
            if (conversation != null && conversation.getLabelId().compareTo(-1L) != 0) {
                for (int i = 0; i < this.fuguConversationList.size(); ++i) {
                    if (this.fuguConversationList.get(i).getLabelId().compareTo(conversation.getLabelId()) != 0) continue;
                    this.fuguConversationList.get(i).setChannelId(conversation.getChannelId());
                    this.fuguConversationList.get(i).setMessage(conversation.getDefaultMessage());
                    this.fuguConversationList.get(i).setDateTime(conversation.getDateTime());
                    this.fuguConversationList.get(i).setChannelStatus(conversation.getChannelStatus());
                    this.fuguConversationList.get(i).setIsTimeSet(1);
                    this.fuguConversationList.get(i).setLast_sent_by_id(conversation.getLast_sent_by_id());
                    this.fuguConversationList.get(i).setUserId(conversation.getLast_sent_by_id());
                    this.fuguConversationList.get(i).setEnUserId(conversation.getEnUserId());
                    this.fuguConversationList.get(i).setLast_message_status(conversation.getLast_message_status());
                    this.fuguConversationList.get(i).setChatType(conversation.getChatType());
                    BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            } else if (conversation != null && conversation.getLabelId().compareTo(-1L) == 0) {
                for (int i = 0; i < this.fuguConversationList.size(); ++i) {
                    if (this.fuguConversationList.get(i).getChannelId().compareTo(conversation.getChannelId()) != 0) continue;
                    this.fuguConversationList.get(i).setChannelId(conversation.getChannelId());
                    this.fuguConversationList.get(i).setMessage(conversation.getDefaultMessage());
                    this.fuguConversationList.get(i).setDateTime(conversation.getDateTime());
                    this.fuguConversationList.get(i).setChannelStatus(conversation.getChannelStatus());
                    this.fuguConversationList.get(i).setIsTimeSet(1);
                    this.fuguConversationList.get(i).setLast_sent_by_id(conversation.getLast_sent_by_id());
                    this.fuguConversationList.get(i).setLast_message_status(conversation.getLast_message_status());
                    this.fuguConversationList.get(i).setChatType(conversation.getChatType());
                    BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    this.updateCount(this.fuguConversationList);
                    break;
                }
            }
        }
        try {
            if (CommonData.getIsNewChat()) {
                this.getConversations();
                CommonData.setIsNewchat(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void onConversationEvent(ConversationEvent event) {
        if (event.type == 1) {
            this.onRefresh();
        } else if (event.type == 2) {
            this.createConversation();
        } else if (event.type == 3) {
            this.ivBackBtn.performClick();
        }
    }

    @Subscribe
    public void onFayeMessage(FayeMessage events) {
        if (events.type.equalsIgnoreCase(BusEvents.RECEIVED_MESSAGE.toString())) {
            try {
                Long channelId;
                JSONObject messageJson = new JSONObject(events.message);
                int notificationType = messageJson.optInt("notification_type", 0);
                if (notificationType == 13) {
                    int index;
                    String channelImageUrl = messageJson.optString("channel_image_url");
                    String label = messageJson.optString("label");
                    Long channelId2 = messageJson.optLong("channel_id", -1L);
                    if (channelId2 > 0L && (index = this.fuguConversationList.indexOf(new FuguConversation(channelId2))) != -1) {
                        this.fuguConversationList.get(index).setLabel(label);
                        this.fuguConversationList.get(index).setChannelImage(channelImageUrl);
                        BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                    }
                } else if (notificationType == 1 && events.channelId.equalsIgnoreCase("/" + CommonData.getUserDetails().getData().getUserChannel()) && (channelId = Long.valueOf(messageJson.optLong("channel_id", -1L))) > 0L) {
                    if (messageJson.optInt("channel_status", 0) == ChannelStatus.CLOSED.getOrdinal()) {
                        int index = this.fuguConversationList.indexOf(new FuguConversation(channelId));
                        if (index != -1) {
                            this.fuguConversationList.get(index).setChannelStatus(ChannelStatus.CLOSED.getOrdinal());
                            BusProvider.getInstance().post((Object)new OnViewUpdate(2, this.fuguConversationList));
                        }
                    } else {
                        this.updateCount(channelId);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateCount(Long channelId) {
        if (channelId > 0L && HippoNotificationConfig.pushChannelId != null && HippoNotificationConfig.pushChannelId.compareTo(channelId) != 0) {
            HippoConfig.getInstance().increaseCount(channelId);
        }
    }

    public void onRefresh() {
        this.getConversations(false);
    }

    private void sendUserDetails() {
        if (this.isNetworkAvailable()) {
            String deviceToken;
            Gson gson = new GsonBuilder().create();
            JsonObject deviceDetailsJson = null;
            try {
                deviceDetailsJson = gson.toJsonTree((Object)new FuguDeviceDetails(this.appVersion).getDeviceDetails()).getAsJsonObject();
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            CaptureUserData userData = null;
            if (userData == null) {
                userData = HippoConfig.getInstance().getUserData();
            }
            HashMap<String, Object> commonParams = new HashMap<String, Object>();
            HippoConfig.getInstance();
            if (HippoConfig.getmResellerToken() != null) {
                commonParams.put("reseller_token", HippoConfig.getmResellerToken());
                commonParams.put("reference_id", String.valueOf(HippoConfig.getmReferenceId()));
            } else {
                commonParams.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            }
            commonParams.put("device_id", UniqueIMEIID.getUniqueIMEIId((Context)this.getActivity()));
            commonParams.put("app_type", HippoConfig.getInstance().getAppType());
            commonParams.put("device_type", 1);
            commonParams.put("app_version", "2.5.7");
            commonParams.put("device_details", deviceDetailsJson);
            if (userData != null) {
                if (!TextUtils.isEmpty((CharSequence)userData.getUserUniqueKey()) && !userData.getUserUniqueKey().trim().isEmpty()) {
                    commonParams.put("user_unique_key", userData.getUserUniqueKey());
                }
                if (!TextUtils.isEmpty((CharSequence)userData.getFullName()) && !userData.getFullName().trim().isEmpty()) {
                    commonParams.put("full_name", userData.getFullName());
                }
                if (!TextUtils.isEmpty((CharSequence)userData.getEmail()) && !userData.getEmail().trim().isEmpty()) {
                    commonParams.put("email", userData.getEmail());
                }
                if (!TextUtils.isEmpty((CharSequence)userData.getPhoneNumber()) && !userData.getPhoneNumber().trim().isEmpty()) {
                    commonParams.put("phone_number", userData.getPhoneNumber());
                }
                if (!TextUtils.isEmpty((CharSequence)CommonData.getImagePath()) && !TextUtils.isEmpty((CharSequence)CommonData.getImagePath())) {
                    commonParams.put("user_image", CommonData.getImagePath());
                }
                if (!userData.getTags().isEmpty()) {
                    ArrayList<GroupingTag> groupingTags = new ArrayList<GroupingTag>();
                    for (GroupingTag tag : userData.getTags()) {
                        GroupingTag groupingTag = new GroupingTag();
                        if (!TextUtils.isEmpty((CharSequence)tag.getTagName())) {
                            groupingTag.setTagName(tag.getTagName());
                        }
                        if (tag.getTeamId() != null) {
                            groupingTag.setTeamId(tag.getTeamId());
                        }
                        if (TextUtils.isEmpty((CharSequence)tag.getTagName()) && tag.getTeamId() == null) continue;
                        groupingTags.add(groupingTag);
                    }
                    commonParams.put("grouping_tags", new Gson().toJson(groupingTags));
                } else {
                    commonParams.put("grouping_tags", "[]");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(deviceToken = CommonData.getAttributes().getDeviceToken()))) {
                commonParams.put("device_token", deviceToken);
            }
            if (userData != null && !userData.getCustom_attributes().isEmpty()) {
                commonParams.put("custom_attributes", new JSONObject(userData.getCustom_attributes()));
            }
            if (HippoConfig.getmResellerToken() != null) {
                this.apiPutUserDetailReseller(commonParams);
            } else {
                this.apiPutUserDetail(commonParams);
            }
        } else {
            BusProvider.getInstance().post((Object)new OnViewUpdate(1));
        }
    }

    private void apiPutUserDetail(HashMap<String, Object> commonParams) {
        CommonParams params = new CommonParams.Builder().putMap(commonParams).build();
        RestClient.getApiInterface().putUserDetails(params.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChannelTypeFragment.this.setUpUI();
                ChannelTypeFragment.this.fuguConversationList.clear();
                ChannelTypeFragment.this.fuguConversationList.addAll(fuguPutUserDetailsResponse.getData().getFuguConversations());
                ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
            }

            @Override
            public void failure(APIError error) {
                if (error.getStatusCode() == 403) {
                    Toast.makeText((Context)ChannelTypeFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                    ChannelTypeFragment.this.getActivity().finish();
                } else {
                    BusProvider.getInstance().post((Object)new OnViewUpdate(1));
                }
            }
        });
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> commonParams) {
        CommonParams params = new CommonParams.Builder().putMap(commonParams).build();
        RestClient.getApiInterface().putUserDetailsReseller(params.getMap()).enqueue((Callback)new ResponseResolver<FuguPutUserDetailsResponse>((Activity)this.getActivity(), Boolean.valueOf(true), Boolean.valueOf(false)){

            @Override
            public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                CommonData.setUserDetails(fuguPutUserDetailsResponse);
                CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                try {
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("en_user_id", fuguPutUserDetailsResponse.getData().getEn_user_id());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("user_id", fuguPutUserDetailsResponse.getData().getUserId());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("full_name", fuguPutUserDetailsResponse.getData().getFullName());
                    Prefs.with((Context)ChannelTypeFragment.this.getActivity()).save("email", fuguPutUserDetailsResponse.getData().getEmail());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChannelTypeFragment.this.setUpUI();
                ChannelTypeFragment.this.fuguConversationList.clear();
                ChannelTypeFragment.this.fuguConversationList.addAll(fuguPutUserDetailsResponse.getData().getFuguConversations());
                ChannelTypeFragment.this.updateCount(ChannelTypeFragment.this.fuguConversationList);
                BusProvider.getInstance().post((Object)new OnViewUpdate(2, ChannelTypeFragment.this.fuguConversationList));
            }

            @Override
            public void failure(APIError error) {
                if (error.getStatusCode() == 403) {
                    Toast.makeText((Context)ChannelTypeFragment.this.getActivity(), (CharSequence)error.getMessage(), (int)0).show();
                    ChannelTypeFragment.this.getActivity().finish();
                } else {
                    BusProvider.getInstance().post((Object)new OnViewUpdate(1));
                }
            }
        });
    }

    private void showDialog() {
        new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"Are you sure you want to logout?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Prefs.with((Context)ChannelTypeFragment.this.getActivity()).remove("access_token");
                Prefs.with((Context)ChannelTypeFragment.this.getActivity()).remove("user_unique_key");
                HippoConfig.clearHippoData((Activity)ChannelTypeFragment.this.getActivity());
                ChannelTypeFragment.this.getActivity().finish();
                LibApp.getInstance().openMainScreen();
                try {
                    LibApp.getInstance().trackEvent("List Screen", "Logout Button clicked", "Yes");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).setNegativeButton((CharSequence)"N0", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    LibApp.getInstance().trackEvent("List Screen", "Logout Button clicked", "No");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).setCancelable(false).show();
    }
}

