/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;
import com.hippo.utils.ColorGenerator;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.TextDrawable;
import java.util.ArrayList;

public class FuguChannelsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater inflater;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;
    private String enUserId = "";
    private HippoColorConfig hippoColorConfig;
    private Callback callback;
    private RequestOptions options;
    private Typeface customBold;
    private Typeface customNormal;

    public FuguChannelsAdapter(Activity activity, ArrayList<FuguConversation> fuguConversationList, String userName, Long userId, String businessName, Callback callback, String enUserId, boolean hasButton) {
        this.inflater = LayoutInflater.from((Context)activity.getApplicationContext());
        this.hippoColorConfig = CommonData.getColorConfig();
        this.fuguConversationList = fuguConversationList;
        this.activity = activity;
        this.userName = userName;
        this.businessName = businessName;
        this.userId = userId;
        this.callback = callback;
        this.enUserId = enUserId;
        this.customBold = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/ProximaNova-Sbold.ttf");
        this.customNormal = Typeface.createFromAsset((AssetManager)activity.getAssets(), (String)"fonts/ProximaNova-Reg.ttf");
    }

    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color2 = generator.getColor(name.trim());
        int textColor = this.hippoColorConfig.getHippoActionBarBg();
        Resources r = this.activity.getResources();
        float px = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)r.getDisplayMetrics());
        int size = (int)TypedValue.applyDimension((int)2, (float)20.0f, (DisplayMetrics)r.getDisplayMetrics());
        name = name.trim();
        char text = ' ';
        if (TextUtils.isEmpty((CharSequence)name)) {
            String bname = CommonData.getUserDetails().getData().getBusinessName();
            text = bname.trim().charAt(0);
        } else {
            text = name.trim().charAt(0);
        }
        TextDrawable drawable2 = TextDrawable.builder().beginConfig().fontSize(size).endConfig().buildRoundRect((text + "").toUpperCase(), color2, Math.round(px));
        if (this.options == null) {
            this.options = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).fitCenter()).priority(Priority.HIGH)).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(10)})).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL);
        }
        this.options.placeholder((Drawable)drawable2);
        this.options.error((Drawable)drawable2);
        return this.options;
    }

    public void updateList(ArrayList<FuguConversation> fuguConversationList) {
        this.fuguConversationList = fuguConversationList;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflater.inflate(R.layout.fugu_item_channels, parent, false);
        return new ChannelViewHolder(view);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        try {
            final ChannelViewHolder channelViewHolder = (ChannelViewHolder)holder;
            final FuguConversation currentChannelItem = this.fuguConversationList.get(position);
            channelViewHolder.tvChannelName.setText((CharSequence)currentChannelItem.getLabel());
            channelViewHolder.tvChannelName.setTextColor(this.hippoColorConfig.getHippoListTextColorPrimary());
            channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoListTextColorSecondary());
            if (currentChannelItem.getMessage_type() == 18) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)this.getMessageData(currentChannelItem)));
            } else if (TextUtils.isEmpty((CharSequence)currentChannelItem.getMessage())) {
                if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                        if (currentChannelItem.getMessage_type() == 10) {
                            channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.fugu_attachment)));
                        } else if (currentChannelItem.getMessage_type() == 11) {
                            channelViewHolder.tvMessage.setText((CharSequence)("You: " + this.activity.getString(R.string.hippo_attachment_file)));
                        } else {
                            channelViewHolder.tvMessage.setText((CharSequence)"You sent a message");
                        }
                    } else if (currentChannelItem.getMessage_type() == 10) {
                        channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.fugu_attachment)));
                    } else if (currentChannelItem.getMessage_type() == 11) {
                        channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + this.activity.getString(R.string.hippo_attachment_file)));
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)(currentChannelItem.getLast_sent_by_full_name().trim() + " sent a message"));
                    }
                }
            } else if (currentChannelItem.getMessage().contains("\n")) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)currentChannelItem.getMessage().replaceAll("\n", " ")));
                if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                    HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                    HippoLog.e("error", currentChannelItem.getUserId() + "");
                    if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                    } else {
                        channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + currentChannelItem.getMessage())));
                    }
                } else if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)currentChannelItem.getMessage()));
                }
            } else if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getLast_sent_by_full_name())) {
                HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                HippoLog.e("error", currentChannelItem.getUserId() + "");
                if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
                } else {
                    channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + currentChannelItem.getMessage())));
                }
            } else if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)("You: " + currentChannelItem.getMessage())));
            } else {
                channelViewHolder.tvMessage.setText((CharSequence)Html.fromHtml((String)currentChannelItem.getMessage()));
            }
            try {
                channelViewHolder.tvChannelName.setTypeface(this.customBold);
                channelViewHolder.tvDate.setTypeface(this.customNormal);
                channelViewHolder.tvMessage.setTypeface(this.customNormal);
                channelViewHolder.circularTvMessageCount.setTypeface(this.customNormal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelDateText());
            if (currentChannelItem.getUnreadCount() > 0) {
                channelViewHolder.circularTvMessageCount.setVisibility(0);
                channelViewHolder.circularTvMessageCount.setText((CharSequence)String.valueOf(currentChannelItem.getUnreadCount()));
            } else {
                channelViewHolder.circularTvMessageCount.setVisibility(8);
                channelViewHolder.tvMessage.setTextColor(this.hippoColorConfig.getHippoChannelReadMessage());
                channelViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChannelReadTime());
                channelViewHolder.tvMessage.setTypeface(this.customBold);
            }
            String name = currentChannelItem.getLabel().trim().substring(0, 1).toUpperCase();
            Glide.with((Activity)this.activity).asBitmap().apply((BaseRequestOptions)this.getRequestOptions(name)).load(currentChannelItem.getChannelImage()).into(channelViewHolder.ivChannelIcon);
            channelViewHolder.ivChannelIcon.setVisibility(0);
            try {
                if (currentChannelItem.getChannelId() == null || currentChannelItem.getChannelId().intValue() < 0) {
                    channelViewHolder.tvDate.setVisibility(8);
                } else {
                    channelViewHolder.tvDate.setText((CharSequence)DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(currentChannelItem.getDateTime()), true));
                    channelViewHolder.tvDate.setVisibility(0);
                }
            }
            catch (Exception e) {
                channelViewHolder.tvDate.setVisibility(8);
            }
            channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    channelViewHolder.circularTvMessageCount.setVisibility(8);
                    currentChannelItem.setUnreadCount(0);
                    FuguConversation conversation = new FuguConversation();
                    conversation.setLabel(currentChannelItem.getLabel());
                    conversation.setChannelId(currentChannelItem.getChannelId());
                    conversation.setLabelId(currentChannelItem.getLabelId());
                    conversation.setDefaultMessage(currentChannelItem.getMessage());
                    conversation.setChannelStatus(currentChannelItem.getChannelStatus());
                    conversation.setChannelImage(currentChannelItem.getChannelImage());
                    conversation.setBusinessName(FuguChannelsAdapter.this.businessName);
                    conversation.setUserId(FuguChannelsAdapter.this.userId);
                    conversation.setEnUserId(FuguChannelsAdapter.this.enUserId);
                    conversation.setOpenChat(true);
                    conversation.setUserName(FuguChannelsAdapter.this.userName);
                    conversation.setIsTimeSet(1);
                    conversation.setChatType(currentChannelItem.getChatType());
                    conversation.setStatus(currentChannelItem.getStatus());
                    conversation.setLast_sent_by_id(currentChannelItem.getLast_sent_by_id());
                    FuguChannelsAdapter.this.callback.onClick(conversation);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.fuguConversationList.size();
    }

    public void setTextSize(TextView textView, float size) {
        textView.setTextSize(2, size);
    }

    private String getMessageData(FuguConversation currentChannelItem) {
        String message = "The video call ended";
        String callType = "video";
        if (!TextUtils.isEmpty((CharSequence)currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            callType = "voice";
        }
        message = currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState() == 2 ? (currentChannelItem.getLast_sent_by_id().equals(HippoConfig.getInstance().getUserData().getUserId()) ? "Customer missed a " + callType + " call with you" : "You missed a " + callType + " call with " + currentChannelItem.getLast_sent_by_full_name()) : "The " + callType + " call ended";
        return message;
    }

    public static interface Callback {
        public void onClick(FuguConversation var1);
    }

    class footerView
    extends RecyclerView.ViewHolder {
        public footerView(View itemView) {
            super(itemView);
        }
    }

    class ChannelViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot;
        private RelativeLayout mainLayout;
        private TextView tvChannelName;
        private TextView tvMessage;
        private TextView tvDate;
        private ImageView ivChannelIcon;
        private TextView circularTvMessageCount;
        private TextView closed;

        ChannelViewHolder(View itemView) {
            super(itemView);
            this.rlRoot = (RelativeLayout)itemView.findViewById(R.id.rlRoot);
            this.tvChannelName = (TextView)itemView.findViewById(R.id.tvChannelName);
            this.tvMessage = (TextView)itemView.findViewById(R.id.tvMessage);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
            this.ivChannelIcon = (ImageView)itemView.findViewById(R.id.ivChannelIcon);
            this.circularTvMessageCount = (TextView)itemView.findViewById(R.id.circularTvMessageCount);
            this.closed = (TextView)itemView.findViewById(R.id.closed);
            this.mainLayout = (RelativeLayout)itemView.findViewById(R.id.main_layout);
            FuguChannelsAdapter.this.setTextSize(this.tvChannelName, 18.0f);
            FuguChannelsAdapter.this.setTextSize(this.tvMessage, 15.0f);
            FuguChannelsAdapter.this.setTextSize(this.tvDate, 12.0f);
            FuguChannelsAdapter.this.setTextSize(this.circularTvMessageCount, 12.0f);
        }
    }
}

