/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.LibApp;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.CustomerInitalAdapter;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.CustomerInitalListener;
import com.hippo.model.Field;
import com.hippo.model.FuguConversation;
import com.hippo.utils.HippoLog;
import com.hippo.utils.StringUtil;
import com.hippo.utils.fileUpload.Prefs;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class CustomerInitalActivity
extends FuguBaseActivity
implements FuguAppConstant,
CustomerInitalListener {
    private static final String TAG = CustomerInitalActivity.class.getSimpleName();
    private RecyclerView recyclerView;
    private CustomerInitalAdapter initalAdapter;
    private Toolbar myToolbar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_customer_inital);
        try {
            LibApp.getInstance().screenOpened("Inital Form Screen");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        String title = "";
        try {
            title = CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getPageTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        title = TextUtils.isEmpty((CharSequence)title) ? CommonData.getChatTitle() : title;
        this.setToolbar(this.myToolbar, title);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        layoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getFields());
        objects.add(CommonData.getUserDetails().getData().getCustomerInitialFormInfo().getButton());
        this.initalAdapter = new CustomerInitalAdapter(objects, this.getSupportFragmentManager(), this);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.initalAdapter);
    }

    @Override
    public void onButtonClicked(ArrayList<Object> objects) {
        String phnNumber;
        HippoLog.v(TAG, "objects >>>>>> " + new Gson().toJson(objects));
        HashMap<String, Object> objectHashMap = CommonData.getPutUserParams();
        JSONObject obj = new JSONObject();
        for (Object object : objects) {
            Field field;
            if (!(object instanceof Field) || (field = (Field)object).getType().toLowerCase().equalsIgnoreCase("LABEL")) continue;
            if (field.getType().toLowerCase().equalsIgnoreCase("contact_number")) {
                objectHashMap.put(field.getKey(), field.getCountryCode() + field.getTextValue().trim());
                continue;
            }
            if (field.isBotAttributes()) {
                try {
                    obj.put(field.getKey(), (Object)field.getTextValue().trim());
                }
                catch (Exception exception) {}
                continue;
            }
            objectHashMap.put(field.getKey(), field.getTextValue().trim());
            if (!field.getKey().equalsIgnoreCase("full_name")) continue;
            Prefs.with((Context)this).save("form_full_name", field.getTextValue().trim());
        }
        if (obj != null && obj.length() > 0) {
            objectHashMap.put("bot_attributes", obj);
        }
        if (!TextUtils.isEmpty((CharSequence)(phnNumber = Prefs.with((Context)this).getString("PHONE_NUMBER", "")))) {
            objectHashMap.put("phone_number", phnNumber);
            Prefs.with((Context)this).save("PHONE_NUMBER", "");
        }
        try {
            LibApp.getInstance().trackEvent("Form Screen", "Button clicked", "form data");
        }
        catch (Exception exception) {
            // empty catch block
        }
        new ApiPutUserDetails((Activity)this, new ApiPutUserDetails.Callback(){

            @Override
            public void onSuccess() {
                CustomerInitalActivity.this.openConversation();
            }

            @Override
            public void onFailure() {
            }
        }).updateUserData(objectHashMap);
    }

    @Override
    public void onNotifyAdapter(ArrayList<Object> objects) {
        HippoLog.v(TAG, "arrayList ******** " + new Gson().toJson(objects));
        if (this.initalAdapter != null) {
            this.initalAdapter = null;
            this.initalAdapter = new CustomerInitalAdapter(objects, this.getSupportFragmentManager(), this);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.initalAdapter);
        }
    }

    private void openConversation() {
        if (CommonData.hasDirectScreen()) {
            Intent chatIntent = new Intent((Context)this, FuguChatActivity.class);
            FuguConversation conversation = new FuguConversation();
            conversation.setLabelId(CommonData.getConstantLabelId());
            conversation.setLabel("");
            conversation.setOpenChat(true);
            conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            chatIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
            HippoConfig.getInstance().setAdditionalInfo(false, -1L);
            this.startActivity(chatIntent);
            this.finish();
        } else {
            HippoConfig.getInstance().showConversations((Activity)this, CommonData.getChatTitle());
            this.finish();
        }
    }
}

