package com.hippo.agent.fragment;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.hippo.R;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.adapter.BroadcastStatusAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.helper.BroadcastListenerHelper;
import com.hippo.agent.listeners.BroadcastListener;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.broadcastResponse.BroadcastModel;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.loadingBox.LoadingBox;

import java.util.ArrayList;

/**
 * Created by gurmail on 26/07/18.
 *
 * @author gurmail
 */

public class BroadcastStatusFragment extends BaseFragment implements SwipeRefreshLayout.OnRefreshListener,
        BroadcastListener.BroadcastResponse, OnItemClickListener {

    private static final String TAG = BroadcastStatusFragment.class.getSimpleName();
    private BroadcastStatusAdapter statusAdapter;
    private BroadcastListener broadcastListener;
    private UserData userData;
    private ArrayList<BroadCastObjectModel> broadcastInfos = new ArrayList<>();

    private SwipeRefreshLayout refreshLayout;
    private RecyclerView listView;
    private LinearLayout llNoConversation;
    private AgentBroadcastActivity activity;

    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private int offset = 0;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hippo_list_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        activity = (AgentBroadcastActivity) getActivity();
        activity.updateToolBar("Broadcast History");

        broadcastListener = new BroadcastListenerHelper();
        refreshLayout = view.findViewById(R.id.swipe_refresh);
        llNoConversation = view.findViewById(R.id.llNoConversation);
        refreshLayout.setEnabled(false);
        listView = view.findViewById(R.id.list_view);

        statusAdapter = new BroadcastStatusAdapter(listView, this);
        layoutManager = new LinearLayoutManager(getActivity());
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        listView.setLayoutManager(layoutManager);
        listView.setAdapter(statusAdapter);

        getBroadcastStatus(offset);

        listView.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (!isPagingApiInProgress && hasMorePages) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            getBroadcastStatus(broadcastInfos.size());
                        }
                    }
                }
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        broadcastListener = null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onRefresh() {
        getBroadcastStatus(0);
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden)
            activity.updateToolBar("Broadcast History");
    }

    private void getBroadcastStatus(final int offset) {
        this.offset = offset;
        if (userData == null)
            userData = AgentCommonData.getUserData();
        String accessToken = userData.getAccessToken();
        if (offset != 0) {
            isPagingApiInProgress = true;
            statusAdapter.showPaginationProgressBar(true, true);
        } else {
            LoadingBox.showOn(getActivity());
        }

        CommonParams commonParams = new CommonParams.Builder()
                .add("access_token", accessToken)
                .add("page_offset", offset)
                .build();


        broadcastListener.getBroadcastList(commonParams.getMap(), this);
    }

    @Override
    public void groupingResponse(BroadcastModel broadcastModel) {

    }

    @Override
    public void sendBroadcastResponse(BroadcastResponseModel responseModel) {

    }

    @Override
    public void broadcastListResponse(BroadcastResponseModel responseModel) {
        LoadingBox.hide();
        if (offset != 0) {
            isPagingApiInProgress = false;
            statusAdapter.showPaginationProgressBar(false, true);
        } else {
            if (responseModel.getData() == null || responseModel.getData().getBroadcastedChannels() == null || responseModel.getData().getBroadcastedChannels().size() == 0) {
                llNoConversation.setVisibility(View.VISIBLE);
            } else {
                llNoConversation.setVisibility(View.GONE);
            }
        }

        if (broadcastInfos == null)
            broadcastInfos = new ArrayList<>();

        if (offset == 0)
            broadcastInfos.clear();

        broadcastInfos.addAll(responseModel.getData().getBroadcastedChannels());

        statusAdapter.setData(broadcastInfos);
        hasMorePages = responseModel.getData().getBroadcastedChannels().size() == responseModel.getData().getPageSize();


    }

    @Override
    public void broadcastStatusResponse(BroadcastResponseModel responseModel) {

    }

    @Override
    public void onFailure(int type, String errorMessage) {
        Toast.makeText(getActivity(), errorMessage, Toast.LENGTH_SHORT).show();
        LoadingBox.hide();
        switch (type) {
            case 1:

                break;
            default:

                break;
        }
    }

    @Override
    public void onClickItem(int position) {
        try {
            BroadcastDetailsFragment detailsFragment = new BroadcastDetailsFragment();
            Bundle bundle = new Bundle();
            BroadCastObjectModel broadcastInfo = broadcastInfos.get(position);
            bundle.putSerializable("objectModel", broadcastInfo);
            detailsFragment.setArguments(bundle);

            getActivity().getSupportFragmentManager().beginTransaction()
                    .add(R.id.main_layout, detailsFragment, BroadcastDetailsFragment.class.getName())
                    .addToBackStack(BroadcastDetailsFragment.class.getName())
                    .hide(getActivity().getSupportFragmentManager().findFragmentByTag(getActivity().getSupportFragmentManager()
                            .getBackStackEntryAt(getActivity().getSupportFragmentManager().getBackStackEntryCount() - 1).getName()))
                    .commitAllowingStateLoss();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
