/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguAttachmentModel;
import java.util.ArrayList;

public class FuguAttachmentAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant {
    private LayoutInflater inflater;
    private ArrayList<FuguAttachmentModel> attachmentList = new ArrayList();
    private Context context;
    private OnAttachListener mOnAttach;
    private boolean showDocs;
    private boolean isOneToOne;
    private boolean showEmpty;

    public FuguAttachmentAdapter(Context context, boolean showDocs, boolean isOneToOne) {
        this.inflater = LayoutInflater.from((Context)context);
        this.showDocs = showDocs;
        this.isOneToOne = isOneToOne;
        this.context = context;
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_camera, context.getResources().getString(R.string.fugu_camera), 514, R.drawable.hippo_ring_white, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery, context.getResources().getString(R.string.fugu_gallery), 515, R.drawable.hippo_ring_blue, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_video, "Video", 519, R.drawable.hippo_ring_orange, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_music, context.getResources().getString(R.string.fugu_audio), 518, R.drawable.hippo_ring_red, true));
        this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_gallery_file, context.getResources().getString(R.string.fugu_document), 516, R.drawable.hippo_ring_purple, true));
        if (isOneToOne) {
            this.attachmentList.add(new FuguAttachmentModel(R.drawable.hippo_ic_payment, context.getResources().getString(R.string.fugu_payment), 520, R.drawable.hippo_ring_blue, true));
        }
    }

    public void setOnAttachListener(OnAttachListener OnAttachListener2) {
        this.mOnAttach = OnAttachListener2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.inflater.inflate(R.layout.fugu_item_dialog_attach, parent, false);
        AttachmentViewHolder holder = new AttachmentViewHolder(view);
        return holder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        AttachmentViewHolder attachmentViewHolder = (AttachmentViewHolder)holder;
        final FuguAttachmentModel currentAttachmentItem = this.attachmentList.get(position);
        attachmentViewHolder.tvAttachmentType.setText((CharSequence)currentAttachmentItem.getText());
        if (position == 0) {
            attachmentViewHolder.ivImageBig.setImageResource(currentAttachmentItem.getImageIcon());
            attachmentViewHolder.llImageBg.setVisibility(8);
            attachmentViewHolder.ivImageBig.setVisibility(0);
        } else {
            attachmentViewHolder.ivImage.setImageResource(currentAttachmentItem.getImageIcon());
            attachmentViewHolder.llImageBg.setVisibility(0);
            attachmentViewHolder.ivImageBig.setVisibility(8);
        }
        attachmentViewHolder.llImageBg.setBackgroundResource(currentAttachmentItem.getColor());
        attachmentViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FuguAttachmentAdapter.this.mOnAttach != null) {
                    FuguAttachmentAdapter.this.mOnAttach.onAttach(currentAttachmentItem.getAction());
                }
            }
        });
        switch (position) {
            case 0: 
            case 3: {
                ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)holder.itemView, (String)"scaleX", (float[])new float[]{0.5f, 1.05f, 1.0f});
                anim2.setDuration(500L);
                anim2.start();
                ObjectAnimator anim22 = ObjectAnimator.ofFloat((Object)holder.itemView, (String)"scaleY", (float[])new float[]{0.5f, 1.05f, 1.0f});
                anim22.setDuration(500L);
                anim22.start();
                break;
            }
            case 1: 
            case 4: {
                ObjectAnimator anim3 = ObjectAnimator.ofFloat((Object)holder.itemView, (String)"scaleX", (float[])new float[]{0.5f, 1.05f, 1.0f});
                anim3.setDuration(600L);
                anim3.start();
                ObjectAnimator anim4 = ObjectAnimator.ofFloat((Object)holder.itemView, (String)"scaleY", (float[])new float[]{0.5f, 1.05f, 1.0f});
                anim4.setDuration(600L);
                anim4.start();
                break;
            }
            case 2: 
            case 5: {
                ObjectAnimator anim5 = ObjectAnimator.ofFloat((Object)holder.itemView, (String)"scaleX", (float[])new float[]{0.5f, 1.05f, 1.0f});
                anim5.setDuration(700L);
                anim5.start();
                ObjectAnimator anim6 = ObjectAnimator.ofFloat((Object)holder.itemView, (String)"scaleY", (float[])new float[]{0.5f, 1.05f, 1.0f});
                anim6.setDuration(700L);
                anim6.start();
            }
        }
    }

    public int getItemCount() {
        return this.attachmentList.size();
    }

    class AttachmentViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvAttachmentType;
        private ImageView ivImage;
        private ImageView ivImageBig;
        private LinearLayout llImageBg;

        public AttachmentViewHolder(View itemView) {
            super(itemView);
            this.tvAttachmentType = (TextView)itemView.findViewById(R.id.tvAttachmentType);
            this.ivImage = (ImageView)itemView.findViewById(R.id.ivImage);
            this.ivImageBig = (ImageView)itemView.findViewById(R.id.ivImageBig);
            this.llImageBg = (LinearLayout)itemView.findViewById(R.id.llImageBg);
        }
    }

    public static interface OnAttachListener {
        public void onAttach(int var1);
    }
}

