/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AlertDialog;

class RationaleDialogConfig {
    private static final String KEY_POSITIVE_BUTTON = "positiveButton";
    private static final String KEY_NEGATIVE_BUTTON = "negativeButton";
    private static final String KEY_RATIONALE_MESSAGE = "rationaleMsg";
    private static final String KEY_THEME = "theme";
    private static final String KEY_REQUEST_CODE = "requestCode";
    private static final String KEY_PERMISSIONS = "permissions";
    String positiveButton;
    String negativeButton;
    int theme;
    int requestCode;
    String rationaleMsg;
    String[] permissions;

    RationaleDialogConfig(@NonNull String positiveButton, @NonNull String negativeButton, @NonNull String rationaleMsg, @StyleRes int theme, int requestCode, @NonNull String[] permissions) {
        this.positiveButton = positiveButton;
        this.negativeButton = negativeButton;
        this.rationaleMsg = rationaleMsg;
        this.theme = theme;
        this.requestCode = requestCode;
        this.permissions = permissions;
    }

    RationaleDialogConfig(Bundle bundle) {
        this.positiveButton = bundle.getString(KEY_POSITIVE_BUTTON);
        this.negativeButton = bundle.getString(KEY_NEGATIVE_BUTTON);
        this.rationaleMsg = bundle.getString(KEY_RATIONALE_MESSAGE);
        this.theme = bundle.getInt(KEY_THEME);
        this.requestCode = bundle.getInt(KEY_REQUEST_CODE);
        this.permissions = bundle.getStringArray(KEY_PERMISSIONS);
    }

    Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_POSITIVE_BUTTON, this.positiveButton);
        bundle.putString(KEY_NEGATIVE_BUTTON, this.negativeButton);
        bundle.putString(KEY_RATIONALE_MESSAGE, this.rationaleMsg);
        bundle.putInt(KEY_THEME, this.theme);
        bundle.putInt(KEY_REQUEST_CODE, this.requestCode);
        bundle.putStringArray(KEY_PERMISSIONS, this.permissions);
        return bundle;
    }

    AlertDialog createSupportDialog(Context context, DialogInterface.OnClickListener listener) {
        AlertDialog.Builder builder = this.theme > 0 ? new AlertDialog.Builder(context, this.theme) : new AlertDialog.Builder(context);
        return builder.setCancelable(false).setPositiveButton((CharSequence)this.positiveButton, listener).setNegativeButton((CharSequence)this.negativeButton, listener).setMessage((CharSequence)this.rationaleMsg).create();
    }

    android.app.AlertDialog createFrameworkDialog(Context context, DialogInterface.OnClickListener listener) {
        AlertDialog.Builder builder = this.theme > 0 ? new AlertDialog.Builder(context, this.theme) : new AlertDialog.Builder(context);
        return builder.setCancelable(false).setPositiveButton((CharSequence)this.positiveButton, listener).setNegativeButton((CharSequence)this.negativeButton, listener).setMessage((CharSequence)this.rationaleMsg).create();
    }
}

