/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.retrofit;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.hippo.utils.HippoLog;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class RetrofitUtils {
    public static RequestBody getRequestBodyFromString(String value) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)value);
        return body;
    }

    public static MultipartBody.Part getPartBodyFromFile(String key, File file) {
        if (file == null) {
            return null;
        }
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)RetrofitUtils.getMimeType(file)), (File)file);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)key, (String)file.getName(), (RequestBody)requestFile);
        return body;
    }

    public static String getMimeType(File file) {
        String mimeType = "image/png";
        try {
            Uri selectedUri = Uri.fromFile((File)file);
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)selectedUri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension);
        }
        catch (Exception e) {
            HippoLog.e("mime type exception ", e.toString());
        }
        return mimeType;
    }
}

