package com.hippo.fragment;

import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.gson.Gson;
import com.hippo.*;
import com.hippo.activity.BaseFragment;
import com.hippo.adapter.CampaignAdapter;
import com.hippo.apis.ApiGetMobileNotification;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.OnClearNotificationListener;
import com.hippo.interfaces.OnItemClickListener;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.promotional.Data;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.swipetoshow.SwipeHolder;
import com.hippo.utils.swipetoshow.SwipeOnItemTouchAdapter;

import org.json.JSONObject;
import org.json.JSONTokener;

import java.util.ArrayList;

/**
 * Created by gurmail on 2020-01-10.
 *
 * @author gurmail
 */
public class CampaignFragment extends BaseFragment implements OnItemClickListener, SwipeRefreshLayout.OnRefreshListener {

    private static final String TAG = CampaignFragment.class.getSimpleName();
    private View rootView;
    private TextView tvToolbarName;
    private RelativeLayout myToolbar;
    private TextView delete;

    private SwipeRefreshLayout refreshLayout;
    private RecyclerView recyclerView;
    private CampaignAdapter campaignAdapter;
    private MobileCampaignBuilder campaignBuilder;
    private int startOffset = 0;
    private int offset = 19;
    private int endOffset;
    private ArrayList<Data> arrayList = new ArrayList<>();
    private LinearLayoutManager layoutManager;
    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private TextView titleError;
    private ImageView ivBackBtn;
    private LinearLayout llNoNotifications;


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.hippo_campaigns_layout,  container, false);
        return rootView;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        campaignBuilder = HippoConfig.getInstance().getMobileCampaignBuilder();

        refreshLayout = view.findViewById(R.id.swipe_refresh);
        titleError = view.findViewById(R.id.title_error);
        recyclerView = view.findViewById(R.id.recyclerView);
        endOffset = startOffset + offset;

        refreshLayout.setOnRefreshListener(this);
        refreshLayout.setColorSchemeResources(R.color.hippo_white);
        refreshLayout.setProgressBackgroundColorSchemeResource(R.color.fugu_theme_color_primary);
        refreshLayout.setSize(SwipeRefreshLayout.DEFAULT);

        llNoNotifications = view.findViewById(R.id.llNoNotifications);

        myToolbar = view.findViewById(R.id.my_toolbar);
        tvToolbarName = view.findViewById(R.id.tv_toolbar_name);
        String title = "Notifications";
        String errorTxt = "No Notifications";
        if(campaignBuilder != null && !TextUtils.isEmpty(campaignBuilder.getNotificationTitle()))
            title = campaignBuilder.getNotificationTitle();

        if(campaignBuilder != null && !TextUtils.isEmpty(campaignBuilder.getEmptyNotificationText()))
            errorTxt = campaignBuilder.getEmptyNotificationText();

        tvToolbarName.setText(title);
        myToolbar.setBackgroundColor(CommonData.getColorConfig().getHippoActionBarBg());
        tvToolbarName.setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        titleError.setText(errorTxt);
        delete = view.findViewById(R.id.deleteTxt);

        layoutManager = new LinearLayoutManager(getContext());
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);
        campaignAdapter = new CampaignAdapter(getActivity(), null, recyclerView, this);
        recyclerView.setAdapter(campaignAdapter);

        ivBackBtn = view.findViewById(R.id.ivBackBtn);
        ivBackBtn.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);
        //delete.getDrawable().setColorFilter(CommonData.getColorConfig().getHippoActionBarText(), PorterDuff.Mode.SRC_ATOP);

        refreshLayout.setRefreshing(true);

        setTextSize(tvToolbarName, 20);
        setTextSize(delete, 13.4f);
        setTextSize(titleError, 18);

        //fetchData();
        getSavedData();

        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (!isPagingApiInProgress && hasMorePages) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            startOffset = endOffset+1;
                            endOffset = startOffset +offset;
                            fetchData();
                        }
                    }
                }
            }
        });

        recyclerView.addOnItemTouchListener(new SwipeOnItemTouchAdapter(getActivity(), recyclerView, layoutManager) {
            @Override
            public void onItemHiddenClick(SwipeHolder swipeHolder, int position) {
                clearData(arrayList.get(position).getChannelId(), position);
                //call reset to hide.
                swipeHolder.reset();
            }

            @Override
            public void onItemClick(int position) {

            }
        });

        delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clearData(-1, -1);
//                deleteAll();
            }
        });

        ivBackBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    getActivity().onBackPressed();
                } catch (Exception e) {
                }
            }
        });
    }

    HippoConfigAttributes attributes;

    private HippoConfigAttributes getAttributes() {
        if(attributes == null)
            attributes = CommonData.getAttributes();
        return attributes;
    }

    public void setTextSize(TextView textView, float size) {
        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, size);
    }

    @Override
    public void onRefresh() {
        if(isNetworkAvailable()) {
            startOffset = 0;
            endOffset = startOffset + offset;
            fetchData();
        } else {
            refreshLayout.setRefreshing(false);
        }
    }

    public static JSONObject objectToJSONObject(Object object){
        Object json = null;
        JSONObject jsonObject = null;
        try {
            json = new JSONTokener(object.toString()).nextValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (json instanceof JSONObject) {
            jsonObject = (JSONObject) json;
        }
        return jsonObject;
    }

    @Override
    public void onClickListener(int position) {
        try {
            if(campaignBuilder != null && campaignBuilder.getListener() != null) {
                String data = new Gson().toJson(arrayList.get(position).getCustomAttributes());
                campaignBuilder.getListener().onItemClickListener(data);
            }
        } catch (Exception e) {

        }

        try {
            if(arrayList.get(position).getCustomAttributes() != null && !TextUtils.isEmpty(arrayList.get(position).getCustomAttributes().getDeeplink()) &&
                    arrayList.get(position).getCustomAttributes().getDeeplink().equals("3x67AU1") && CommonData.getAttributes().getDeepLinks() != null) {
                DeeplinKData deeplinKData = CommonData.getAttributes().getDeepLinks().get(arrayList.get(position).getCustomAttributes().getDeeplink());
                if(deeplinKData != null && !TextUtils.isEmpty(deeplinKData.getPakageName()) && !TextUtils.isEmpty(deeplinKData.getClassFullPath())) {

                    FuguPutUserDetailsResponse.Data userData = CommonData.getUserDetails().getData();
                    //String label = userData.getBusinessName();
                    String businessName = userData.getBusinessName();
                    long userId = userData.getUserId();
                    String enUserId = userData.getEn_user_id();

                    FuguConversation conversation = new FuguConversation();
                    conversation.setLabel(arrayList.get(position).getTitle());
                    conversation.setLabelId((long) arrayList.get(position).getChannelId());
                    conversation.setDefaultMessage("");
                    conversation.setBusinessName(businessName);
                    conversation.setUserId(userId);
                    conversation.setEnUserId(enUserId);
                    conversation.setOpenChat(true);
                    conversation.setUserName(userData.getFullName());
                    conversation.setIsTimeSet(1);
                    conversation.setChatType(0);
                    conversation.setStatus(1);

                    int skipBot = 0;
                    try {
                        JSONObject jsonObject = objectToJSONObject(arrayList.get(position).getCustomAttributes().getData());
                        if(jsonObject.optInt("skip_bot", 0) == 1) {
                            skipBot = 1;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }


                    Intent notificationIntent = new Intent();
                    if(skipBot == 1) {
                        notificationIntent.putExtra("is_skip_bot", 1);
                    }
                    notificationIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
                    String packageName = deeplinKData.getPakageName();
                    String className = deeplinKData.getClassFullPath();
                    notificationIntent.setComponent(new ComponentName(packageName, className));
                    startActivity(notificationIntent);

                    if(campaignBuilder != null) {
                        if(campaignBuilder.isCloseActivityOnClick()) {
                            getActivity().finish();
                        } else if(campaignBuilder.isCloseOnlyDeepLink() && !TextUtils.isEmpty(arrayList.get(position).getCustomAttributes().getDeeplink())) {
                            getActivity().finish();
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onLoadMore() {

    }

    private void getSavedData() {
        PromotionResponse response = CommonData.getPromotionResponse();
        fetchData();
        if(response != null && response.getData() != null && response.getData().size() > 0) {
            arrayList = new ArrayList<>();
            arrayList.addAll(response.getData());
            if(campaignAdapter != null) {
                campaignAdapter.setData(arrayList);
            }
        }
    }

    private void fetchData() {
        if(isNetworkAvailable()) {
            if(startOffset != 0) {
                isPagingApiInProgress= true;
                campaignAdapter.showPaginationProgressBar(true, true);
            }
            new ApiGetMobileNotification(getActivity(), new NotificationListener() {
                @Override
                public void onSucessListener(PromotionResponse response) {
                    try {

                        if (arrayList == null)
                            arrayList = new ArrayList<>();

                        if (startOffset == 0) {
                            arrayList.clear();
                            CommonData.savePromotionResponse(response);
                        }

                        if (startOffset != 0) {
                            isPagingApiInProgress = false;
                            campaignAdapter.showPaginationProgressBar(false, true);
                        }

                        arrayList.addAll(response.getData());

                        if (arrayList.size() == 0) {
                            llNoNotifications.setVisibility(View.VISIBLE);
                            delete.setVisibility(View.GONE);
                        } else {
                            llNoNotifications.setVisibility(View.GONE);
                            delete.setVisibility(View.VISIBLE);
                        }

                        if(campaignAdapter != null) {
                            campaignAdapter.setData(arrayList);
                        }
                        refreshLayout.setRefreshing(false);
                        hasMorePages = response.getData().size() == offset;

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailureListener() {
                    refreshLayout.setRefreshing(false);
                    if (startOffset != 0) {
                        isPagingApiInProgress = false;
                        campaignAdapter.showPaginationProgressBar(false, true);
                    }
                    if (arrayList.size() == 0) {
                        llNoNotifications.setVisibility(View.VISIBLE);

                    } else {
                        llNoNotifications.setVisibility(View.GONE);
                    }
                }

                @Override
                public void onItemClickListener(String url) {

                }
            }).getNotificationData(startOffset, endOffset);
        } else {
            ToastUtil.getInstance(getActivity()).showToast(R.string.fugu_not_connected_to_internet);
            refreshLayout.setRefreshing(false);
            if (startOffset != 0) {
                isPagingApiInProgress = false;
                campaignAdapter.showPaginationProgressBar(false, true);
            }
        }
    }

    private void deleteAll() {
        new AlertDialog.Builder(getActivity())
                .setMessage("Are you sure you want to clear all notifications?")
                .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        clearData(-1, -1);
                    }
                })
                .setNegativeButton("No", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .create().show();
    }

    public void clearData(final long channelId, int position) {
        if(isNetworkAvailable()) {
            new ApiGetMobileNotification(getActivity(), new OnClearNotificationListener() {
                @Override
                public void onSucessListener(int position) {
                    if(position>-1) {
                        campaignAdapter.notifyItemRemoved(position);
                        arrayList.remove(position);
                        ToastUtil.getInstance(getActivity()).showToast("Notification deleted");
                    } else {
                        arrayList.clear();
                        campaignAdapter.notifyDataSetChanged();
                    }
                    if(arrayList.size() == 0) {
                        delete.setVisibility(View.GONE);
                        llNoNotifications.setVisibility(View.VISIBLE);
                    }
                }

                @Override
                public void onFailure() {

                }
            }).clearNotification(channelId, position);
        } else {
            ToastUtil.getInstance(getActivity()).showToast(R.string.fugu_not_connected_to_internet);
        }
    }
}
