package com.hippo.agent.adapter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.broadcastStatus.BroadcastUser;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;

import java.util.ArrayList;

/**
 * Created by gurmail on 13/02/19.
 *
 * @author gurmail
 */
public class BroadcastDetailAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = BroadcastDetailAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadcastUser> arrayList = new ArrayList<>();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private HippoColorConfig hippoColorConfig;

    public BroadcastDetailAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadcastUser> arrayList) {
        this.arrayList = arrayList;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        context = parent.getContext();
        hippoColorConfig = CommonData.getColorConfig();
        if (viewType == VIEW_TYPE_LOADING) {
            return new BroadcastDetailAdapter.LoadMoreHolder(LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.hippo_layout_loaddata, parent, false));
        } else {
            return new BroadcastDetailAdapter.ViewHolder(LayoutInflater.from(context)
                    .inflate(R.layout.hippo_layout_broadcast_item_detail, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof BroadcastDetailAdapter.ViewHolder) {
            BroadcastDetailAdapter.ViewHolder viewHolder = (BroadcastDetailAdapter.ViewHolder) holder;
            BroadcastUser objectModel = arrayList.get(position);
            viewHolder.tvTitle.setText(objectModel.getFullName());

            if (!TextUtils.isEmpty(objectModel.getLastActivity())) {
                String localDate = DateUtils.getInstance().convertToLocal(objectModel.getLastActivity(), STANDARD_DATE_FORMAT_TZ, OUTPUT_FORMAT);
                viewHolder.tvStatus.setText("Read at " + localDate);
            } else {
                viewHolder.tvStatus.setText("Delivered");
            }

            if (!TextUtils.isEmpty(objectModel.getRepliedOn())) {
                viewHolder.chatIcon.setVisibility(View.VISIBLE);
            } else {
                viewHolder.chatIcon.setVisibility(View.GONE);
            }

        }
    }


    @Override
    public int getItemCount() {
        return arrayList == null ? 0 : arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        try {
            if (arrayList.get(position).getUserId().equals(-1)) {
                return VIEW_TYPE_LOADING;
            } else {
                return VIEW_TYPE;
            }
        } catch (Exception e) {
            return VIEW_TYPE;
        }
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        private RelativeLayout llLayout, chatIcon;
        private TextView tvTitle;
        private TextView tvStatus;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llLayout = itemView.findViewById(R.id.ll_layout);
            chatIcon = itemView.findViewById(R.id.chat_icon);

            tvTitle = itemView.findViewById(R.id.tvTitle);
            tvStatus = itemView.findViewById(R.id.tvStatus);

            tvTitle.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            tvStatus.setTextColor(hippoColorConfig.getHippoTextColorSecondary());


            llLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (onItemClickListener != null)
                        onItemClickListener.onClickItem(getAdapterPosition());
                }
            });
        }
    }

    public class LoadMoreHolder extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
//            loadmoreBinding = DataBindingUtil.bind(itemView);
        }
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        if (arrayList == null || arrayList.size() == 0)
            return;

        boolean isProgressBarExist = arrayList.get(arrayList.size() - 1).getUserId() != null
                && arrayList.get(arrayList.size() - 1).getUserId().intValue() == -1;
        if (show) {
            if (!isProgressBarExist) {
                arrayList.add(BroadcastDetailAdapter.ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    recyclerView.post(getProgressDisplayRunnable(true, arrayList.size()));
                }
            }
        } else {
            if (arrayList.remove(BroadcastDetailAdapter.ProgressBarModel.getInstance())) {
                if (notifyAdapter) {
                    recyclerView.post(getProgressDisplayRunnable(false, arrayList.size()));
                }
            }

        }

    }

    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (progressBarDisplayRunnable == null) {
            progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        progressBarDisplayRunnable.setInsert(isInsert);
        progressBarDisplayRunnable.setPosition(position);

        return progressBarDisplayRunnable;
    }


    private static class ProgressBarModel {
        private static BroadcastUser progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadcastUser getInstance() {
            if (progressBarModel == null)
                progressBarModel = new BroadcastUser(-1);
            return progressBarModel;
        }
    }

}

