package com.hippo.activity;

import android.graphics.Bitmap;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.gson.Gson;
import com.hippo.BuildConfig;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.eventbus.BusProvider;
import com.hippo.fragment.PaymentCancelDialog;
import com.hippo.helper.BusEvents;
import com.hippo.helper.FayeMessage;
import com.hippo.model.MakePayment;
import com.hippo.model.PaymentResponse;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.model.payment.PaymentListResponse;
import com.hippo.model.payment.PrePaymentData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.squareup.otto.Subscribe;

import org.json.JSONObject;

import faye.ConnectionManager;

import static android.webkit.WebSettings.MIXED_CONTENT_ALWAYS_ALLOW;
import static com.hippo.payment.PaymentConstants.PaymentValue.RAZORPAY;

/**
 * Created by gurmail on 2020-06-16.
 *
 * @author gurmail
 */
public class PrePaymentActivity extends FuguBaseActivity {

    private RelativeLayout rootToolbar;
    private ImageView ivBackBtn;
    private TextView tvToolbarName;
    private RelativeLayout loadingLayout;
    private ProgressWheel progressWheel;
    private TextView textView;

    private ProgressBar pbWebPageLoader;
    private WebView webView;

    private HippoColorConfig hippoColorConfig;
    private FuguChatActivity chatActivity;
    private PrePaymentData paymentData;

    public interface OnInputListener {
        void closeFragment();
    }

    public OnInputListener onInputListener;
    private AddedPaymentGateway paymentGateway;
    String url = "";
    private String channelId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pre_webview);

        String data = getIntent().getStringExtra("data");
        paymentData = new Gson().fromJson(data, PrePaymentData.class);
        for(AddedPaymentGateway gateway : CommonData.getPaymentList()) {
            if(gateway.getGatewayId() == paymentData.getPayment_gateway_id()) {
                paymentGateway = gateway;
                break;
            }
        }

        HippoLog.e("URL", "URL = "+url);

        String title = "Payment";

        rootToolbar = findViewById(R.id.my_toolbar);
        tvToolbarName = findViewById(R.id.tv_toolbar_name);
        ivBackBtn = findViewById(R.id.ivBackBtn);
        loadingLayout = findViewById(R.id.loadingLayout);
        progressWheel = findViewById(R.id.circle_progress);
        textView = findViewById(R.id.text);

        hippoColorConfig = CommonData.getColorConfig();
        rootToolbar.setBackgroundColor(hippoColorConfig.getHippoActionBarBg());
        tvToolbarName.setTextColor(hippoColorConfig.getHippoActionBarText());
        tvToolbarName.setText(title);

        pbWebPageLoader = findViewById(R.id.pbWebPageLoader);
        webView = findViewById(R.id.webView);

        setWebViewProperties(webView);

        try {
            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
        } catch (Exception e) {
            e.printStackTrace();
        }

        ivBackBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showDialog();
            }
        });

        webView.setWebViewClient(new MyWebViewClient());

        if(!TextUtils.isEmpty(url)) {
            handleLayout(1);
            webView.loadUrl(url);
        } else {
            handleLayout(0);
            getChannelData();
        }

    }

    @Override
    protected void onStart() {
        super.onStart();
        BusProvider.getInstance().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(!TextUtils.isEmpty(channelId))
            ConnectionManager.INSTANCE.unsubScribeChannel(channelId);
    }

    @Override
    public void onBackPressed() {
        showDialog();
    }

    private void handleLayout(int value) {
        if(value == 0) {
            loadingLayout.setVisibility(View.VISIBLE);
            webView.setVisibility(View.GONE);
        } else if(value == 2) {
            progressWheel.setVisibility(View.GONE);
            textView.setText("Something went wrong! \n Please try again");
        } else {
            loadingLayout.setVisibility(View.GONE);
            webView.setVisibility(View.VISIBLE);
        }
    }

    private void setWebViewProperties(final WebView webView) {
        webView.setWebViewClient(new MyWebViewClient());
        webView.setWebChromeClient(new WebChromeClient());
        webView.getSettings().setLoadsImagesAutomatically(true);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webView.getSettings().setMixedContentMode(MIXED_CONTENT_ALWAYS_ALLOW);
        }


        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);

        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowContentAccess(true);

        webView.getSettings().setLightTouchEnabled(true);

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
                WebView newView = new WebView(PrePaymentActivity.this);
                newView.setLayoutParams(new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
                if (paymentGateway.getGatewayId() == RAZORPAY.intValue)
                    webView.addView(newView);

                if (paymentGateway.getGatewayId() == RAZORPAY.intValue)
                    setWebViewProperties(newView); //Dialog update on same screen
                else setWebViewProperties(webView); //Dialog update on different screen

                WebView.WebViewTransport transport = (WebView.WebViewTransport) resultMsg.obj;
                transport.setWebView(newView);
                resultMsg.sendToTarget();
                return true;
            }

            @Override
            public void onCloseWindow(WebView window) {
                HippoLog.e("onCloseWindow", window + "");
                webView.removeView(window);
                super.onCloseWindow(window);
            }

            @Override
            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                HippoLog.e("URL onJsAlert", url + "");

                return super.onJsAlert(view, url, message, result);
            }
        });

    }

    private class MyWebViewClient extends WebViewClient {
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return onOverrideUrlLoading(view, request.getUrl().toString());
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return onOverrideUrlLoading(view, url);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            //ProgressDialog.show(mActivity);
            super.onPageStarted(view, url, favicon);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            try {
                if (pbWebPageLoader != null)
                    pbWebPageLoader.setVisibility(View.INVISIBLE);
            } catch (Exception e) {

            }
            super.onPageFinished(view, url);
        }
    }


    private boolean onOverrideUrlLoading(WebView view, String url) {

        /*UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(url);
        String transactionId = "", jobPaymentDetailId = "";


        if (paymentGateway.getGatewayId() == RAZORPAY.intValue) {
            transactionId = sanitizer.getValue("rzp_payment_id");

        } else if (paymentGateway.getGatewayId() == BILLPLZ.intValue) {
            transactionId = sanitizer.getValue("billplz[id]");
        } else if (paymentGateway.getGatewayId() == PAYFORT.intValue) {
            transactionId = sanitizer.getValue("transactionId");
            jobPaymentDetailId = sanitizer.getValue("job_payment_detail_id");
        } else {
            *//* paymentMethod == PAYFAST || FAC || INSTAPAY || PAYPAL || PAYMOB  returns transactionId*//*

            if (sanitizer.getValue("transactionId") != null) {
                transactionId = sanitizer.getValue("transactionId");
            } else {
                transactionId = sanitizer.getValue("transaction_id");
            }
        }*/

        try {
            if (url.startsWith("http:") || url.startsWith("https:")) {
                view.loadUrl(url);
                if(url.contains("success") || url.contains("Success")) {
                    if(HippoConfig.getInstance().getPrePaymentCallBack() != null) {
                        HippoConfig.getInstance().getPrePaymentCallBack().onPaymentSuccess();
                    }
                    onfinishActivity();
                } else if(url.contains("error.html")) {
                    if(HippoConfig.getInstance().getPrePaymentCallBack() != null) {
                        HippoConfig.getInstance().getPrePaymentCallBack().onPaymentfailed();
                    }
                    onfinishActivity();
                }
            }
        } catch (Exception e) {

        }


        return true;
    }

    private void getChannelData() {
        RestClient.getApiInterface().getPrePaymentMethod(paymentData).enqueue(new ResponseResolver<PaymentListResponse>(this, false, true) {
            @Override
            public void success(PaymentListResponse paymentListResponse) {
                channelId = "/"+paymentListResponse.getData().getChannelId();
                subscribeChannels(channelId);
                if(!TextUtils.isEmpty(paymentListResponse.getData().getPaymentUrl().getPaymentUrl())) {
                    handleLayout(1);
                    webView.loadUrl(paymentListResponse.getData().getPaymentUrl().getPaymentUrl());
                } else {
                    handleLayout(2);
                }
            }

            @Override
            public void failure(APIError error) {

            }
        });
    }

    private void createPaymentLink(MakePayment makePayment) {
        if (chatActivity.isNetworkAvailable()) {

            makePayment.setPayment_gateway_id(paymentGateway.getGatewayId());
            makePayment.setIs_multi_gateway_flow(1);
            makePayment.setDevice_details(CommonData.deviceDetailString(this));
            makePayment.setApp_version(BuildConfig.VERSION_CODE);
            makePayment.setDevice_id(UniqueIMEIID.getUniqueIMEIId(this));
            makePayment.setSource_type(1);
            makePayment.setDevice_type(ANDROID_USER);


            RestClient.getApiInterface().createPaymentLink(makePayment)
                    .enqueue(new ResponseResolver<PaymentResponse>(this, false, true) {
                        @Override
                        public void success(PaymentResponse response) {
                            if(!TextUtils.isEmpty(response.getData().getPaymentUrl())) {
                                handleLayout(1);
                                webView.loadUrl(response.getData().getPaymentUrl());
                            } else {
                                handleLayout(2);
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            handleLayout(2);
                        }
                    });
        } else {
            Toast.makeText(this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
    }

    private void subscribeChannels(String channel) {
        ConnectionManager.INSTANCE.subScribeChannel(channel);
    }

    @Subscribe
    public void onFayeMessage(FayeMessage events) {
        if (events.type.equalsIgnoreCase(BusEvents.CONNECTED_SERVER.toString())) {
            //onConnectedServer();
        } else if (events.type.equalsIgnoreCase(BusEvents.RECEIVED_MESSAGE.toString())) {
            handleResponse(events.message, events.channelId);
        } else if (events.type.equalsIgnoreCase(BusEvents.PONG_RECEIVED.toString())) {
            //onPongReceived();
        } else if (events.type.equalsIgnoreCase(BusEvents.DISCONNECTED_SERVER.toString())) {

        } else if (events.type.equalsIgnoreCase(BusEvents.ERROR_RECEIVED.toString())) {
            //onErrorReceived(events.message, events.channelId);
        } else if (events.type.equalsIgnoreCase(BusEvents.WEBSOCKET_ERROR.toString())) {
            //onWebSocketError();
        } else if (events.type.equalsIgnoreCase(BusEvents.NOT_CONNECTED.toString())) {
            // TODO: 2020-04-27 show error in faye connection.
        }
    }

    private void handleResponse(String message, String msgChannelId) {
        if(!TextUtils.isEmpty(msgChannelId) && !TextUtils.isEmpty(channelId) && msgChannelId.equalsIgnoreCase(channelId)) {
            try {
                JSONObject object = new JSONObject(message);
                if(object.optInt("message_type") == 22) {
                    if(object.has("custom_action") && object.optJSONObject("custom_action").optInt("selected_id") == 1) {
                        if(HippoConfig.getInstance().getPrePaymentCallBack() != null) {
                            HippoConfig.getInstance().getPrePaymentCallBack().onPaymentSuccess();
                        }
                        onfinishActivity();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showDialog() {
        PaymentCancelDialog bottomSheetFragment = PaymentCancelDialog.newInstance();
        bottomSheetFragment.show(getSupportFragmentManager(), bottomSheetFragment.getTag());
    }

    public void cancelPayment() {
        finish();
    }

    boolean btnClicked;
    private synchronized void onfinishActivity() {
        if(!btnClicked) {
            btnClicked = true;
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    finish();
                }
            }, 2500);
        }
    }
}
