/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.logicImplView;

import android.app.Activity;
import com.hippo.support.Utils.CommonSupportParam;
import com.hippo.support.callback.HippoSupportDetailInter;
import com.hippo.support.callback.SupportDetailPresenter;
import com.hippo.support.callback.SupportDetailView;
import com.hippo.support.model.callbackModel.OpenChatParams;
import com.hippo.support.model.callbackModel.SendQueryChat;

public class HippoSupportDetailView
implements SupportDetailPresenter,
HippoSupportDetailInter.OnFinishedListener {
    private Activity activity;
    private SupportDetailView supportData;
    private HippoSupportDetailInter hippoSupportDetailInter;

    public HippoSupportDetailView(Activity activity, SupportDetailView supportData, HippoSupportDetailInter hippoSupportDetailInter) {
        this.activity = activity;
        this.supportData = supportData;
        this.hippoSupportDetailInter = hippoSupportDetailInter;
    }

    @Override
    public void sendQuery(SendQueryChat queryChat) {
        switch (queryChat.getType()) {
            case QUERY: {
                this.hippoSupportDetailInter.getSupportData(this.activity, queryChat, this);
                break;
            }
            case CHAT: {
                OpenChatParams chatParams = new CommonSupportParam().getOpenChatParam(queryChat.getCategory().getCategoryName(), queryChat.getTransactionId(), queryChat.getUserUniqueId(), queryChat.getSupportId(), queryChat.getPathList(), queryChat.getSubHeader());
                if (this.supportData == null) break;
                this.supportData.openChat(chatParams);
                break;
            }
        }
    }

    @Override
    public void onDestroy() {
        if (this.supportData != null) {
            this.supportData = null;
        }
    }

    @Override
    public void onSuccess() {
        if (this.supportData != null) {
            this.supportData.sucessfull();
        }
    }

    @Override
    public void onFailure() {
        if (this.supportData != null) {
            this.supportData.showError();
        }
    }
}

