/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.Util.ProgressBarDisplayRunnable;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;
import java.util.ArrayList;

public class BroadcastStatusAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = BroadcastStatusAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadCastObjectModel> arrayList = new ArrayList();
    private static final int VIEW_TYPE = 1;
    private static final int VIEW_TYPE_LOADING = 2;
    private RecyclerView recyclerView;
    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm aa";
    private OnItemClickListener onItemClickListener;
    private HippoColorConfig hippoColorConfig;
    private ProgressBarDisplayRunnable progressBarDisplayRunnable;

    public BroadcastStatusAdapter(RecyclerView recyclerView, OnItemClickListener onItemClickListener) {
        this.recyclerView = recyclerView;
        this.onItemClickListener = onItemClickListener;
    }

    public void setData(ArrayList<BroadCastObjectModel> arrayList) {
        this.arrayList = arrayList;
        this.notifyDataSetChanged();
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        this.hippoColorConfig = CommonData.getColorConfig();
        if (viewType == 2) {
            return new LoadMoreHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hippo_layout_loaddata, parent, false));
        }
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_broadcast_status, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ViewHolder) {
            ViewHolder viewHolder = (ViewHolder)holder;
            BroadCastObjectModel objectModel = this.arrayList.get(position);
            viewHolder.textViewFromValue.setText((CharSequence)objectModel.getFullName());
            String localDate = DateUtils.getInstance().convertToLocal(objectModel.getCreatedAt(), this.STANDARD_DATE_FORMAT_TZ, this.OUTPUT_FORMAT);
            viewHolder.textViewDateValue.setText((CharSequence)localDate);
            viewHolder.textViewTitleValue.setText((CharSequence)objectModel.getBroadcastTitle());
            Utils.setColor(this.context, viewHolder.textViewMsgValue, objectModel.getMessage());
            if (!TextUtils.isEmpty((CharSequence)objectModel.getFallbackText())) {
                viewHolder.textViewFallbackValue.setText((CharSequence)objectModel.getFallbackText());
                viewHolder.rlFallback.setVisibility(0);
            } else {
                viewHolder.rlFallback.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)objectModel.getBroadcastType())) {
                viewHolder.layoutType.setVisibility(0);
                if (objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                    viewHolder.textViewTypeValue.setText((CharSequence)"Email");
                } else {
                    viewHolder.textViewTypeValue.setText((CharSequence)"In App");
                }
            } else {
                viewHolder.layoutType.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.arrayList == null ? 0 : this.arrayList.size();
    }

    public int getItemViewType(int position) {
        try {
            if (this.arrayList.get(position).getChannelId().equals(-1)) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void applyThemeToDrawable(int color2, ImageView imageView) {
        Resources.Theme theme = this.context.getResources().newTheme();
        Drawable drawable2 = ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.hippo_ic_arrow, (Resources.Theme)theme);
        if (drawable2 != null) {
            PorterDuffColorFilter porterDuffColorFilter = new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
            drawable2.setColorFilter((ColorFilter)porterDuffColorFilter);
        }
        imageView.setImageDrawable(drawable2);
    }

    public void showPaginationProgressBar(boolean show, boolean notifyAdapter) {
        boolean isProgressBarExist;
        if (this.arrayList == null || this.arrayList.size() == 0) {
            return;
        }
        boolean bl = isProgressBarExist = this.arrayList.get(this.arrayList.size() - 1).getChannelId() != null && this.arrayList.get(this.arrayList.size() - 1).getChannelId() == -1;
        if (show) {
            if (!isProgressBarExist) {
                this.arrayList.add(ProgressBarModel.getInstance());
                if (notifyAdapter) {
                    this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(true, this.arrayList.size()));
                }
            }
        } else if (this.arrayList.remove(ProgressBarModel.getInstance()) && notifyAdapter) {
            this.recyclerView.post((Runnable)this.getProgressDisplayRunnable(false, this.arrayList.size()));
        }
    }

    private ProgressBarDisplayRunnable getProgressDisplayRunnable(boolean isInsert, int position) {
        if (this.progressBarDisplayRunnable == null) {
            this.progressBarDisplayRunnable = new ProgressBarDisplayRunnable(this);
        }
        this.progressBarDisplayRunnable.setInsert(isInsert);
        this.progressBarDisplayRunnable.setPosition(position);
        return this.progressBarDisplayRunnable;
    }

    private static class ProgressBarModel {
        private static BroadCastObjectModel progressBarModel;

        private ProgressBarModel() {
        }

        public static BroadCastObjectModel getInstance() {
            if (progressBarModel == null) {
                progressBarModel = new BroadCastObjectModel(-1);
            }
            return progressBarModel;
        }
    }

    public class LoadMoreHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreHolder(View itemView) {
            super(itemView);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView arrow;
        private RelativeLayout relative;
        private RelativeLayout rlFallback;
        private RelativeLayout layoutType;
        private TextView textViewFrom;
        private TextView textViewDate;
        private TextView textViewTitle;
        private TextView textViewMsg;
        private TextView textViewFallback;
        private TextView textViewType;
        private TextView textViewFromValue;
        private TextView textViewDateValue;
        private TextView textViewTitleValue;
        private TextView textViewMsgValue;
        private TextView textViewFallbackValue;
        private TextView textViewTypeValue;

        public ViewHolder(View itemView) {
            super(itemView);
            this.arrow = (ImageView)itemView.findViewById(R.id.arrow);
            this.relative = (RelativeLayout)itemView.findViewById(R.id.relative);
            this.rlFallback = (RelativeLayout)itemView.findViewById(R.id.rlFallback);
            this.layoutType = (RelativeLayout)itemView.findViewById(R.id.layoutType);
            this.textViewFrom = (TextView)itemView.findViewById(R.id.textViewFrom);
            this.textViewDate = (TextView)itemView.findViewById(R.id.textViewDate);
            this.textViewTitle = (TextView)itemView.findViewById(R.id.textViewTitle);
            this.textViewMsg = (TextView)itemView.findViewById(R.id.textViewMsg);
            this.textViewFallback = (TextView)itemView.findViewById(R.id.textViewFallback);
            this.textViewType = (TextView)itemView.findViewById(R.id.textViewType);
            this.textViewFromValue = (TextView)itemView.findViewById(R.id.textViewFromValue);
            this.textViewDateValue = (TextView)itemView.findViewById(R.id.textViewDateValue);
            this.textViewTitleValue = (TextView)itemView.findViewById(R.id.textViewTitleValue);
            this.textViewMsgValue = (TextView)itemView.findViewById(R.id.textViewMsgValue);
            this.textViewFallbackValue = (TextView)itemView.findViewById(R.id.textViewFallbackValue);
            this.textViewTypeValue = (TextView)itemView.findViewById(R.id.textViewTypeValue);
            this.textViewFrom.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewDate.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewTitle.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewMsg.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewFallback.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewType.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorSecondary());
            this.textViewFromValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewDateValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewTitleValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewMsgValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewFallbackValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            this.textViewTypeValue.setTextColor(BroadcastStatusAdapter.this.hippoColorConfig.getHippoTextColorPrimary());
            BroadcastStatusAdapter.this.applyThemeToDrawable(BroadcastStatusAdapter.this.hippoColorConfig.getHippoThemeColorPrimary(), this.arrow);
            this.relative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BroadcastStatusAdapter.this.onItemClickListener != null) {
                        BroadcastStatusAdapter.this.onItemClickListener.onClickItem(ViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

