package com.hippo.utils;

import android.app.Activity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.hippo.BuildConfig;
import com.hippo.HippoConfig;
import com.hippo.UnreadCountFor;
import com.hippo.database.CommonData;
import com.hippo.model.*;
import com.hippo.retrofit.*;

import java.util.ArrayList;

import static com.hippo.constant.FuguAppConstant.*;

/**
 * Created by gurmail on 06/06/18.
 *
 * @author gurmail
 */

public class UnreadCountApi {

    private ArrayList<FuguConversation> fuguConversationList = new ArrayList<>();

    public UnreadCountApi() {

    }

    /**
     * Get conversations api hit
     */
    public void getConversations(Activity activity, String enUserId, final CountUnread countUnread) {
        {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                    .add(EN_USER_ID, enUserId)
                    .add(APP_VERSION, BuildConfig.VERSION_CODE)
                    .add(DEVICE_TYPE, 1)
                    .build();
            RestClient.getApiInterface().getConversations(commonParams.getMap())
                    .enqueue(new ResponseResolver<FuguGetConversationsResponse>(activity, false, false) {
                        @Override
                        public void success(FuguGetConversationsResponse fuguGetConversationsResponse) {
                            try {
                                CommonData.setConversationList(fuguGetConversationsResponse.getData().getFuguConversationList());
                                int count = 0;
                                fuguConversationList.clear();
                                fuguConversationList.addAll(fuguGetConversationsResponse.getData().getFuguConversationList());
                                for (int i = 0; i < fuguConversationList.size(); i++) {
                                    count = count + fuguConversationList.get(i).getUnreadCount();
                                }
                                countUnread.countValue(count);
                                updateCount(fuguConversationList);


                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void failure(APIError error) {

                        }
                    });
        }
    }

    public interface CountUnread {
        void countValue(int count);
    }

    private ArrayList<UnreadCountModel> unreadCountModels = new ArrayList<>();
    private void updateCount(ArrayList<FuguConversation> fuguConversationList) {
        try {
            int count = 0;
            unreadCountModels.clear();
            CommonData.setUnreadCount(unreadCountModels);
            for(int i=0;i<fuguConversationList.size();i++) {
                if(fuguConversationList.get(i).getUnreadCount()>0) {
                    UnreadCountModel countModel = new UnreadCountModel(fuguConversationList.get(i).getChannelId(),
                            fuguConversationList.get(i).getLabelId(), fuguConversationList.get(i).getUnreadCount());
                    unreadCountModels.add(countModel);
                    count = count + fuguConversationList.get(i).getUnreadCount();
                }
            }

            CommonData.setUnreadCount(unreadCountModels);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getChannelUnreadCount(Activity activity, String enUserId, String transactionId, String userUniqueKey,
                                      ArrayList<String> otherUserUniqueKeys, final UnreadCountFor countUnread) {

        CommonParams commonParams = new CommonParams.Builder()
                .add(APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                .add(EN_USER_ID, enUserId)
                .add(USER_UNIQUE_KEY, userUniqueKey)
                .add(OTHER_USER_UNIQUE_KEY, otherUserUniqueKeys)
                .add("transaction_id", transactionId)
                .add(APP_VERSION, BuildConfig.VERSION_CODE)
                .add(DEVICE_TYPE, 1)
        .build();

        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;

        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }

        HippoUnreadCountParams params = new HippoUnreadCountParams(HippoConfig.getInstance().getAppKey(),
                transactionId, userUniqueKey, otherUsersArray, enUserId);


        RestClient.getApiInterface().fetchUnreadCountFor(params)
           .enqueue(new ResponseResolver<UnreadCountResponse>(activity, false, true) {
           @Override
           public void success(UnreadCountResponse response) {
              try {
                  int count = response.getData().getUnreadCount();
                  Long channelId = response.getData().getChannelId();
                  if(channelId != null) {
                      HippoConfig.getInstance().unreadCountFor(channelId, count);
                  } else {
                      countUnread.unreadCountFor(count);
                  }
              } catch (Exception e) {
                  e.printStackTrace();
              }
           }
           @Override
           public void failure(APIError error) {

              }
        });

    }
}
