package com.hippo.agent.helper;

import com.hippo.HippoConfig;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.AgentServerListener;
import com.hippo.agent.listeners.ConversationListerner;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by gurmail on 18/06/18.
 *
 * @author gurmail
 */

public class ConversationListHelper implements ConversationListerner {

    @Override
    public void getAgentConversation(HashMap<String, Object> params, final boolean isPagination, final int fragmentType, final int endPage) {
        CommonParams commonParams = new CommonParams.Builder()
                .addAll(params)
                .build(2);
        RestClient.getAgentApiInterface().getConversation(commonParams.getMap()).enqueue(new ResponseResolver<GetConversationResponse>() {
            @Override
            public void success(GetConversationResponse getConversationResponse) {
                for(AgentServerListener listener : HippoConfig.getInstance().getUIListeners(AgentServerListener.class))
                    listener.conversationList(getConversationResponse, isPagination, fragmentType, endPage);
            }

            @Override
            public void failure(APIError error) {
                for(AgentServerListener listener : HippoConfig.getInstance().getUIListeners(AgentServerListener.class))
                    listener.onError(error, fragmentType);
            }
        });
    }

    @Override
    public void getOfflineData(int fragmentType) {
        ArrayList<Object> conversationList = AgentCommonData.getAgentConversationList(fragmentType);
        for(AgentServerListener listener : HippoConfig.getInstance().getUIListeners(AgentServerListener.class))
            listener.offlineConversationList(fragmentType, conversationList);
    }

}
