package com.hippo.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Html;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.model.FuguConversation;
import com.hippo.utils.*;

import java.util.ArrayList;

import static com.hippo.constant.FuguAppConstant.*;

/**
 * Created by Bhavya Rattan on 08/05/17
 * Click Labs
 * bhavya.rattan@click-labs.com
 */

public class FuguChannelsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater inflater;
    private ArrayList<FuguConversation> fuguConversationList = new ArrayList<>();
    private Activity activity;
    private String userName;
    private String businessName;
    private Long userId = -1L;
    private String enUserId = "";
    private HippoColorConfig hippoColorConfig;
    private Callback callback;
    private RequestOptions options;
    private Typeface customBold, customNormal;

    public FuguChannelsAdapter(Activity activity, ArrayList<FuguConversation> fuguConversationList,
                               String userName, Long userId, String businessName, Callback callback, String enUserId, boolean hasButton) {
        inflater = LayoutInflater.from(activity.getApplicationContext());

        hippoColorConfig = CommonData.getColorConfig();
        this.fuguConversationList = fuguConversationList;
        this.activity = activity;
        this.userName = userName;
        this.businessName = businessName;
        this.userId = userId;
        this.callback = callback;
        this.enUserId = enUserId;
        customBold = Typeface.createFromAsset(activity.getAssets(),  "fonts/ProximaNova-Sbold.ttf");
        customNormal = Typeface.createFromAsset(activity.getAssets(),  "fonts/ProximaNova-Reg.ttf");
    }

    private RequestOptions getRequestOptions(String name) {
        ColorGenerator generator = ColorGenerator.MATERIAL;
        int color = generator.getColor(name.trim());
        int textColor = hippoColorConfig.getHippoActionBarBg();
        Resources r = activity.getResources();
        float px = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 4, r.getDisplayMetrics());

        name = name.trim();
        char text = ' ';

        if(TextUtils.isEmpty(name)) {
            String bname = CommonData.getUserDetails().getData().getBusinessName();
            text = bname.trim().charAt(0);
        } else {
            text = name.trim().charAt(0);
        }

        TextDrawable drawable = TextDrawable.builder()
                .buildRoundRect((text + "").toUpperCase(), color, Math.round(px));
        if (options == null) {
            options = new RequestOptions()
                    .centerCrop()
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transform(new CenterCrop(), new RoundedCorners(10))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL);
            /*options = new RequestOptions()
                    .circleCrop()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL);*/
        }


        options.placeholder(drawable);
        options.error(drawable);
        return options;
    }

    public void updateList(ArrayList<FuguConversation> fuguConversationList) {
        this.fuguConversationList = fuguConversationList;
        notifyDataSetChanged();
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = inflater.inflate(R.layout.fugu_item_channels, parent, false);
        return new ChannelViewHolder(view);
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        try {
            final ChannelViewHolder channelViewHolder = (ChannelViewHolder) holder;
            final FuguConversation currentChannelItem = fuguConversationList.get(position);

            channelViewHolder.tvChannelName.setText(currentChannelItem.getLabel());
            channelViewHolder.tvChannelName.setTextColor(hippoColorConfig.getHippoListTextColorPrimary());
            channelViewHolder.tvMessage.setTextColor(hippoColorConfig.getHippoListTextColorSecondary());
            if(currentChannelItem.getMessage_type() == VIDEO_CALL) {
                channelViewHolder.tvMessage.setText(Html.fromHtml(getMessageData(currentChannelItem)));
            } else if (TextUtils.isEmpty(currentChannelItem.getMessage())) {
                if (!TextUtils.isEmpty(currentChannelItem.getLast_sent_by_full_name())) {
                    {
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                            if (currentChannelItem.getMessage_type() == IMAGE_MESSAGE) {
                                channelViewHolder.tvMessage.setText("You: " + activity.getString(R.string.fugu_attachment));
                            } else if(currentChannelItem.getMessage_type() == FILE_MESSAGE) {
                                channelViewHolder.tvMessage.setText("You: " + activity.getString(R.string.hippo_attachment_file));
                            } else {
                                channelViewHolder.tvMessage.setText("You sent a message");
                            }
                        } else {
                            if (currentChannelItem.getMessage_type() == IMAGE_MESSAGE) {
                                channelViewHolder.tvMessage.setText(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + activity.getString(R.string.fugu_attachment));
                            } else if(currentChannelItem.getMessage_type() == FILE_MESSAGE) {
                                channelViewHolder.tvMessage.setText(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + activity.getString(R.string.hippo_attachment_file));
                            } else {
                                channelViewHolder.tvMessage.setText(currentChannelItem.getLast_sent_by_full_name().trim() + " " + "sent a message");
                            }
                        }
                    }
                }
            } else {
                if (currentChannelItem.getMessage().contains("\n")) {
                    channelViewHolder.tvMessage.setText(Html.fromHtml(currentChannelItem.getMessage().replaceAll("\n", " ")));
                    if (!TextUtils.isEmpty(currentChannelItem.getLast_sent_by_full_name())) {
                        HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                        HippoLog.e("error", currentChannelItem.getUserId() + "");
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                            channelViewHolder.tvMessage.setText(Html.fromHtml("You: " + currentChannelItem.getMessage()));
                        } else {
                            channelViewHolder.tvMessage.setText(Html.fromHtml(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + currentChannelItem.getMessage()));
                        }
                    } else {
                        if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                            channelViewHolder.tvMessage.setText(Html.fromHtml("You: " + currentChannelItem.getMessage()));
                        } else {
                            channelViewHolder.tvMessage.setText(Html.fromHtml(currentChannelItem.getMessage()));
                        }
                    }
                } else {
                    if (!TextUtils.isEmpty(currentChannelItem.getLast_sent_by_full_name())) {
                        HippoLog.e("error", HippoConfig.getInstance().getUserData().getUserId() + "");
                        HippoLog.e("error", currentChannelItem.getUserId() + "");
                        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(currentChannelItem.getLast_sent_by_id()) == 0) {
                            channelViewHolder.tvMessage.setText(Html.fromHtml("You: " + currentChannelItem.getMessage()));
                        } else {
                            channelViewHolder.tvMessage.setText(Html.fromHtml(currentChannelItem.getLast_sent_by_full_name().trim() + ": " + currentChannelItem.getMessage()));
                        }
                    } else {
                        if (currentChannelItem.getUserId().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                            channelViewHolder.tvMessage.setText(Html.fromHtml("You: " + currentChannelItem.getMessage()));
                        } else {
                            channelViewHolder.tvMessage.setText(Html.fromHtml(currentChannelItem.getMessage()));
                        }
                    }
                }
            }


            try {
                channelViewHolder.tvChannelName.setTypeface(customBold);
                channelViewHolder.tvDate.setTypeface(customNormal);
                //channelViewHolder.closed.setTypeface(customBold);
                channelViewHolder.tvMessage.setTypeface(customNormal);
                channelViewHolder.circularTvMessageCount.setTypeface(customNormal);
            } catch (Exception e) {
                e.printStackTrace();
            }

            channelViewHolder.tvDate.setTextColor(hippoColorConfig.getHippoChannelDateText());

            if (currentChannelItem.getUnreadCount() > 0) {
                channelViewHolder.circularTvMessageCount.setVisibility(View.VISIBLE);
                channelViewHolder.circularTvMessageCount.setText(String.valueOf(currentChannelItem.getUnreadCount()));
                //channelViewHolder.tvDate.setTypeface(customBold);
            } else {
                channelViewHolder.circularTvMessageCount.setVisibility(View.GONE);
                channelViewHolder.tvMessage.setTextColor(hippoColorConfig.getHippoChannelReadMessage());
                channelViewHolder.tvDate.setTextColor(hippoColorConfig.getHippoChannelReadTime());
                channelViewHolder.tvMessage.setTypeface(customBold);
            }

            String name = currentChannelItem.getLabel().trim().substring(0, 1).toUpperCase();
            Glide.with(activity).asBitmap()
                    .apply(getRequestOptions(name))
                    .load(currentChannelItem.getChannelImage())
                    .into(channelViewHolder.ivChannelIcon);

            channelViewHolder.ivChannelIcon.setVisibility(View.VISIBLE);

            try {
                if (currentChannelItem.getChannelId() == null || currentChannelItem.getChannelId().intValue() < 0) {
                    channelViewHolder.tvDate.setVisibility(View.GONE);
                } else {
                    channelViewHolder.tvDate.setText(DateUtils.getRelativeDate(DateUtils.getInstance().convertToLocal(currentChannelItem.getDateTime()), true));
                    channelViewHolder.tvDate.setVisibility(View.VISIBLE);
                }
            } catch (Exception e) {
                channelViewHolder.tvDate.setVisibility(View.GONE);
            }

            channelViewHolder.rlRoot.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    channelViewHolder.circularTvMessageCount.setVisibility(View.GONE);
                    currentChannelItem.setUnreadCount(0);

                    FuguConversation conversation = new FuguConversation();
                    conversation.setLabel(currentChannelItem.getLabel());
                    conversation.setChannelId(currentChannelItem.getChannelId());
                    conversation.setLabelId(currentChannelItem.getLabelId());
                    conversation.setDefaultMessage(currentChannelItem.getMessage());
                    conversation.setChannelStatus(currentChannelItem.getChannelStatus());
                    conversation.setChannelImage(currentChannelItem.getChannelImage());
                    conversation.setBusinessName(businessName);
                    conversation.setUserId(userId);
                    conversation.setEnUserId(enUserId);
                    conversation.setOpenChat(true);
                    conversation.setUserName(userName);
                    conversation.setIsTimeSet(1);
                    conversation.setChatType(currentChannelItem.getChatType());
                    conversation.setStatus(currentChannelItem.getStatus());
                    conversation.setLast_sent_by_id(currentChannelItem.getLast_sent_by_id());
                    callback.onClick(conversation);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    @Override
    public int getItemCount() {
        return fuguConversationList.size();
    }

    class ChannelViewHolder extends RecyclerView.ViewHolder {
        private RelativeLayout rlRoot, mainLayout;
        private TextView tvChannelName, tvMessage, tvDate;
        private ImageView ivChannelIcon;
        private TextView circularTvMessageCount;
        private TextView closed;


        ChannelViewHolder(View itemView) {
            super(itemView);
            rlRoot = itemView.findViewById(R.id.rlRoot);
            tvChannelName = itemView.findViewById(R.id.tvChannelName);
            tvMessage = itemView.findViewById(R.id.tvMessage);
            tvDate = itemView.findViewById(R.id.tvDate);
            ivChannelIcon = itemView.findViewById(R.id.ivChannelIcon);
            circularTvMessageCount = itemView.findViewById(R.id.circularTvMessageCount);
            closed = itemView.findViewById(R.id.closed);
            mainLayout = itemView.findViewById(R.id.main_layout);
        }
    }

    class footerView  extends RecyclerView.ViewHolder {

        public footerView(@NonNull View itemView) {
            super(itemView);
        }
    }

    public interface Callback {
        void onClick(FuguConversation conversation);
    }

    private String getMessageData(FuguConversation currentChannelItem) {
        String message = "The video call ended";
        String callType = "video";
        if(!TextUtils.isEmpty(currentChannelItem.getCallType()) && currentChannelItem.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
            callType = "voice";
        }
        if(currentChannelItem.getMessageState() != null && currentChannelItem.getMessageState().intValue() == 2) {
            if (currentChannelItem.getLast_sent_by_id().equals(HippoConfig.getInstance().getUserData().getUserId())) {
                message = "Customer missed a " + callType + " call with you";
            } else {
                message = "You missed a " + callType + " call with "+currentChannelItem.getLast_sent_by_full_name();
            }
        } else {
            message = "The " + callType + " call ended";
        }

        return message;
    }


}

