/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.adapter.OnPaymentListener;
import com.hippo.model.HippoPayment;
import com.hippo.model.Message;
import com.hippo.utils.HippoLog;
import java.util.ArrayList;

public class PaymentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnPaymentListener listener;
    private ArrayList<HippoPayment> hippoPayments;
    private Message message;
    private HippoColorConfig hippoColorConfig;
    private String selectedId;
    private int position;

    public PaymentAdapter(Message message, ArrayList<HippoPayment> hippoPayments, OnPaymentListener listener, HippoColorConfig hippoColorConfig, String selectedId, int position) {
        this.listener = listener;
        this.message = message;
        this.hippoPayments = hippoPayments;
        this.hippoColorConfig = hippoColorConfig;
        this.selectedId = selectedId;
        this.position = position;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hippo_customer_payment_item, viewGroup, false));
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        viewHolder.line.setVisibility(0);
        if (this.hippoPayments.size() == 1) {
            viewHolder.radioBtn.setVisibility(8);
        } else {
            viewHolder.radioBtn.setVisibility(0);
        }
        viewHolder.title.setText((CharSequence)this.hippoPayments.get(i).getTitle());
        if (!TextUtils.isEmpty((CharSequence)this.hippoPayments.get(i).getDescription())) {
            viewHolder.description.setVisibility(0);
            viewHolder.description.setText((CharSequence)this.hippoPayments.get(i).getDescription());
        } else {
            viewHolder.description.setVisibility(8);
        }
        String symbols = this.hippoPayments.get(i).getCurrencySymbol();
        viewHolder.amount.setText((CharSequence)(symbols + "" + this.hippoPayments.get(i).getAmount()));
        viewHolder.radioBtn.setChecked(this.hippoPayments.get(i).isSelected());
        viewHolder.title.setTextColor(this.hippoColorConfig.getHippoPaymentTitle());
        viewHolder.description.setTextColor(this.hippoColorConfig.getHippoPaymentDescription());
        viewHolder.amount.setTextColor(this.hippoColorConfig.getHippoPaymentAmount());
        viewHolder.paymentLayout.setBackgroundColor(this.hippoColorConfig.getHippoPaymentBg());
        if (!TextUtils.isEmpty((CharSequence)this.selectedId) && this.hippoPayments.get(i).getId().equalsIgnoreCase(this.selectedId)) {
            viewHolder.paid.setVisibility(0);
            viewHolder.paid.setTextColor(this.hippoColorConfig.getHippoPaymentTitle());
        }
    }

    public int getItemCount() {
        return this.hippoPayments.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView title;
        private TextView description;
        private TextView amount;
        private View line;
        private RelativeLayout paymentLayout;
        private RadioButton radioBtn;
        private TextView paid;

        public ViewHolder(View itemView) {
            super(itemView);
            this.paymentLayout = (RelativeLayout)itemView.findViewById(R.id.paymentLayout);
            this.title = (TextView)itemView.findViewById(R.id.title);
            this.description = (TextView)itemView.findViewById(R.id.description);
            this.amount = (TextView)itemView.findViewById(R.id.amount);
            this.line = itemView.findViewById(R.id.line);
            this.radioBtn = (RadioButton)itemView.findViewById(R.id.radioBtn);
            this.paid = (TextView)itemView.findViewById(R.id.paid);
            this.radioBtn.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (buttonView.isPressed()) {
                        ViewHolder.this.paymentLayout.performClick();
                    }
                }
            });
            this.paymentLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int pos = ViewHolder.this.getAdapterPosition();
                    if (!((HippoPayment)PaymentAdapter.this.hippoPayments.get(pos)).isSelected()) {
                        for (int i = 0; i < PaymentAdapter.this.hippoPayments.size(); ++i) {
                            if (i == pos) {
                                ((HippoPayment)PaymentAdapter.this.hippoPayments.get(i)).setSelected(true);
                                try {
                                    if (PaymentAdapter.this.listener == null) continue;
                                    PaymentAdapter.this.listener.onPaymentViewClicked(PaymentAdapter.this.message, (HippoPayment)PaymentAdapter.this.hippoPayments.get(i), i, ((HippoPayment)PaymentAdapter.this.hippoPayments.get(i)).getPaymentUrl(), PaymentAdapter.this.position);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            ((HippoPayment)PaymentAdapter.this.hippoPayments.get(i)).setSelected(false);
                        }
                        HippoLog.v("demo", "data = " + new Gson().toJson((Object)PaymentAdapter.this.hippoPayments));
                        PaymentAdapter.this.notifyDataSetChanged();
                    }
                }
            });
        }
    }
}

