package com.hippo.agent.fragment;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.Util.MessageMode;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.adapter.BroadcastDetailAdapter;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.helper.BroadcastListenerHelper;
import com.hippo.agent.listeners.BroadcastListener;
import com.hippo.agent.listeners.OnItemClickListener;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.broadcastResponse.BroadcastModel;
import com.hippo.agent.model.broadcastStatus.BroadCastObjectModel;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.agent.model.broadcastStatus.BroadcastUser;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.retrofit.CommonParams;
import com.hippo.utils.DateUtils;
import com.hippo.utils.loadingBox.LoadingBox;

import java.util.ArrayList;

/**
 * Created by gurmail on 20/02/19.
 *
 * @author gurmail
 */
public class BroadcastDetailsFragment extends BaseFragment implements BroadcastListener.BroadcastResponse, OnItemClickListener {

    private static final String TAG = BroadcastDetailsFragment.class.getSimpleName();
    private BroadcastListener broadcastListener;

    private UserData userData;
    private HippoColorConfig hippoColorConfig;
    private AgentBroadcastActivity activity;
    private BroadcastDetailAdapter detailAdapter;
    private BroadCastObjectModel objectModel;
    private LinearLayoutManager layoutManager;

    private NestedScrollView nestedScrollView;
    private RecyclerView recyclerView;
    private RelativeLayout rlFallback, layoutType;
    private TextView textViewFrom, textViewDate, textViewTitle, textViewMsg, textViewFallback, textViewType;
    private TextView textViewFromValue, textViewDateValue, textViewTitleValue, textViewMsgValue, textViewFallbackValue, textViewTypeValue;


    private ArrayList<BroadcastUser> broadcastUsers = new ArrayList<>();

    private String STANDARD_DATE_FORMAT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String OUTPUT_FORMAT = "MMM dd, yyyy, hh:mm a";

    private int pastVisiblesItems, visibleItemCount, totalItemCount;
    private boolean hasMorePages;
    private boolean isPagingApiInProgress;
    private int offset = 0;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            objectModel = (BroadCastObjectModel) getArguments().getSerializable("objectModel");
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hippo_activity_broadcast_details, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        broadcastListener = new BroadcastListenerHelper();
        activity = (AgentBroadcastActivity) getActivity();
        activity.updateToolBar(getResources().getString(R.string.hippo_broadcast_detail));
        hippoColorConfig = CommonData.getColorConfig();
        broadcastListener = new BroadcastListenerHelper();

        nestedScrollView = view.findViewById(R.id.nestedScrollView);
        recyclerView = view.findViewById(R.id.recyclerView);

        rlFallback = view.findViewById(R.id.rlFallback);
        layoutType = view.findViewById(R.id.layoutType);

        initView(view);

        textViewFromValue.setText(objectModel.getFullName());
        String localDate = DateUtils.getInstance().convertToLocal(objectModel.getCreatedAt(), STANDARD_DATE_FORMAT_TZ, OUTPUT_FORMAT);
        textViewDateValue.setText(localDate);
        textViewTitleValue.setText(objectModel.getBroadcastTitle());

        Utils.setColor(getActivity(), textViewMsgValue, objectModel.getMessage());

        if (!TextUtils.isEmpty(objectModel.getFallbackText())) {
            textViewFallbackValue.setText(objectModel.getFallbackText());
            rlFallback.setVisibility(View.VISIBLE);
        } else {
            rlFallback.setVisibility(View.GONE);
        }

        if (!TextUtils.isEmpty(objectModel.getBroadcastType())) {
            layoutType.setVisibility(View.VISIBLE);
            if (objectModel.getBroadcastType().equalsIgnoreCase("email")) {
                textViewTypeValue.setText("Email");
            } else {
                textViewTypeValue.setText("In App");
            }
        } else {
            layoutType.setVisibility(View.GONE);
        }

        detailAdapter = new BroadcastDetailAdapter(recyclerView, this);

        layoutManager = new LinearLayoutManager(getActivity());
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        recyclerView.setLayoutManager(layoutManager);

        recyclerView.setAdapter(detailAdapter);
        getBroadcastStatusList(0);

        nestedScrollView.setOnScrollChangeListener(new NestedScrollView.OnScrollChangeListener() {
            @Override
            public void onScrollChange(NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                if (v.getChildAt(v.getChildCount() - 1) != null) {
                    if ((scrollY >= (v.getChildAt(v.getChildCount() - 1).getMeasuredHeight() - v.getMeasuredHeight())) &&
                            scrollY > oldScrollY) {
                        //code to fetch more data for endless scrolling
                        visibleItemCount = layoutManager.getChildCount();
                        totalItemCount = layoutManager.getItemCount();
                        pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                        if (!isPagingApiInProgress && hasMorePages) {
                            if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                                getBroadcastStatusList(broadcastUsers.size());
                            }
                        }
                    }
                }
            }
        });

        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    visibleItemCount = layoutManager.getChildCount();
                    totalItemCount = layoutManager.getItemCount();
                    pastVisiblesItems = layoutManager.findFirstVisibleItemPosition();

                    if (!isPagingApiInProgress && hasMorePages) {
                        if ((visibleItemCount + pastVisiblesItems) >= totalItemCount) {
                            getBroadcastStatusList(broadcastUsers.size());
                        }
                    }
                }
            }
        });

    }

    private void initView(View view) {
        textViewFrom = view.findViewById(R.id.textViewFrom);
        textViewDate = view.findViewById(R.id.textViewDate);
        textViewTitle = view.findViewById(R.id.textViewTitle);
        textViewMsg = view.findViewById(R.id.textViewMsg);
        textViewFallback = view.findViewById(R.id.textViewFallback);
        textViewType = view.findViewById(R.id.textViewType);

        textViewFromValue = view.findViewById(R.id.textViewFromValue);
        textViewDateValue = view.findViewById(R.id.textViewDateValue);
        textViewTitleValue = view.findViewById(R.id.textViewTitleValue);
        textViewMsgValue = view.findViewById(R.id.textViewMsgValue);
        textViewFallbackValue = view.findViewById(R.id.textViewFallbackValue);
        textViewTypeValue = view.findViewById(R.id.textViewTypeValue);

        textViewFrom.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
        textViewDate.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
        textViewTitle.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
        textViewMsg.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
        textViewFallback.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
        textViewType.setTextColor(hippoColorConfig.getHippoTextColorSecondary());

        textViewFromValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
        textViewDateValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
        textViewTitleValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
        textViewMsgValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
        textViewFallbackValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
        textViewTypeValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
    }

    private void getBroadcastStatusList(int offset) {
        this.offset = offset;
        if (userData == null)
            userData = AgentCommonData.getUserData();
        String accessToken = userData.getAccessToken();
        if (offset != 0) {
            isPagingApiInProgress = true;
            detailAdapter.showPaginationProgressBar(true, true);
        } else {
            LoadingBox.showOn(getActivity());
        }

        CommonParams commonParams = new CommonParams.Builder()
                .add("access_token", accessToken)
                .add("channel_id", objectModel.getChannelId())
                .add("page_offset", offset)
                .build();

        broadcastListener.getBroadcastStatus(commonParams.getMap(), this);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        broadcastListener = null;
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden)
            activity.updateToolBar(getResources().getString(R.string.hippo_broadcast_detail));
    }

    @Override
    public void groupingResponse(BroadcastModel broadcastModel) {

    }

    @Override
    public void sendBroadcastResponse(BroadcastResponseModel responseModel) {

    }

    @Override
    public void broadcastListResponse(BroadcastResponseModel responseModel) {

    }

    @Override
    public void broadcastStatusResponse(BroadcastResponseModel responseModel) {
        LoadingBox.hide();
        if (offset != 0) {
            isPagingApiInProgress = false;
            detailAdapter.showPaginationProgressBar(false, true);
        }

        if (broadcastUsers == null)
            broadcastUsers = new ArrayList<>();

        if (offset == 0)
            broadcastUsers.clear();

        broadcastUsers.addAll(responseModel.getData().getBroadcastUsers());

        detailAdapter.setData(broadcastUsers);
        hasMorePages = responseModel.getData().getBroadcastUsers().size() == responseModel.getData().getPageSize();

    }

    @Override
    public void onFailure(int type, String errorMessage) {

    }

    @Override
    public void onClickItem(int position) {
        String channelId = broadcastUsers.get(position).getRepliedOn();
        if (!TextUtils.isEmpty(channelId)) {
            Conversation conversation = new Conversation();
            conversation.setChannelId(Long.parseLong(channelId));
            conversation.setUserId(broadcastUsers.get(position).getUserId());
//            conversation.setLabel(intent.getStringExtra("label"));
            conversation.setStatus(MessageMode.OPEN_CHAT.getOrdinal());
            conversation.setDisableReply(0);

            Intent chatIntent = new Intent(activity, AgentChatActivity.class);
            chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
            startActivityForResult(chatIntent, 100);
        }
    }
}